# NOTE: Assertions have been autogenerated by utils/update_mca_test_checks.py
# RUN: llvm-mca -mtriple=riscv64 -mcpu=spacemit-x60 -iterations=1 -instruction-tables=full < %s | FileCheck %s

# Zalrsc
lr.w t0, (t1)
lr.w.aq t1, (t2)
lr.w.rl t2, (t3)
lr.w.aqrl t3, (t4)
sc.w t6, t5, (t4)
sc.w.aq t5, t4, (t3)
sc.w.rl t4, t3, (t2)
sc.w.aqrl t3, t2, (t1)

lr.d t0, (t1)
lr.d.aq t1, (t2)
lr.d.rl t2, (t3)
lr.d.aqrl t3, (t4)
sc.d t6, t5, (t4)
sc.d.aq t5, t4, (t3)
sc.d.rl t4, t3, (t2)
sc.d.aqrl t3, t2, (t1)

# Zaamo
amoswap.w a4, ra, (s0)
amoadd.w a1, a2, (a3)
amoxor.w a2, a3, (a4)
amoand.w a3, a4, (a5)
amoor.w a4, a5, (a6)
amomin.w a5, a6, (a7)
amomax.w s7, s6, (s5)
amominu.w s6, s5, (s4)
amomaxu.w s5, s4, (s3)

amoswap.w.aq a4, ra, (s0)
amoadd.w.aq a1, a2, (a3)
amoxor.w.aq a2, a3, (a4)
amoand.w.aq a3, a4, (a5)
amoor.w.aq a4, a5, (a6)
amomin.w.aq a5, a6, (a7)
amomax.w.aq s7, s6, (s5)
amominu.w.aq s6, s5, (s4)
amomaxu.w.aq s5, s4, (s3)

amoswap.w.rl a4, ra, (s0)
amoadd.w.rl a1, a2, (a3)
amoxor.w.rl a2, a3, (a4)
amoand.w.rl a3, a4, (a5)
amoor.w.rl a4, a5, (a6)
amomin.w.rl a5, a6, (a7)
amomax.w.rl s7, s6, (s5)
amominu.w.rl s6, s5, (s4)
amomaxu.w.rl s5, s4, (s3)

amoswap.w.aqrl a4, ra, (s0)
amoadd.w.aqrl a1, a2, (a3)
amoxor.w.aqrl a2, a3, (a4)
amoand.w.aqrl a3, a4, (a5)
amoor.w.aqrl a4, a5, (a6)
amomin.w.aqrl a5, a6, (a7)
amomax.w.aqrl s7, s6, (s5)
amominu.w.aqrl s6, s5, (s4)
amomaxu.w.aqrl s5, s4, (s3)

amoswap.d a4, ra, (s0)
amoadd.d a1, a2, (a3)
amoxor.d a2, a3, (a4)
amoand.d a3, a4, (a5)
amoor.d a4, a5, (a6)
amomin.d a5, a6, (a7)
amomax.d s7, s6, (s5)
amominu.d s6, s5, (s4)
amomaxu.d s5, s4, (s3)

amoswap.d.aq a4, ra, (s0)
amoadd.d.aq a1, a2, (a3)
amoxor.d.aq a2, a3, (a4)
amoand.d.aq a3, a4, (a5)
amoor.d.aq a4, a5, (a6)
amomin.d.aq a5, a6, (a7)
amomax.d.aq s7, s6, (s5)
amominu.d.aq s6, s5, (s4)
amomaxu.d.aq s5, s4, (s3)

amoswap.d.rl a4, ra, (s0)
amoadd.d.rl a1, a2, (a3)
amoxor.d.rl a2, a3, (a4)
amoand.d.rl a3, a4, (a5)
amoor.d.rl a4, a5, (a6)
amomin.d.rl a5, a6, (a7)
amomax.d.rl s7, s6, (s5)
amominu.d.rl s6, s5, (s4)
amomaxu.d.rl s5, s4, (s3)

amoswap.d.aqrl a4, ra, (s0)
amoadd.d.aqrl a1, a2, (a3)
amoxor.d.aqrl a2, a3, (a4)
amoand.d.aqrl a3, a4, (a5)
amoor.d.aqrl a4, a5, (a6)
amomin.d.aqrl a5, a6, (a7)
amomax.d.aqrl s7, s6, (s5)
amominu.d.aqrl s6, s5, (s4)
amomaxu.d.aqrl s5, s4, (s3)

# CHECK:      Resources:
# CHECK-NEXT: [0]   - SMX60_FP:1
# CHECK-NEXT: [1]   - SMX60_IEU:2 SMX60_IEUA, SMX60_IEUB
# CHECK-NEXT: [2]   - SMX60_IEUA:1
# CHECK-NEXT: [3]   - SMX60_IEUB:1
# CHECK-NEXT: [4]   - SMX60_LS:2

# CHECK:      Instruction Info:
# CHECK-NEXT: [1]: #uOps
# CHECK-NEXT: [2]: Latency
# CHECK-NEXT: [3]: RThroughput
# CHECK-NEXT: [4]: MayLoad
# CHECK-NEXT: [5]: MayStore
# CHECK-NEXT: [6]: HasSideEffects (U)
# CHECK-NEXT: [7]: Bypass Latency
# CHECK-NEXT: [8]: Resources (<Name> | <Name>[<ReleaseAtCycle>] | <Name>[<AcquireAtCycle>,<ReleaseAtCycle])
# CHECK-NEXT: [9]: LLVM Opcode Name

# CHECK:      [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]                                        [9]                        Instructions:
# CHECK-NEXT:  1      8     0.50    *                    8     SMX60_LS                                   LR_W                       lr.w	t0, (t1)
# CHECK-NEXT:  1      8     0.50    *                    8     SMX60_LS                                   LR_W_AQ                    lr.w.aq	t1, (t2)
# CHECK-NEXT:  1      8     0.50    *                    8     SMX60_LS                                   LR_W_RL                    lr.w.rl	t2, (t3)
# CHECK-NEXT:  1      8     0.50    *                    8     SMX60_LS                                   LR_W_AQ_RL                 lr.w.aqrl	t3, (t4)
# CHECK-NEXT:  1      8     0.50           *             8     SMX60_LS                                   SC_W                       sc.w	t6, t5, (t4)
# CHECK-NEXT:  1      8     0.50           *             8     SMX60_LS                                   SC_W_AQ                    sc.w.aq	t5, t4, (t3)
# CHECK-NEXT:  1      8     0.50           *             8     SMX60_LS                                   SC_W_RL                    sc.w.rl	t4, t3, (t2)
# CHECK-NEXT:  1      8     0.50           *             8     SMX60_LS                                   SC_W_AQ_RL                 sc.w.aqrl	t3, t2, (t1)
# CHECK-NEXT:  1      8     0.50    *                    8     SMX60_LS                                   LR_D                       lr.d	t0, (t1)
# CHECK-NEXT:  1      8     0.50    *                    8     SMX60_LS                                   LR_D_AQ                    lr.d.aq	t1, (t2)
# CHECK-NEXT:  1      8     0.50    *                    8     SMX60_LS                                   LR_D_RL                    lr.d.rl	t2, (t3)
# CHECK-NEXT:  1      8     0.50    *                    8     SMX60_LS                                   LR_D_AQ_RL                 lr.d.aqrl	t3, (t4)
# CHECK-NEXT:  1      8     0.50           *             8     SMX60_LS                                   SC_D                       sc.d	t6, t5, (t4)
# CHECK-NEXT:  1      8     0.50           *             8     SMX60_LS                                   SC_D_AQ                    sc.d.aq	t5, t4, (t3)
# CHECK-NEXT:  1      8     0.50           *             8     SMX60_LS                                   SC_D_RL                    sc.d.rl	t4, t3, (t2)
# CHECK-NEXT:  1      8     0.50           *             8     SMX60_LS                                   SC_D_AQ_RL                 sc.d.aqrl	t3, t2, (t1)
# CHECK-NEXT:  1      12    0.50    *      *             12    SMX60_LS                                   AMOSWAP_W                  amoswap.w	a4, ra, (s0)
# CHECK-NEXT:  1      12    0.50    *      *             12    SMX60_LS                                   AMOADD_W                   amoadd.w	a1, a2, (a3)
# CHECK-NEXT:  1      12    0.50    *      *             12    SMX60_LS                                   AMOXOR_W                   amoxor.w	a2, a3, (a4)
# CHECK-NEXT:  1      12    0.50    *      *             12    SMX60_LS                                   AMOAND_W                   amoand.w	a3, a4, (a5)
# CHECK-NEXT:  1      12    0.50    *      *             12    SMX60_LS                                   AMOOR_W                    amoor.w	a4, a5, (a6)
# CHECK-NEXT:  1      12    0.50    *      *             12    SMX60_LS                                   AMOMIN_W                   amomin.w	a5, a6, (a7)
# CHECK-NEXT:  1      12    0.50    *      *             12    SMX60_LS                                   AMOMAX_W                   amomax.w	s7, s6, (s5)
# CHECK-NEXT:  1      12    0.50    *      *             12    SMX60_LS                                   AMOMINU_W                  amominu.w	s6, s5, (s4)
# CHECK-NEXT:  1      12    0.50    *      *             12    SMX60_LS                                   AMOMAXU_W                  amomaxu.w	s5, s4, (s3)
# CHECK-NEXT:  1      12    0.50    *      *             12    SMX60_LS                                   AMOSWAP_W_AQ               amoswap.w.aq	a4, ra, (s0)
# CHECK-NEXT:  1      12    0.50    *      *             12    SMX60_LS                                   AMOADD_W_AQ                amoadd.w.aq	a1, a2, (a3)
# CHECK-NEXT:  1      12    0.50    *      *             12    SMX60_LS                                   AMOXOR_W_AQ                amoxor.w.aq	a2, a3, (a4)
# CHECK-NEXT:  1      12    0.50    *      *             12    SMX60_LS                                   AMOAND_W_AQ                amoand.w.aq	a3, a4, (a5)
# CHECK-NEXT:  1      12    0.50    *      *             12    SMX60_LS                                   AMOOR_W_AQ                 amoor.w.aq	a4, a5, (a6)
# CHECK-NEXT:  1      12    0.50    *      *             12    SMX60_LS                                   AMOMIN_W_AQ                amomin.w.aq	a5, a6, (a7)
# CHECK-NEXT:  1      12    0.50    *      *             12    SMX60_LS                                   AMOMAX_W_AQ                amomax.w.aq	s7, s6, (s5)
# CHECK-NEXT:  1      12    0.50    *      *             12    SMX60_LS                                   AMOMINU_W_AQ               amominu.w.aq	s6, s5, (s4)
# CHECK-NEXT:  1      12    0.50    *      *             12    SMX60_LS                                   AMOMAXU_W_AQ               amomaxu.w.aq	s5, s4, (s3)
# CHECK-NEXT:  1      12    0.50    *      *             12    SMX60_LS                                   AMOSWAP_W_RL               amoswap.w.rl	a4, ra, (s0)
# CHECK-NEXT:  1      12    0.50    *      *             12    SMX60_LS                                   AMOADD_W_RL                amoadd.w.rl	a1, a2, (a3)
# CHECK-NEXT:  1      12    0.50    *      *             12    SMX60_LS                                   AMOXOR_W_RL                amoxor.w.rl	a2, a3, (a4)
# CHECK-NEXT:  1      12    0.50    *      *             12    SMX60_LS                                   AMOAND_W_RL                amoand.w.rl	a3, a4, (a5)
# CHECK-NEXT:  1      12    0.50    *      *             12    SMX60_LS                                   AMOOR_W_RL                 amoor.w.rl	a4, a5, (a6)
# CHECK-NEXT:  1      12    0.50    *      *             12    SMX60_LS                                   AMOMIN_W_RL                amomin.w.rl	a5, a6, (a7)
# CHECK-NEXT:  1      12    0.50    *      *             12    SMX60_LS                                   AMOMAX_W_RL                amomax.w.rl	s7, s6, (s5)
# CHECK-NEXT:  1      12    0.50    *      *             12    SMX60_LS                                   AMOMINU_W_RL               amominu.w.rl	s6, s5, (s4)
# CHECK-NEXT:  1      12    0.50    *      *             12    SMX60_LS                                   AMOMAXU_W_RL               amomaxu.w.rl	s5, s4, (s3)
# CHECK-NEXT:  1      12    0.50    *      *             12    SMX60_LS                                   AMOSWAP_W_AQ_RL            amoswap.w.aqrl	a4, ra, (s0)
# CHECK-NEXT:  1      12    0.50    *      *             12    SMX60_LS                                   AMOADD_W_AQ_RL             amoadd.w.aqrl	a1, a2, (a3)
# CHECK-NEXT:  1      12    0.50    *      *             12    SMX60_LS                                   AMOXOR_W_AQ_RL             amoxor.w.aqrl	a2, a3, (a4)
# CHECK-NEXT:  1      12    0.50    *      *             12    SMX60_LS                                   AMOAND_W_AQ_RL             amoand.w.aqrl	a3, a4, (a5)
# CHECK-NEXT:  1      12    0.50    *      *             12    SMX60_LS                                   AMOOR_W_AQ_RL              amoor.w.aqrl	a4, a5, (a6)
# CHECK-NEXT:  1      12    0.50    *      *             12    SMX60_LS                                   AMOMIN_W_AQ_RL             amomin.w.aqrl	a5, a6, (a7)
# CHECK-NEXT:  1      12    0.50    *      *             12    SMX60_LS                                   AMOMAX_W_AQ_RL             amomax.w.aqrl	s7, s6, (s5)
# CHECK-NEXT:  1      12    0.50    *      *             12    SMX60_LS                                   AMOMINU_W_AQ_RL            amominu.w.aqrl	s6, s5, (s4)
# CHECK-NEXT:  1      12    0.50    *      *             12    SMX60_LS                                   AMOMAXU_W_AQ_RL            amomaxu.w.aqrl	s5, s4, (s3)
# CHECK-NEXT:  1      12    0.50    *      *             12    SMX60_LS                                   AMOSWAP_D                  amoswap.d	a4, ra, (s0)
# CHECK-NEXT:  1      12    0.50    *      *             12    SMX60_LS                                   AMOADD_D                   amoadd.d	a1, a2, (a3)
# CHECK-NEXT:  1      12    0.50    *      *             12    SMX60_LS                                   AMOXOR_D                   amoxor.d	a2, a3, (a4)
# CHECK-NEXT:  1      12    0.50    *      *             12    SMX60_LS                                   AMOAND_D                   amoand.d	a3, a4, (a5)
# CHECK-NEXT:  1      12    0.50    *      *             12    SMX60_LS                                   AMOOR_D                    amoor.d	a4, a5, (a6)
# CHECK-NEXT:  1      12    0.50    *      *             12    SMX60_LS                                   AMOMIN_D                   amomin.d	a5, a6, (a7)
# CHECK-NEXT:  1      12    0.50    *      *             12    SMX60_LS                                   AMOMAX_D                   amomax.d	s7, s6, (s5)
# CHECK-NEXT:  1      12    0.50    *      *             12    SMX60_LS                                   AMOMINU_D                  amominu.d	s6, s5, (s4)
# CHECK-NEXT:  1      12    0.50    *      *             12    SMX60_LS                                   AMOMAXU_D                  amomaxu.d	s5, s4, (s3)
# CHECK-NEXT:  1      12    0.50    *      *             12    SMX60_LS                                   AMOSWAP_D_AQ               amoswap.d.aq	a4, ra, (s0)
# CHECK-NEXT:  1      12    0.50    *      *             12    SMX60_LS                                   AMOADD_D_AQ                amoadd.d.aq	a1, a2, (a3)
# CHECK-NEXT:  1      12    0.50    *      *             12    SMX60_LS                                   AMOXOR_D_AQ                amoxor.d.aq	a2, a3, (a4)
# CHECK-NEXT:  1      12    0.50    *      *             12    SMX60_LS                                   AMOAND_D_AQ                amoand.d.aq	a3, a4, (a5)
# CHECK-NEXT:  1      12    0.50    *      *             12    SMX60_LS                                   AMOOR_D_AQ                 amoor.d.aq	a4, a5, (a6)
# CHECK-NEXT:  1      12    0.50    *      *             12    SMX60_LS                                   AMOMIN_D_AQ                amomin.d.aq	a5, a6, (a7)
# CHECK-NEXT:  1      12    0.50    *      *             12    SMX60_LS                                   AMOMAX_D_AQ                amomax.d.aq	s7, s6, (s5)
# CHECK-NEXT:  1      12    0.50    *      *             12    SMX60_LS                                   AMOMINU_D_AQ               amominu.d.aq	s6, s5, (s4)
# CHECK-NEXT:  1      12    0.50    *      *             12    SMX60_LS                                   AMOMAXU_D_AQ               amomaxu.d.aq	s5, s4, (s3)
# CHECK-NEXT:  1      12    0.50    *      *             12    SMX60_LS                                   AMOSWAP_D_RL               amoswap.d.rl	a4, ra, (s0)
# CHECK-NEXT:  1      12    0.50    *      *             12    SMX60_LS                                   AMOADD_D_RL                amoadd.d.rl	a1, a2, (a3)
# CHECK-NEXT:  1      12    0.50    *      *             12    SMX60_LS                                   AMOXOR_D_RL                amoxor.d.rl	a2, a3, (a4)
# CHECK-NEXT:  1      12    0.50    *      *             12    SMX60_LS                                   AMOAND_D_RL                amoand.d.rl	a3, a4, (a5)
# CHECK-NEXT:  1      12    0.50    *      *             12    SMX60_LS                                   AMOOR_D_RL                 amoor.d.rl	a4, a5, (a6)
# CHECK-NEXT:  1      12    0.50    *      *             12    SMX60_LS                                   AMOMIN_D_RL                amomin.d.rl	a5, a6, (a7)
# CHECK-NEXT:  1      12    0.50    *      *             12    SMX60_LS                                   AMOMAX_D_RL                amomax.d.rl	s7, s6, (s5)
# CHECK-NEXT:  1      12    0.50    *      *             12    SMX60_LS                                   AMOMINU_D_RL               amominu.d.rl	s6, s5, (s4)
# CHECK-NEXT:  1      12    0.50    *      *             12    SMX60_LS                                   AMOMAXU_D_RL               amomaxu.d.rl	s5, s4, (s3)
# CHECK-NEXT:  1      12    0.50    *      *             12    SMX60_LS                                   AMOSWAP_D_AQ_RL            amoswap.d.aqrl	a4, ra, (s0)
# CHECK-NEXT:  1      12    0.50    *      *             12    SMX60_LS                                   AMOADD_D_AQ_RL             amoadd.d.aqrl	a1, a2, (a3)
# CHECK-NEXT:  1      12    0.50    *      *             12    SMX60_LS                                   AMOXOR_D_AQ_RL             amoxor.d.aqrl	a2, a3, (a4)
# CHECK-NEXT:  1      12    0.50    *      *             12    SMX60_LS                                   AMOAND_D_AQ_RL             amoand.d.aqrl	a3, a4, (a5)
# CHECK-NEXT:  1      12    0.50    *      *             12    SMX60_LS                                   AMOOR_D_AQ_RL              amoor.d.aqrl	a4, a5, (a6)
# CHECK-NEXT:  1      12    0.50    *      *             12    SMX60_LS                                   AMOMIN_D_AQ_RL             amomin.d.aqrl	a5, a6, (a7)
# CHECK-NEXT:  1      12    0.50    *      *             12    SMX60_LS                                   AMOMAX_D_AQ_RL             amomax.d.aqrl	s7, s6, (s5)
# CHECK-NEXT:  1      12    0.50    *      *             12    SMX60_LS                                   AMOMINU_D_AQ_RL            amominu.d.aqrl	s6, s5, (s4)
# CHECK-NEXT:  1      12    0.50    *      *             12    SMX60_LS                                   AMOMAXU_D_AQ_RL            amomaxu.d.aqrl	s5, s4, (s3)

# CHECK:      Resources:
# CHECK-NEXT: [0]   - SMX60_FP
# CHECK-NEXT: [1]   - SMX60_IEUA
# CHECK-NEXT: [2]   - SMX60_IEUB
# CHECK-NEXT: [3.0] - SMX60_LS
# CHECK-NEXT: [3.1] - SMX60_LS

# CHECK:      Resource pressure per iteration:
# CHECK-NEXT: [0]    [1]    [2]    [3.0]  [3.1]
# CHECK-NEXT:  -      -      -     44.00  44.00

# CHECK:      Resource pressure by instruction:
# CHECK-NEXT: [0]    [1]    [2]    [3.0]  [3.1]  Instructions:
# CHECK-NEXT:  -      -      -     0.50   0.50   lr.w	t0, (t1)
# CHECK-NEXT:  -      -      -     0.50   0.50   lr.w.aq	t1, (t2)
# CHECK-NEXT:  -      -      -     0.50   0.50   lr.w.rl	t2, (t3)
# CHECK-NEXT:  -      -      -     0.50   0.50   lr.w.aqrl	t3, (t4)
# CHECK-NEXT:  -      -      -     0.50   0.50   sc.w	t6, t5, (t4)
# CHECK-NEXT:  -      -      -     0.50   0.50   sc.w.aq	t5, t4, (t3)
# CHECK-NEXT:  -      -      -     0.50   0.50   sc.w.rl	t4, t3, (t2)
# CHECK-NEXT:  -      -      -     0.50   0.50   sc.w.aqrl	t3, t2, (t1)
# CHECK-NEXT:  -      -      -     0.50   0.50   lr.d	t0, (t1)
# CHECK-NEXT:  -      -      -     0.50   0.50   lr.d.aq	t1, (t2)
# CHECK-NEXT:  -      -      -     0.50   0.50   lr.d.rl	t2, (t3)
# CHECK-NEXT:  -      -      -     0.50   0.50   lr.d.aqrl	t3, (t4)
# CHECK-NEXT:  -      -      -     0.50   0.50   sc.d	t6, t5, (t4)
# CHECK-NEXT:  -      -      -     0.50   0.50   sc.d.aq	t5, t4, (t3)
# CHECK-NEXT:  -      -      -     0.50   0.50   sc.d.rl	t4, t3, (t2)
# CHECK-NEXT:  -      -      -     0.50   0.50   sc.d.aqrl	t3, t2, (t1)
# CHECK-NEXT:  -      -      -     0.50   0.50   amoswap.w	a4, ra, (s0)
# CHECK-NEXT:  -      -      -     0.50   0.50   amoadd.w	a1, a2, (a3)
# CHECK-NEXT:  -      -      -     0.50   0.50   amoxor.w	a2, a3, (a4)
# CHECK-NEXT:  -      -      -     0.50   0.50   amoand.w	a3, a4, (a5)
# CHECK-NEXT:  -      -      -     0.50   0.50   amoor.w	a4, a5, (a6)
# CHECK-NEXT:  -      -      -     0.50   0.50   amomin.w	a5, a6, (a7)
# CHECK-NEXT:  -      -      -     0.50   0.50   amomax.w	s7, s6, (s5)
# CHECK-NEXT:  -      -      -     0.50   0.50   amominu.w	s6, s5, (s4)
# CHECK-NEXT:  -      -      -     0.50   0.50   amomaxu.w	s5, s4, (s3)
# CHECK-NEXT:  -      -      -     0.50   0.50   amoswap.w.aq	a4, ra, (s0)
# CHECK-NEXT:  -      -      -     0.50   0.50   amoadd.w.aq	a1, a2, (a3)
# CHECK-NEXT:  -      -      -     0.50   0.50   amoxor.w.aq	a2, a3, (a4)
# CHECK-NEXT:  -      -      -     0.50   0.50   amoand.w.aq	a3, a4, (a5)
# CHECK-NEXT:  -      -      -     0.50   0.50   amoor.w.aq	a4, a5, (a6)
# CHECK-NEXT:  -      -      -     0.50   0.50   amomin.w.aq	a5, a6, (a7)
# CHECK-NEXT:  -      -      -     0.50   0.50   amomax.w.aq	s7, s6, (s5)
# CHECK-NEXT:  -      -      -     0.50   0.50   amominu.w.aq	s6, s5, (s4)
# CHECK-NEXT:  -      -      -     0.50   0.50   amomaxu.w.aq	s5, s4, (s3)
# CHECK-NEXT:  -      -      -     0.50   0.50   amoswap.w.rl	a4, ra, (s0)
# CHECK-NEXT:  -      -      -     0.50   0.50   amoadd.w.rl	a1, a2, (a3)
# CHECK-NEXT:  -      -      -     0.50   0.50   amoxor.w.rl	a2, a3, (a4)
# CHECK-NEXT:  -      -      -     0.50   0.50   amoand.w.rl	a3, a4, (a5)
# CHECK-NEXT:  -      -      -     0.50   0.50   amoor.w.rl	a4, a5, (a6)
# CHECK-NEXT:  -      -      -     0.50   0.50   amomin.w.rl	a5, a6, (a7)
# CHECK-NEXT:  -      -      -     0.50   0.50   amomax.w.rl	s7, s6, (s5)
# CHECK-NEXT:  -      -      -     0.50   0.50   amominu.w.rl	s6, s5, (s4)
# CHECK-NEXT:  -      -      -     0.50   0.50   amomaxu.w.rl	s5, s4, (s3)
# CHECK-NEXT:  -      -      -     0.50   0.50   amoswap.w.aqrl	a4, ra, (s0)
# CHECK-NEXT:  -      -      -     0.50   0.50   amoadd.w.aqrl	a1, a2, (a3)
# CHECK-NEXT:  -      -      -     0.50   0.50   amoxor.w.aqrl	a2, a3, (a4)
# CHECK-NEXT:  -      -      -     0.50   0.50   amoand.w.aqrl	a3, a4, (a5)
# CHECK-NEXT:  -      -      -     0.50   0.50   amoor.w.aqrl	a4, a5, (a6)
# CHECK-NEXT:  -      -      -     0.50   0.50   amomin.w.aqrl	a5, a6, (a7)
# CHECK-NEXT:  -      -      -     0.50   0.50   amomax.w.aqrl	s7, s6, (s5)
# CHECK-NEXT:  -      -      -     0.50   0.50   amominu.w.aqrl	s6, s5, (s4)
# CHECK-NEXT:  -      -      -     0.50   0.50   amomaxu.w.aqrl	s5, s4, (s3)
# CHECK-NEXT:  -      -      -     0.50   0.50   amoswap.d	a4, ra, (s0)
# CHECK-NEXT:  -      -      -     0.50   0.50   amoadd.d	a1, a2, (a3)
# CHECK-NEXT:  -      -      -     0.50   0.50   amoxor.d	a2, a3, (a4)
# CHECK-NEXT:  -      -      -     0.50   0.50   amoand.d	a3, a4, (a5)
# CHECK-NEXT:  -      -      -     0.50   0.50   amoor.d	a4, a5, (a6)
# CHECK-NEXT:  -      -      -     0.50   0.50   amomin.d	a5, a6, (a7)
# CHECK-NEXT:  -      -      -     0.50   0.50   amomax.d	s7, s6, (s5)
# CHECK-NEXT:  -      -      -     0.50   0.50   amominu.d	s6, s5, (s4)
# CHECK-NEXT:  -      -      -     0.50   0.50   amomaxu.d	s5, s4, (s3)
# CHECK-NEXT:  -      -      -     0.50   0.50   amoswap.d.aq	a4, ra, (s0)
# CHECK-NEXT:  -      -      -     0.50   0.50   amoadd.d.aq	a1, a2, (a3)
# CHECK-NEXT:  -      -      -     0.50   0.50   amoxor.d.aq	a2, a3, (a4)
# CHECK-NEXT:  -      -      -     0.50   0.50   amoand.d.aq	a3, a4, (a5)
# CHECK-NEXT:  -      -      -     0.50   0.50   amoor.d.aq	a4, a5, (a6)
# CHECK-NEXT:  -      -      -     0.50   0.50   amomin.d.aq	a5, a6, (a7)
# CHECK-NEXT:  -      -      -     0.50   0.50   amomax.d.aq	s7, s6, (s5)
# CHECK-NEXT:  -      -      -     0.50   0.50   amominu.d.aq	s6, s5, (s4)
# CHECK-NEXT:  -      -      -     0.50   0.50   amomaxu.d.aq	s5, s4, (s3)
# CHECK-NEXT:  -      -      -     0.50   0.50   amoswap.d.rl	a4, ra, (s0)
# CHECK-NEXT:  -      -      -     0.50   0.50   amoadd.d.rl	a1, a2, (a3)
# CHECK-NEXT:  -      -      -     0.50   0.50   amoxor.d.rl	a2, a3, (a4)
# CHECK-NEXT:  -      -      -     0.50   0.50   amoand.d.rl	a3, a4, (a5)
# CHECK-NEXT:  -      -      -     0.50   0.50   amoor.d.rl	a4, a5, (a6)
# CHECK-NEXT:  -      -      -     0.50   0.50   amomin.d.rl	a5, a6, (a7)
# CHECK-NEXT:  -      -      -     0.50   0.50   amomax.d.rl	s7, s6, (s5)
# CHECK-NEXT:  -      -      -     0.50   0.50   amominu.d.rl	s6, s5, (s4)
# CHECK-NEXT:  -      -      -     0.50   0.50   amomaxu.d.rl	s5, s4, (s3)
# CHECK-NEXT:  -      -      -     0.50   0.50   amoswap.d.aqrl	a4, ra, (s0)
# CHECK-NEXT:  -      -      -     0.50   0.50   amoadd.d.aqrl	a1, a2, (a3)
# CHECK-NEXT:  -      -      -     0.50   0.50   amoxor.d.aqrl	a2, a3, (a4)
# CHECK-NEXT:  -      -      -     0.50   0.50   amoand.d.aqrl	a3, a4, (a5)
# CHECK-NEXT:  -      -      -     0.50   0.50   amoor.d.aqrl	a4, a5, (a6)
# CHECK-NEXT:  -      -      -     0.50   0.50   amomin.d.aqrl	a5, a6, (a7)
# CHECK-NEXT:  -      -      -     0.50   0.50   amomax.d.aqrl	s7, s6, (s5)
# CHECK-NEXT:  -      -      -     0.50   0.50   amominu.d.aqrl	s6, s5, (s4)
# CHECK-NEXT:  -      -      -     0.50   0.50   amomaxu.d.aqrl	s5, s4, (s3)
