; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=aarch64-unknown-linux-gnu < %s | FileCheck %s

; shift left

define i32 @and_signbit_select_shl(i32 %x, i1 %cond, ptr %dst) {
; CHECK-LABEL: and_signbit_select_shl:
; CHECK:       // %bb.0:
; CHECK-NEXT:    and w8, w0, #0xff0000
; CHECK-NEXT:    tst w1, #0x1
; CHECK-NEXT:    csel w8, w8, w0, ne
; CHECK-NEXT:    lsl w0, w8, #8
; CHECK-NEXT:    str w0, [x2]
; CHECK-NEXT:    ret
  %t0 = and i32 %x, 4294901760 ; 0xFFFF0000
  %t1 = select i1 %cond, i32 %t0, i32 %x
  %r = shl i32 %t1, 8
  store i32 %r, ptr %dst
  ret i32 %r
}
define i32 @and_nosignbit_select_shl(i32 %x, i1 %cond, ptr %dst) {
; CHECK-LABEL: and_nosignbit_select_shl:
; CHECK:       // %bb.0:
; CHECK-NEXT:    and w8, w0, #0xff0000
; CHECK-NEXT:    tst w1, #0x1
; CHECK-NEXT:    csel w8, w8, w0, ne
; CHECK-NEXT:    lsl w0, w8, #8
; CHECK-NEXT:    str w0, [x2]
; CHECK-NEXT:    ret
  %t0 = and i32 %x, 2147418112 ; 0x7FFF0000
  %t1 = select i1 %cond, i32 %t0, i32 %x
  %r = shl i32 %t1, 8
  store i32 %r, ptr %dst
  ret i32 %r
}

define i32 @or_signbit_select_shl(i32 %x, i1 %cond, ptr %dst) {
; CHECK-LABEL: or_signbit_select_shl:
; CHECK:       // %bb.0:
; CHECK-NEXT:    orr w8, w0, #0xff0000
; CHECK-NEXT:    tst w1, #0x1
; CHECK-NEXT:    csel w8, w8, w0, ne
; CHECK-NEXT:    lsl w0, w8, #8
; CHECK-NEXT:    str w0, [x2]
; CHECK-NEXT:    ret
  %t0 = or i32 %x, 4294901760 ; 0xFFFF0000
  %t1 = select i1 %cond, i32 %t0, i32 %x
  %r = shl i32 %t1, 8
  store i32 %r, ptr %dst
  ret i32 %r
}
define i32 @or_nosignbit_select_shl(i32 %x, i1 %cond, ptr %dst) {
; CHECK-LABEL: or_nosignbit_select_shl:
; CHECK:       // %bb.0:
; CHECK-NEXT:    orr w8, w0, #0xff0000
; CHECK-NEXT:    tst w1, #0x1
; CHECK-NEXT:    csel w8, w8, w0, ne
; CHECK-NEXT:    lsl w0, w8, #8
; CHECK-NEXT:    str w0, [x2]
; CHECK-NEXT:    ret
  %t0 = or i32 %x, 2147418112 ; 0x7FFF0000
  %t1 = select i1 %cond, i32 %t0, i32 %x
  %r = shl i32 %t1, 8
  store i32 %r, ptr %dst
  ret i32 %r
}

define i32 @xor_signbit_select_shl(i32 %x, i1 %cond, ptr %dst) {
; CHECK-LABEL: xor_signbit_select_shl:
; CHECK:       // %bb.0:
; CHECK-NEXT:    eor w8, w0, #0xff0000
; CHECK-NEXT:    tst w1, #0x1
; CHECK-NEXT:    csel w8, w8, w0, ne
; CHECK-NEXT:    lsl w0, w8, #8
; CHECK-NEXT:    str w0, [x2]
; CHECK-NEXT:    ret
  %t0 = xor i32 %x, 4294901760 ; 0xFFFF0000
  %t1 = select i1 %cond, i32 %t0, i32 %x
  %r = shl i32 %t1, 8
  store i32 %r, ptr %dst
  ret i32 %r
}
define i32 @xor_nosignbit_select_shl(i32 %x, i1 %cond, ptr %dst) {
; CHECK-LABEL: xor_nosignbit_select_shl:
; CHECK:       // %bb.0:
; CHECK-NEXT:    eor w8, w0, #0xff0000
; CHECK-NEXT:    tst w1, #0x1
; CHECK-NEXT:    csel w8, w8, w0, ne
; CHECK-NEXT:    lsl w0, w8, #8
; CHECK-NEXT:    str w0, [x2]
; CHECK-NEXT:    ret
  %t0 = xor i32 %x, 2147418112 ; 0x7FFF0000
  %t1 = select i1 %cond, i32 %t0, i32 %x
  %r = shl i32 %t1, 8
  store i32 %r, ptr %dst
  ret i32 %r
}

define i32 @add_signbit_select_shl(i32 %x, i1 %cond, ptr %dst) {
; CHECK-LABEL: add_signbit_select_shl:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sub w8, w0, #16, lsl #12 // =65536
; CHECK-NEXT:    tst w1, #0x1
; CHECK-NEXT:    csel w8, w8, w0, ne
; CHECK-NEXT:    lsl w0, w8, #8
; CHECK-NEXT:    str w0, [x2]
; CHECK-NEXT:    ret
  %t0 = add i32 %x, 4294901760 ; 0xFFFF0000
  %t1 = select i1 %cond, i32 %t0, i32 %x
  %r = shl i32 %t1, 8
  store i32 %r, ptr %dst
  ret i32 %r
}
define i32 @add_nosignbit_select_shl(i32 %x, i1 %cond, ptr %dst) {
; CHECK-LABEL: add_nosignbit_select_shl:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #2147418112
; CHECK-NEXT:    tst w1, #0x1
; CHECK-NEXT:    add w8, w0, w8
; CHECK-NEXT:    csel w8, w8, w0, ne
; CHECK-NEXT:    lsl w0, w8, #8
; CHECK-NEXT:    str w0, [x2]
; CHECK-NEXT:    ret
  %t0 = add i32 %x, 2147418112 ; 0x7FFF0000
  %t1 = select i1 %cond, i32 %t0, i32 %x
  %r = shl i32 %t1, 8
  store i32 %r, ptr %dst
  ret i32 %r
}

; logical shift right

define i32 @and_signbit_select_lshr(i32 %x, i1 %cond, ptr %dst) {
; CHECK-LABEL: and_signbit_select_lshr:
; CHECK:       // %bb.0:
; CHECK-NEXT:    and w8, w0, #0xffff0000
; CHECK-NEXT:    tst w1, #0x1
; CHECK-NEXT:    csel w8, w8, w0, ne
; CHECK-NEXT:    lsr w0, w8, #8
; CHECK-NEXT:    str w0, [x2]
; CHECK-NEXT:    ret
  %t0 = and i32 %x, 4294901760 ; 0xFFFF0000
  %t1 = select i1 %cond, i32 %t0, i32 %x
  %r = lshr i32 %t1, 8
  store i32 %r, ptr %dst
  ret i32 %r
}
define i32 @and_nosignbit_select_lshr(i32 %x, i1 %cond, ptr %dst) {
; CHECK-LABEL: and_nosignbit_select_lshr:
; CHECK:       // %bb.0:
; CHECK-NEXT:    and w8, w0, #0x7fff0000
; CHECK-NEXT:    tst w1, #0x1
; CHECK-NEXT:    csel w8, w8, w0, ne
; CHECK-NEXT:    lsr w0, w8, #8
; CHECK-NEXT:    str w0, [x2]
; CHECK-NEXT:    ret
  %t0 = and i32 %x, 2147418112 ; 0x7FFF0000
  %t1 = select i1 %cond, i32 %t0, i32 %x
  %r = lshr i32 %t1, 8
  store i32 %r, ptr %dst
  ret i32 %r
}

define i32 @or_signbit_select_lshr(i32 %x, i1 %cond, ptr %dst) {
; CHECK-LABEL: or_signbit_select_lshr:
; CHECK:       // %bb.0:
; CHECK-NEXT:    orr w8, w0, #0xffff0000
; CHECK-NEXT:    tst w1, #0x1
; CHECK-NEXT:    csel w8, w8, w0, ne
; CHECK-NEXT:    lsr w0, w8, #8
; CHECK-NEXT:    str w0, [x2]
; CHECK-NEXT:    ret
  %t0 = or i32 %x, 4294901760 ; 0xFFFF0000
  %t1 = select i1 %cond, i32 %t0, i32 %x
  %r = lshr i32 %t1, 8
  store i32 %r, ptr %dst
  ret i32 %r
}
define i32 @or_nosignbit_select_lshr(i32 %x, i1 %cond, ptr %dst) {
; CHECK-LABEL: or_nosignbit_select_lshr:
; CHECK:       // %bb.0:
; CHECK-NEXT:    orr w8, w0, #0x7fff0000
; CHECK-NEXT:    tst w1, #0x1
; CHECK-NEXT:    csel w8, w8, w0, ne
; CHECK-NEXT:    lsr w0, w8, #8
; CHECK-NEXT:    str w0, [x2]
; CHECK-NEXT:    ret
  %t0 = or i32 %x, 2147418112 ; 0x7FFF0000
  %t1 = select i1 %cond, i32 %t0, i32 %x
  %r = lshr i32 %t1, 8
  store i32 %r, ptr %dst
  ret i32 %r
}

define i32 @xor_signbit_select_lshr(i32 %x, i1 %cond, ptr %dst) {
; CHECK-LABEL: xor_signbit_select_lshr:
; CHECK:       // %bb.0:
; CHECK-NEXT:    eor w8, w0, #0xffff0000
; CHECK-NEXT:    tst w1, #0x1
; CHECK-NEXT:    csel w8, w8, w0, ne
; CHECK-NEXT:    lsr w0, w8, #8
; CHECK-NEXT:    str w0, [x2]
; CHECK-NEXT:    ret
  %t0 = xor i32 %x, 4294901760 ; 0xFFFF0000
  %t1 = select i1 %cond, i32 %t0, i32 %x
  %r = lshr i32 %t1, 8
  store i32 %r, ptr %dst
  ret i32 %r
}
define i32 @xor_nosignbit_select_lshr(i32 %x, i1 %cond, ptr %dst) {
; CHECK-LABEL: xor_nosignbit_select_lshr:
; CHECK:       // %bb.0:
; CHECK-NEXT:    eor w8, w0, #0x7fff0000
; CHECK-NEXT:    tst w1, #0x1
; CHECK-NEXT:    csel w8, w8, w0, ne
; CHECK-NEXT:    lsr w0, w8, #8
; CHECK-NEXT:    str w0, [x2]
; CHECK-NEXT:    ret
  %t0 = xor i32 %x, 2147418112 ; 0x7FFF0000
  %t1 = select i1 %cond, i32 %t0, i32 %x
  %r = lshr i32 %t1, 8
  store i32 %r, ptr %dst
  ret i32 %r
}

define i32 @add_signbit_select_lshr(i32 %x, i1 %cond, ptr %dst) {
; CHECK-LABEL: add_signbit_select_lshr:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sub w8, w0, #16, lsl #12 // =65536
; CHECK-NEXT:    tst w1, #0x1
; CHECK-NEXT:    csel w8, w8, w0, ne
; CHECK-NEXT:    lsr w0, w8, #8
; CHECK-NEXT:    str w0, [x2]
; CHECK-NEXT:    ret
  %t0 = add i32 %x, 4294901760 ; 0xFFFF0000
  %t1 = select i1 %cond, i32 %t0, i32 %x
  %r = lshr i32 %t1, 8
  store i32 %r, ptr %dst
  ret i32 %r
}
define i32 @add_nosignbit_select_lshr(i32 %x, i1 %cond, ptr %dst) {
; CHECK-LABEL: add_nosignbit_select_lshr:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #2147418112
; CHECK-NEXT:    tst w1, #0x1
; CHECK-NEXT:    add w8, w0, w8
; CHECK-NEXT:    csel w8, w8, w0, ne
; CHECK-NEXT:    lsr w0, w8, #8
; CHECK-NEXT:    str w0, [x2]
; CHECK-NEXT:    ret
  %t0 = add i32 %x, 2147418112 ; 0x7FFF0000
  %t1 = select i1 %cond, i32 %t0, i32 %x
  %r = lshr i32 %t1, 8
  store i32 %r, ptr %dst
  ret i32 %r
}

; arithmetic shift right

define i32 @and_signbit_select_ashr(i32 %x, i1 %cond, ptr %dst) {
; CHECK-LABEL: and_signbit_select_ashr:
; CHECK:       // %bb.0:
; CHECK-NEXT:    and w8, w0, #0xffff0000
; CHECK-NEXT:    tst w1, #0x1
; CHECK-NEXT:    csel w8, w8, w0, ne
; CHECK-NEXT:    asr w0, w8, #8
; CHECK-NEXT:    str w0, [x2]
; CHECK-NEXT:    ret
  %t0 = and i32 %x, 4294901760 ; 0xFFFF0000
  %t1 = select i1 %cond, i32 %t0, i32 %x
  %r = ashr i32 %t1, 8
  store i32 %r, ptr %dst
  ret i32 %r
}
define i32 @and_nosignbit_select_ashr(i32 %x, i1 %cond, ptr %dst) {
; CHECK-LABEL: and_nosignbit_select_ashr:
; CHECK:       // %bb.0:
; CHECK-NEXT:    and w8, w0, #0x7fff0000
; CHECK-NEXT:    tst w1, #0x1
; CHECK-NEXT:    csel w8, w8, w0, ne
; CHECK-NEXT:    asr w0, w8, #8
; CHECK-NEXT:    str w0, [x2]
; CHECK-NEXT:    ret
  %t0 = and i32 %x, 2147418112 ; 0x7FFF0000
  %t1 = select i1 %cond, i32 %t0, i32 %x
  %r = ashr i32 %t1, 8
  store i32 %r, ptr %dst
  ret i32 %r
}

define i32 @or_signbit_select_ashr(i32 %x, i1 %cond, ptr %dst) {
; CHECK-LABEL: or_signbit_select_ashr:
; CHECK:       // %bb.0:
; CHECK-NEXT:    orr w8, w0, #0xffff0000
; CHECK-NEXT:    tst w1, #0x1
; CHECK-NEXT:    csel w8, w8, w0, ne
; CHECK-NEXT:    asr w0, w8, #8
; CHECK-NEXT:    str w0, [x2]
; CHECK-NEXT:    ret
  %t0 = or i32 %x, 4294901760 ; 0xFFFF0000
  %t1 = select i1 %cond, i32 %t0, i32 %x
  %r = ashr i32 %t1, 8
  store i32 %r, ptr %dst
  ret i32 %r
}
define i32 @or_nosignbit_select_ashr(i32 %x, i1 %cond, ptr %dst) {
; CHECK-LABEL: or_nosignbit_select_ashr:
; CHECK:       // %bb.0:
; CHECK-NEXT:    orr w8, w0, #0x7fff0000
; CHECK-NEXT:    tst w1, #0x1
; CHECK-NEXT:    csel w8, w8, w0, ne
; CHECK-NEXT:    asr w0, w8, #8
; CHECK-NEXT:    str w0, [x2]
; CHECK-NEXT:    ret
  %t0 = or i32 %x, 2147418112 ; 0x7FFF0000
  %t1 = select i1 %cond, i32 %t0, i32 %x
  %r = ashr i32 %t1, 8
  store i32 %r, ptr %dst
  ret i32 %r
}

define i32 @xor_signbit_select_ashr(i32 %x, i1 %cond, ptr %dst) {
; CHECK-LABEL: xor_signbit_select_ashr:
; CHECK:       // %bb.0:
; CHECK-NEXT:    eor w8, w0, #0xffff0000
; CHECK-NEXT:    tst w1, #0x1
; CHECK-NEXT:    csel w8, w8, w0, ne
; CHECK-NEXT:    asr w0, w8, #8
; CHECK-NEXT:    str w0, [x2]
; CHECK-NEXT:    ret
  %t0 = xor i32 %x, 4294901760 ; 0xFFFF0000
  %t1 = select i1 %cond, i32 %t0, i32 %x
  %r = ashr i32 %t1, 8
  store i32 %r, ptr %dst
  ret i32 %r
}
define i32 @xor_nosignbit_select_ashr(i32 %x, i1 %cond, ptr %dst) {
; CHECK-LABEL: xor_nosignbit_select_ashr:
; CHECK:       // %bb.0:
; CHECK-NEXT:    eor w8, w0, #0x7fff0000
; CHECK-NEXT:    tst w1, #0x1
; CHECK-NEXT:    csel w8, w8, w0, ne
; CHECK-NEXT:    asr w0, w8, #8
; CHECK-NEXT:    str w0, [x2]
; CHECK-NEXT:    ret
  %t0 = xor i32 %x, 2147418112 ; 0x7FFF0000
  %t1 = select i1 %cond, i32 %t0, i32 %x
  %r = ashr i32 %t1, 8
  store i32 %r, ptr %dst
  ret i32 %r
}

define i32 @add_signbit_select_ashr(i32 %x, i1 %cond, ptr %dst) {
; CHECK-LABEL: add_signbit_select_ashr:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sub w8, w0, #16, lsl #12 // =65536
; CHECK-NEXT:    tst w1, #0x1
; CHECK-NEXT:    csel w8, w8, w0, ne
; CHECK-NEXT:    asr w0, w8, #8
; CHECK-NEXT:    str w0, [x2]
; CHECK-NEXT:    ret
  %t0 = add i32 %x, 4294901760 ; 0xFFFF0000
  %t1 = select i1 %cond, i32 %t0, i32 %x
  %r = ashr i32 %t1, 8
  store i32 %r, ptr %dst
  ret i32 %r
}
define i32 @add_nosignbit_select_ashr(i32 %x, i1 %cond, ptr %dst) {
; CHECK-LABEL: add_nosignbit_select_ashr:
; CHECK:       // %bb.0:
; CHECK-NEXT:    mov w8, #2147418112
; CHECK-NEXT:    tst w1, #0x1
; CHECK-NEXT:    add w8, w0, w8
; CHECK-NEXT:    csel w8, w8, w0, ne
; CHECK-NEXT:    asr w0, w8, #8
; CHECK-NEXT:    str w0, [x2]
; CHECK-NEXT:    ret
  %t0 = add i32 %x, 2147418112 ; 0x7FFF0000
  %t1 = select i1 %cond, i32 %t0, i32 %x
  %r = ashr i32 %t1, 8
  store i32 %r, ptr %dst
  ret i32 %r
}
