# NOTE: Assertions have been autogenerated by utils/update_mca_test_checks.py
# RUN: llvm-mca -mtriple=aarch64 -mcpu=neoverse-v1 -instruction-tables < %s | FileCheck %s

#----------------------------------------------------------------------------
# Basic instructions without scheduling information in Neoverse V1 SOG
#----------------------------------------------------------------------------

at s12e1r, x28
brk      #0x8415
clrex
csdb
dcps1
dcps2
dcps3
dmb sy
hlt #0x7a67
hvc #0xecb9
isb
pssbb
smc #0x7e57
svc #0x89cb
sysl x16, #5, c11, c8, #5

# CHECK:      Instruction Info:
# CHECK-NEXT: [1]: #uOps
# CHECK-NEXT: [2]: Latency
# CHECK-NEXT: [3]: RThroughput
# CHECK-NEXT: [4]: MayLoad
# CHECK-NEXT: [5]: MayStore
# CHECK-NEXT: [6]: HasSideEffects (U)

# CHECK:      [1]    [2]    [3]    [4]    [5]    [6]    Instructions:
# CHECK-NEXT:  1      1     0.07                  U     at	s12e1r, x28
# CHECK-NEXT:  1      1     0.07                  U     brk	#0x8415
# CHECK-NEXT:  1      1     0.07    *      *      U     clrex
# CHECK-NEXT:  1      1     0.07    *      *      U     csdb
# CHECK-NEXT:  1      1     0.07                  U     dcps1
# CHECK-NEXT:  1      1     0.07                  U     dcps2
# CHECK-NEXT:  1      1     0.07                  U     dcps3
# CHECK-NEXT:  1      1     0.07    *      *      U     dmb	sy
# CHECK-NEXT:  1      1     0.07                  U     hlt	#0x7a67
# CHECK-NEXT:  1      1     0.07                  U     hvc	#0xecb9
# CHECK-NEXT:  1      1     0.07    *      *      U     isb
# CHECK-NEXT:  1      1     0.07    *      *      U     pssbb
# CHECK-NEXT:  1      1     0.07                  U     smc	#0x7e57
# CHECK-NEXT:  1      1     0.07                  U     svc	#0x89cb
# CHECK-NEXT:  1      1     0.07                  U     sysl	x16, #5, c11, c8, #5

# CHECK:      Resources:
# CHECK-NEXT: [0.0] - V1UnitB
# CHECK-NEXT: [0.1] - V1UnitB
# CHECK-NEXT: [1.0] - V1UnitD
# CHECK-NEXT: [1.1] - V1UnitD
# CHECK-NEXT: [2.0] - V1UnitFlg
# CHECK-NEXT: [2.1] - V1UnitFlg
# CHECK-NEXT: [2.2] - V1UnitFlg
# CHECK-NEXT: [3]   - V1UnitL2
# CHECK-NEXT: [4.0] - V1UnitL01
# CHECK-NEXT: [4.1] - V1UnitL01
# CHECK-NEXT: [5]   - V1UnitM0
# CHECK-NEXT: [6]   - V1UnitM1
# CHECK-NEXT: [7.0] - V1UnitS
# CHECK-NEXT: [7.1] - V1UnitS
# CHECK-NEXT: [8]   - V1UnitV0
# CHECK-NEXT: [9]   - V1UnitV1
# CHECK-NEXT: [10]  - V1UnitV2
# CHECK-NEXT: [11]  - V1UnitV3

# CHECK:      Resource pressure per iteration:
# CHECK-NEXT: [0.0]  [0.1]  [1.0]  [1.1]  [2.0]  [2.1]  [2.2]  [3]    [4.0]  [4.1]  [5]    [6]    [7.0]  [7.1]  [8]    [9]    [10]   [11]
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -

# CHECK:      Resource pressure by instruction:
# CHECK-NEXT: [0.0]  [0.1]  [1.0]  [1.1]  [2.0]  [2.1]  [2.2]  [3]    [4.0]  [4.1]  [5]    [6]    [7.0]  [7.1]  [8]    [9]    [10]   [11]   Instructions:
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     at	s12e1r, x28
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     brk	#0x8415
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     clrex
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     csdb
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     dcps1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     dcps2
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     dcps3
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     dmb	sy
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     hlt	#0x7a67
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     hvc	#0xecb9
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     isb
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     pssbb
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     smc	#0x7e57
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     svc	#0x89cb
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -      -     sysl	x16, #5, c11, c8, #5
