; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mcpu=skylake-avx512  | FileCheck %s --check-prefixes=CHECK,CHECK-SKX
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mcpu=icelake-server  | FileCheck %s --check-prefixes=CHECK,CHECK-ICX
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mcpu=x86-64-v4  | FileCheck %s --check-prefixes=CHECK,CHECK-V4
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mcpu=znver4  | FileCheck %s --check-prefixes=CHECK,CHECK-ZNVER4
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mcpu=znver5  | FileCheck %s --check-prefixes=CHECK,CHECK-ZNVER4


define <4 x i32> @shuf_rot_v4i32_1032(<4 x i32> %x) {
; CHECK-SKX-LABEL: shuf_rot_v4i32_1032:
; CHECK-SKX:       # %bb.0:
; CHECK-SKX-NEXT:    vpaddd %xmm0, %xmm0, %xmm0
; CHECK-SKX-NEXT:    vprolq $32, %xmm0, %xmm0
; CHECK-SKX-NEXT:    retq
;
; CHECK-ICX-LABEL: shuf_rot_v4i32_1032:
; CHECK-ICX:       # %bb.0:
; CHECK-ICX-NEXT:    vpaddd %xmm0, %xmm0, %xmm0
; CHECK-ICX-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[1,0,3,2]
; CHECK-ICX-NEXT:    retq
;
; CHECK-V4-LABEL: shuf_rot_v4i32_1032:
; CHECK-V4:       # %bb.0:
; CHECK-V4-NEXT:    vpaddd %xmm0, %xmm0, %xmm0
; CHECK-V4-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[1,0,3,2]
; CHECK-V4-NEXT:    retq
;
; CHECK-ZNVER4-LABEL: shuf_rot_v4i32_1032:
; CHECK-ZNVER4:       # %bb.0:
; CHECK-ZNVER4-NEXT:    vpaddd %xmm0, %xmm0, %xmm0
; CHECK-ZNVER4-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[1,0,3,2]
; CHECK-ZNVER4-NEXT:    retq
  %x1 = add <4 x i32> %x, %x
  %r = shufflevector <4 x i32> %x1, <4 x i32> zeroinitializer, <4 x i32> <i32 1, i32 0, i32 3, i32 2>
  ret <4 x i32> %r
}

define <8 x i32> @shuf_rot_v8i32_10325476(<8 x i32> %x) {
; CHECK-SKX-LABEL: shuf_rot_v8i32_10325476:
; CHECK-SKX:       # %bb.0:
; CHECK-SKX-NEXT:    vpaddd %ymm0, %ymm0, %ymm0
; CHECK-SKX-NEXT:    vprolq $32, %ymm0, %ymm0
; CHECK-SKX-NEXT:    retq
;
; CHECK-ICX-LABEL: shuf_rot_v8i32_10325476:
; CHECK-ICX:       # %bb.0:
; CHECK-ICX-NEXT:    vpaddd %ymm0, %ymm0, %ymm0
; CHECK-ICX-NEXT:    vpshufd {{.*#+}} ymm0 = ymm0[1,0,3,2,5,4,7,6]
; CHECK-ICX-NEXT:    retq
;
; CHECK-V4-LABEL: shuf_rot_v8i32_10325476:
; CHECK-V4:       # %bb.0:
; CHECK-V4-NEXT:    vpaddd %ymm0, %ymm0, %ymm0
; CHECK-V4-NEXT:    vpshufd {{.*#+}} ymm0 = ymm0[1,0,3,2,5,4,7,6]
; CHECK-V4-NEXT:    retq
;
; CHECK-ZNVER4-LABEL: shuf_rot_v8i32_10325476:
; CHECK-ZNVER4:       # %bb.0:
; CHECK-ZNVER4-NEXT:    vpaddd %ymm0, %ymm0, %ymm0
; CHECK-ZNVER4-NEXT:    vpshufd {{.*#+}} ymm0 = ymm0[1,0,3,2,5,4,7,6]
; CHECK-ZNVER4-NEXT:    retq
  %x1 = add <8 x i32> %x, %x
  %r = shufflevector <8 x i32> %x1, <8 x i32> zeroinitializer, <8 x i32> <i32 1, i32 0, i32 3, i32 2, i32 5, i32 4, i32 7, i32 6>
  ret <8 x i32> %r
}

define <16 x i32> @shuf_rot_v16i32_1032547698111013121514(<16 x i32> %x) {
; CHECK-SKX-LABEL: shuf_rot_v16i32_1032547698111013121514:
; CHECK-SKX:       # %bb.0:
; CHECK-SKX-NEXT:    vpaddd %zmm0, %zmm0, %zmm0
; CHECK-SKX-NEXT:    vprolq $32, %zmm0, %zmm0
; CHECK-SKX-NEXT:    retq
;
; CHECK-ICX-LABEL: shuf_rot_v16i32_1032547698111013121514:
; CHECK-ICX:       # %bb.0:
; CHECK-ICX-NEXT:    vpaddd %zmm0, %zmm0, %zmm0
; CHECK-ICX-NEXT:    vpshufd {{.*#+}} zmm0 = zmm0[1,0,3,2,5,4,7,6,9,8,11,10,13,12,15,14]
; CHECK-ICX-NEXT:    retq
;
; CHECK-V4-LABEL: shuf_rot_v16i32_1032547698111013121514:
; CHECK-V4:       # %bb.0:
; CHECK-V4-NEXT:    vpaddd %zmm0, %zmm0, %zmm0
; CHECK-V4-NEXT:    vpshufd {{.*#+}} zmm0 = zmm0[1,0,3,2,5,4,7,6,9,8,11,10,13,12,15,14]
; CHECK-V4-NEXT:    retq
;
; CHECK-ZNVER4-LABEL: shuf_rot_v16i32_1032547698111013121514:
; CHECK-ZNVER4:       # %bb.0:
; CHECK-ZNVER4-NEXT:    vpaddd %zmm0, %zmm0, %zmm0
; CHECK-ZNVER4-NEXT:    vpshufd {{.*#+}} zmm0 = zmm0[1,0,3,2,5,4,7,6,9,8,11,10,13,12,15,14]
; CHECK-ZNVER4-NEXT:    retq
  %x1 = add <16 x i32> %x, %x
  %r = shufflevector <16 x i32> %x1, <16 x i32> zeroinitializer, <16 x i32> <i32 1, i32 0, i32 3, i32 2, i32 5, i32 4, i32 7, i32 6, i32 9, i32 8, i32 11, i32 10, i32 13, i32 12, i32 15, i32 14>
  ret <16 x i32> %r
}

define <8 x i16> @shuf_rot_v8i16_10325476(<8 x i16> %x) {
; CHECK-LABEL: shuf_rot_v8i16_10325476:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpaddw %xmm0, %xmm0, %xmm0
; CHECK-NEXT:    vprold $16, %xmm0, %xmm0
; CHECK-NEXT:    retq
  %x1 = add <8 x i16> %x, %x
  %r = shufflevector <8 x i16> %x1, <8 x i16> zeroinitializer, <8 x i32> <i32 1, i32 0, i32 3, i32 2, i32 5, i32 4, i32 7, i32 6>
  ret <8 x i16> %r
}

define <16 x i16> @shuf_rot_v16i16_1032547698111013121514(<16 x i16> %x) {
; CHECK-LABEL: shuf_rot_v16i16_1032547698111013121514:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpaddw %ymm0, %ymm0, %ymm0
; CHECK-NEXT:    vprold $16, %ymm0, %ymm0
; CHECK-NEXT:    retq
  %x1 = add <16 x i16> %x, %x
  %r = shufflevector <16 x i16> %x1, <16 x i16> zeroinitializer, <16 x i32> <i32 1, i32 0, i32 3, i32 2, i32 5, i32 4, i32 7, i32 6, i32 9, i32 8, i32 11, i32 10, i32 13, i32 12, i32 15, i32 14>
  ret <16 x i16> %r
}

define <32 x i16> @shuf_rot_v32i16_1234056749101181314151217181916212223202527272429303128(<32 x i16> %x) {
; CHECK-LABEL: shuf_rot_v32i16_1234056749101181314151217181916212223202527272429303128:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpaddw %zmm0, %zmm0, %zmm0
; CHECK-NEXT:    vprolq $48, %zmm0, %zmm0
; CHECK-NEXT:    retq
  %x1 = add <32 x i16> %x, %x
  %r = shufflevector <32 x i16> %x1, <32 x i16> zeroinitializer, <32 x i32> <i32 1,i32 2,i32 3,i32 0,i32 5,i32 6,i32 7,i32 4,i32 9,i32 10,i32 11,i32 8,i32 13,i32 14,i32 15,i32 12,i32 17,i32 18,i32 19,i32 16,i32 21,i32 22,i32 23,i32 20,i32 25,i32 26,i32 27,i32 24,i32 29,i32 30,i32 31,i32 28>
  ret <32 x i16> %r
}

define <16 x i8> @shuf_rot_v16i8_2301674510118914151213(<16 x i8> %x) {
; CHECK-LABEL: shuf_rot_v16i8_2301674510118914151213:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpaddb %xmm0, %xmm0, %xmm0
; CHECK-NEXT:    vprold $16, %xmm0, %xmm0
; CHECK-NEXT:    retq
  %x1 = add <16 x i8> %x, %x
  %r = shufflevector <16 x i8> %x1, <16 x i8> zeroinitializer, <16 x i32> <i32 2, i32 3, i32 0, i32 1, i32 6, i32 7, i32 4, i32 5, i32 10, i32 11, i32 8, i32 9, i32 14, i32 15, i32 12, i32 13>
  ret <16 x i8> %r
}

define <32 x i8> @shuf_rot_v32i8_230167451011891415121318191617222320212627242530312829(<32 x i8> %x) {
; CHECK-LABEL: shuf_rot_v32i8_230167451011891415121318191617222320212627242530312829:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpaddb %ymm0, %ymm0, %ymm0
; CHECK-NEXT:    vprold $16, %ymm0, %ymm0
; CHECK-NEXT:    retq
  %x1 = add <32 x i8> %x, %x
  %r = shufflevector <32 x i8> %x1, <32 x i8> zeroinitializer, <32 x i32> <i32 2, i32 3, i32 0, i32 1, i32 6, i32 7, i32 4, i32 5, i32 10, i32 11, i32 8, i32 9, i32 14, i32 15, i32 12, i32 13, i32 18, i32 19, i32 16, i32 17, i32 22, i32 23, i32 20, i32 21, i32 26, i32 27, i32 24, i32 25, i32 30, i32 31, i32 28, i32 29>
  ret <32 x i8> %r
}

define <64 x i8> @shuf_rot_v64i8_3012745611891015121314191617182320212227242526312829303532333439363738434041424744454651484950555253545956575863606162(<64 x i8> %x) {
; CHECK-LABEL: shuf_rot_v64i8_3012745611891015121314191617182320212227242526312829303532333439363738434041424744454651484950555253545956575863606162:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpaddb %zmm0, %zmm0, %zmm0
; CHECK-NEXT:    vprold $8, %zmm0, %zmm0
; CHECK-NEXT:    retq
  %x1 = add <64 x i8> %x, %x
  %r = shufflevector <64 x i8> %x1, <64 x i8> zeroinitializer, <64 x i32> <i32 3,i32 0,i32 1,i32 2,i32 7,i32 4,i32 5,i32 6,i32 11,i32 8,i32 9,i32 10,i32 15,i32 12,i32 13,i32 14,i32 19,i32 16,i32 17,i32 18,i32 23,i32 20,i32 21,i32 22,i32 27,i32 24,i32 25,i32 26,i32 31,i32 28,i32 29,i32 30,i32 35,i32 32,i32 33,i32 34,i32 39,i32 36,i32 37,i32 38,i32 43,i32 40,i32 41,i32 42,i32 47,i32 44,i32 45,i32 46,i32 51,i32 48,i32 49,i32 50,i32 55,i32 52,i32 53,i32 54,i32 59,i32 56,i32 57,i32 58,i32 63,i32 60,i32 61,i32 62>
  ret <64 x i8> %r
}

define <4 x i32> @shuf_shr_v4i32_1U3U(<4 x i32> %x) {
; CHECK-SKX-LABEL: shuf_shr_v4i32_1U3U:
; CHECK-SKX:       # %bb.0:
; CHECK-SKX-NEXT:    vpaddd %xmm0, %xmm0, %xmm0
; CHECK-SKX-NEXT:    vpsrlq $32, %xmm0, %xmm0
; CHECK-SKX-NEXT:    retq
;
; CHECK-ICX-LABEL: shuf_shr_v4i32_1U3U:
; CHECK-ICX:       # %bb.0:
; CHECK-ICX-NEXT:    vpaddd %xmm0, %xmm0, %xmm0
; CHECK-ICX-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[1,1,3,3]
; CHECK-ICX-NEXT:    retq
;
; CHECK-V4-LABEL: shuf_shr_v4i32_1U3U:
; CHECK-V4:       # %bb.0:
; CHECK-V4-NEXT:    vpaddd %xmm0, %xmm0, %xmm0
; CHECK-V4-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[1,1,3,3]
; CHECK-V4-NEXT:    retq
;
; CHECK-ZNVER4-LABEL: shuf_shr_v4i32_1U3U:
; CHECK-ZNVER4:       # %bb.0:
; CHECK-ZNVER4-NEXT:    vpaddd %xmm0, %xmm0, %xmm0
; CHECK-ZNVER4-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[1,1,3,3]
; CHECK-ZNVER4-NEXT:    retq
  %x1 = add <4 x i32> %x, %x
  %r = shufflevector <4 x i32> %x1, <4 x i32> zeroinitializer, <4 x i32> <i32 1, i32 undef, i32 3, i32 undef>
  ret <4 x i32> %r
}

define <8 x i32> @shuf_shr_v8i32_1U3U5U7U(<8 x i32> %x) {
; CHECK-SKX-LABEL: shuf_shr_v8i32_1U3U5U7U:
; CHECK-SKX:       # %bb.0:
; CHECK-SKX-NEXT:    vpaddd %ymm0, %ymm0, %ymm0
; CHECK-SKX-NEXT:    vpsrlq $32, %ymm0, %ymm0
; CHECK-SKX-NEXT:    retq
;
; CHECK-ICX-LABEL: shuf_shr_v8i32_1U3U5U7U:
; CHECK-ICX:       # %bb.0:
; CHECK-ICX-NEXT:    vpaddd %ymm0, %ymm0, %ymm0
; CHECK-ICX-NEXT:    vpshufd {{.*#+}} ymm0 = ymm0[1,1,3,3,5,5,7,7]
; CHECK-ICX-NEXT:    retq
;
; CHECK-V4-LABEL: shuf_shr_v8i32_1U3U5U7U:
; CHECK-V4:       # %bb.0:
; CHECK-V4-NEXT:    vpaddd %ymm0, %ymm0, %ymm0
; CHECK-V4-NEXT:    vpshufd {{.*#+}} ymm0 = ymm0[1,1,3,3,5,5,7,7]
; CHECK-V4-NEXT:    retq
;
; CHECK-ZNVER4-LABEL: shuf_shr_v8i32_1U3U5U7U:
; CHECK-ZNVER4:       # %bb.0:
; CHECK-ZNVER4-NEXT:    vpaddd %ymm0, %ymm0, %ymm0
; CHECK-ZNVER4-NEXT:    vpshufd {{.*#+}} ymm0 = ymm0[1,1,3,3,5,5,7,7]
; CHECK-ZNVER4-NEXT:    retq
  %x1 = add <8 x i32> %x, %x
  %r = shufflevector <8 x i32> %x1, <8 x i32> zeroinitializer, <8 x i32> <i32 1, i32 undef, i32 3, i32 undef, i32 5, i32 undef, i32 7, i32 undef>
  ret <8 x i32> %r
}

define <16 x i32> @shuf_shr_v16i32_U3U5U7U9U11U13U15(<16 x i32> %x) {
; CHECK-SKX-LABEL: shuf_shr_v16i32_U3U5U7U9U11U13U15:
; CHECK-SKX:       # %bb.0:
; CHECK-SKX-NEXT:    vpaddd %zmm0, %zmm0, %zmm0
; CHECK-SKX-NEXT:    vpsrlq $32, %zmm0, %zmm0
; CHECK-SKX-NEXT:    retq
;
; CHECK-ICX-LABEL: shuf_shr_v16i32_U3U5U7U9U11U13U15:
; CHECK-ICX:       # %bb.0:
; CHECK-ICX-NEXT:    vpaddd %zmm0, %zmm0, %zmm0
; CHECK-ICX-NEXT:    vpshufd {{.*#+}} zmm0 = zmm0[1,1,3,3,5,5,7,7,9,9,11,11,13,13,15,15]
; CHECK-ICX-NEXT:    retq
;
; CHECK-V4-LABEL: shuf_shr_v16i32_U3U5U7U9U11U13U15:
; CHECK-V4:       # %bb.0:
; CHECK-V4-NEXT:    vpaddd %zmm0, %zmm0, %zmm0
; CHECK-V4-NEXT:    vpshufd {{.*#+}} zmm0 = zmm0[1,1,3,3,5,5,7,7,9,9,11,11,13,13,15,15]
; CHECK-V4-NEXT:    retq
;
; CHECK-ZNVER4-LABEL: shuf_shr_v16i32_U3U5U7U9U11U13U15:
; CHECK-ZNVER4:       # %bb.0:
; CHECK-ZNVER4-NEXT:    vpaddd %zmm0, %zmm0, %zmm0
; CHECK-ZNVER4-NEXT:    vpshufd {{.*#+}} zmm0 = zmm0[1,1,3,3,5,5,7,7,9,9,11,11,13,13,15,15]
; CHECK-ZNVER4-NEXT:    retq
  %x1 = add <16 x i32> %x, %x
  %r = shufflevector <16 x i32> %x1, <16 x i32> zeroinitializer, <16 x i32> <i32 1, i32 undef, i32 3, i32 undef, i32 5, i32 undef, i32 7, i32 undef, i32 9, i32 undef, i32 11, i32 undef, i32 13, i32 undef, i32 15, i32 undef>
  ret <16 x i32> %r
}

define <8 x i16> @shuf_shr_v8i16_123U567U(<8 x i16> %x) {
; CHECK-LABEL: shuf_shr_v8i16_123U567U:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpaddw %xmm0, %xmm0, %xmm0
; CHECK-NEXT:    vpsrlq $16, %xmm0, %xmm0
; CHECK-NEXT:    retq
  %x1 = add <8 x i16> %x, %x
  %r = shufflevector <8 x i16> %x1, <8 x i16> zeroinitializer, <8 x i32> <i32 1, i32 2, i32 3, i32 undef, i32 5, i32 6, i32 7, i32 undef>
  ret <8 x i16> %r
}

define <32 x i16> @shuf_shr_v32i16_1U3U5U7U9U11U13U15U17U19U21U23U25U27U29U31U(<32 x i16> %x) {
; CHECK-LABEL: shuf_shr_v32i16_1U3U5U7U9U11U13U15U17U19U21U23U25U27U29U31U:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpaddw %zmm0, %zmm0, %zmm0
; CHECK-NEXT:    vpsrld $16, %zmm0, %zmm0
; CHECK-NEXT:    retq
  %x1 = add <32 x i16> %x, %x
  %r = shufflevector <32 x i16> %x1, <32 x i16> zeroinitializer, <32 x i32> <i32 1, i32 undef, i32 3, i32 undef, i32 5, i32 undef, i32 7, i32 undef, i32 9, i32 undef, i32 11, i32 undef, i32 13, i32 undef, i32 15, i32 undef, i32 17, i32 undef, i32 19, i32 undef, i32 21, i32 undef, i32 23, i32 undef, i32 25, i32 undef, i32 27, i32 undef, i32 29, i32 undef, i32 31, i32 undef>
  ret <32 x i16> %r
}

define <32 x i8> @shuf_shr_v32i8_1U3U5U7U9U11U13U15U17U19U21U23U25U27U29U31U(<32 x i8> %x) {
; CHECK-LABEL: shuf_shr_v32i8_1U3U5U7U9U11U13U15U17U19U21U23U25U27U29U31U:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpaddb %ymm0, %ymm0, %ymm0
; CHECK-NEXT:    vpsrlw $8, %ymm0, %ymm0
; CHECK-NEXT:    retq
  %x1 = add <32 x i8> %x, %x
  %r = shufflevector <32 x i8> %x1, <32 x i8> zeroinitializer, <32 x i32> <i32 1, i32 undef, i32 3, i32 undef, i32 5, i32 undef, i32 7, i32 undef, i32 9, i32 undef, i32 11, i32 undef, i32 13, i32 undef, i32 15, i32 undef, i32 17, i32 undef, i32 19, i32 undef, i32 21, i32 undef, i32 23, i32 undef, i32 25, i32 undef, i32 27, i32 undef, i32 29, i32 undef, i32 31, i32 undef>
  ret <32 x i8> %r
}

define <4 x i32> @shuf_shl_v4i32_U0U2(<4 x i32> %x) {
; CHECK-SKX-LABEL: shuf_shl_v4i32_U0U2:
; CHECK-SKX:       # %bb.0:
; CHECK-SKX-NEXT:    vpaddd %xmm0, %xmm0, %xmm0
; CHECK-SKX-NEXT:    vpsllq $32, %xmm0, %xmm0
; CHECK-SKX-NEXT:    retq
;
; CHECK-ICX-LABEL: shuf_shl_v4i32_U0U2:
; CHECK-ICX:       # %bb.0:
; CHECK-ICX-NEXT:    vpaddd %xmm0, %xmm0, %xmm0
; CHECK-ICX-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[0,0,2,2]
; CHECK-ICX-NEXT:    retq
;
; CHECK-V4-LABEL: shuf_shl_v4i32_U0U2:
; CHECK-V4:       # %bb.0:
; CHECK-V4-NEXT:    vpaddd %xmm0, %xmm0, %xmm0
; CHECK-V4-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[0,0,2,2]
; CHECK-V4-NEXT:    retq
;
; CHECK-ZNVER4-LABEL: shuf_shl_v4i32_U0U2:
; CHECK-ZNVER4:       # %bb.0:
; CHECK-ZNVER4-NEXT:    vpaddd %xmm0, %xmm0, %xmm0
; CHECK-ZNVER4-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[0,0,2,2]
; CHECK-ZNVER4-NEXT:    retq
  %x1 = add <4 x i32> %x, %x
  %r = shufflevector <4 x i32> %x1, <4 x i32> zeroinitializer, <4 x i32> <i32 undef, i32 0, i32 undef, i32 2>
  ret <4 x i32> %r
}

define <8 x i32> @shuf_shl_v8i32_U0U2U4U6(<8 x i32> %x) {
; CHECK-SKX-LABEL: shuf_shl_v8i32_U0U2U4U6:
; CHECK-SKX:       # %bb.0:
; CHECK-SKX-NEXT:    vpaddd %ymm0, %ymm0, %ymm0
; CHECK-SKX-NEXT:    vpsllq $32, %ymm0, %ymm0
; CHECK-SKX-NEXT:    retq
;
; CHECK-ICX-LABEL: shuf_shl_v8i32_U0U2U4U6:
; CHECK-ICX:       # %bb.0:
; CHECK-ICX-NEXT:    vpaddd %ymm0, %ymm0, %ymm0
; CHECK-ICX-NEXT:    vpshufd {{.*#+}} ymm0 = ymm0[0,0,2,2,4,4,6,6]
; CHECK-ICX-NEXT:    retq
;
; CHECK-V4-LABEL: shuf_shl_v8i32_U0U2U4U6:
; CHECK-V4:       # %bb.0:
; CHECK-V4-NEXT:    vpaddd %ymm0, %ymm0, %ymm0
; CHECK-V4-NEXT:    vpshufd {{.*#+}} ymm0 = ymm0[0,0,2,2,4,4,6,6]
; CHECK-V4-NEXT:    retq
;
; CHECK-ZNVER4-LABEL: shuf_shl_v8i32_U0U2U4U6:
; CHECK-ZNVER4:       # %bb.0:
; CHECK-ZNVER4-NEXT:    vpaddd %ymm0, %ymm0, %ymm0
; CHECK-ZNVER4-NEXT:    vpshufd {{.*#+}} ymm0 = ymm0[0,0,2,2,4,4,6,6]
; CHECK-ZNVER4-NEXT:    retq
  %x1 = add <8 x i32> %x, %x
  %r = shufflevector <8 x i32> %x1, <8 x i32> zeroinitializer, <8 x i32> <i32 undef, i32 0, i32 undef, i32 2, i32 undef, i32 4, i32 undef, i32 6>
  ret <8 x i32> %r
}

define <16 x i32> @shuf_shl_v16i32_U0U2U4U6U8U10U12U14(<16 x i32> %x) {
; CHECK-SKX-LABEL: shuf_shl_v16i32_U0U2U4U6U8U10U12U14:
; CHECK-SKX:       # %bb.0:
; CHECK-SKX-NEXT:    vpaddd %zmm0, %zmm0, %zmm0
; CHECK-SKX-NEXT:    vpsllq $32, %zmm0, %zmm0
; CHECK-SKX-NEXT:    retq
;
; CHECK-ICX-LABEL: shuf_shl_v16i32_U0U2U4U6U8U10U12U14:
; CHECK-ICX:       # %bb.0:
; CHECK-ICX-NEXT:    vpaddd %zmm0, %zmm0, %zmm0
; CHECK-ICX-NEXT:    vpshufd {{.*#+}} zmm0 = zmm0[0,0,2,2,4,4,6,6,8,8,10,10,12,12,14,14]
; CHECK-ICX-NEXT:    retq
;
; CHECK-V4-LABEL: shuf_shl_v16i32_U0U2U4U6U8U10U12U14:
; CHECK-V4:       # %bb.0:
; CHECK-V4-NEXT:    vpaddd %zmm0, %zmm0, %zmm0
; CHECK-V4-NEXT:    vpshufd {{.*#+}} zmm0 = zmm0[0,0,2,2,4,4,6,6,8,8,10,10,12,12,14,14]
; CHECK-V4-NEXT:    retq
;
; CHECK-ZNVER4-LABEL: shuf_shl_v16i32_U0U2U4U6U8U10U12U14:
; CHECK-ZNVER4:       # %bb.0:
; CHECK-ZNVER4-NEXT:    vpaddd %zmm0, %zmm0, %zmm0
; CHECK-ZNVER4-NEXT:    vpshufd {{.*#+}} zmm0 = zmm0[0,0,2,2,4,4,6,6,8,8,10,10,12,12,14,14]
; CHECK-ZNVER4-NEXT:    retq
  %x1 = add <16 x i32> %x, %x
  %r = shufflevector <16 x i32> %x1, <16 x i32> zeroinitializer, <16 x i32> <i32 undef, i32 0, i32 undef, i32 2, i32 undef, i32 4, i32 undef, i32 6, i32 undef, i32 8, i32 undef, i32 10, i32 undef, i32 12, i32 undef, i32 14>
  ret <16 x i32> %r
}

define <16 x i16> @shuf_shl_v16i16_U0U2U4U6U8U10U12U14(<16 x i16> %x) {
; CHECK-LABEL: shuf_shl_v16i16_U0U2U4U6U8U10U12U14:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpaddw %ymm0, %ymm0, %ymm0
; CHECK-NEXT:    vpslld $16, %ymm0, %ymm0
; CHECK-NEXT:    retq
  %x1 = add <16 x i16> %x, %x
  %r = shufflevector <16 x i16> %x1, <16 x i16> zeroinitializer, <16 x i32> <i32 undef, i32 0, i32 undef, i32 2, i32 undef, i32 4, i32 undef, i32 6, i32 undef, i32 8, i32 undef, i32 10, i32 undef, i32 12, i32 undef, i32 14>
  ret <16 x i16> %r
}

define <16 x i8> @shuf_shl_v16i8_U0U2U4U6U8U10U12U14(<16 x i8> %x) {
; CHECK-LABEL: shuf_shl_v16i8_U0U2U4U6U8U10U12U14:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpaddb %xmm0, %xmm0, %xmm0
; CHECK-NEXT:    vpsllw $8, %xmm0, %xmm0
; CHECK-NEXT:    retq
  %x1 = add <16 x i8> %x, %x
  %r = shufflevector <16 x i8> %x1, <16 x i8> zeroinitializer, <16 x i32> <i32 undef, i32 0, i32 undef, i32 2, i32 undef, i32 4, i32 undef, i32 6, i32 undef, i32 8, i32 undef, i32 10, i32 undef, i32 12, i32 undef, i32 14>
  ret <16 x i8> %r
}

define <64 x i8> @shuf_shl_v64i8_U0U2U4U6U8U10U12U14U16U18U20U22U24U26U28U30U32U34U36U38U40U42U44U46U48U50U52U54U56U58U60U62(<64 x i8> %x) {
; CHECK-LABEL: shuf_shl_v64i8_U0U2U4U6U8U10U12U14U16U18U20U22U24U26U28U30U32U34U36U38U40U42U44U46U48U50U52U54U56U58U60U62:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpaddb %zmm0, %zmm0, %zmm0
; CHECK-NEXT:    vpsllw $8, %zmm0, %zmm0
; CHECK-NEXT:    retq
  %x1 = add <64 x i8> %x, %x
  %r = shufflevector <64 x i8> %x1, <64 x i8> zeroinitializer, <64 x i32> <i32 undef, i32 0, i32 undef, i32 2, i32 undef, i32 4, i32 undef, i32 6, i32 undef, i32 8, i32 undef, i32 10, i32 undef, i32 12, i32 undef, i32 14, i32 undef, i32 16, i32 undef, i32 18, i32 undef, i32 20, i32 undef, i32 22, i32 undef, i32 24, i32 undef, i32 26, i32 undef, i32 28, i32 undef, i32 30, i32 undef, i32 32, i32 undef, i32 34, i32 undef, i32 36, i32 undef, i32 38, i32 undef, i32 40, i32 undef, i32 42, i32 undef, i32 44, i32 undef, i32 46, i32 undef, i32 48, i32 undef, i32 50, i32 undef, i32 52, i32 undef, i32 54, i32 undef, i32 56, i32 undef, i32 58, i32 undef, i32 60, i32 undef, i32 62>
  ret <64 x i8> %r
}
