; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 4
; RUN: opt -S -mtriple=amdgcn-- -amdgpu-lower-module-lds < %s 2>&1 | FileCheck %s
; RUN: opt -S -mtriple=amdgcn-- -passes=amdgpu-lower-module-lds < %s 2>&1 | FileCheck %s

; This looks like a partially lowered module, but the non-lowered GV isn't used by any kernels.
; In such cases, LowerModuleLDS is free to leave it in and ignore it, and we want to make sure
; LowerModuleLDS doesn't crash if it re-runs on such modules.
@notLowered = addrspace(3) global i32 poison
@lowered = addrspace(3) global i32 poison, !absolute_symbol !0

@llvm.compiler.used = appending addrspace(1) global [1 x ptr] [ptr addrspacecast (ptr addrspace(3) @notLowered to ptr)], section "llvm.metadata"

define amdgpu_kernel void @kern(i32 %val0) {
; CHECK-LABEL: define amdgpu_kernel void @kern(
; CHECK-SAME: i32 [[VAL0:%.*]]) {
; CHECK-NEXT:    [[VAL1:%.*]] = add i32 [[VAL0]], 4
; CHECK-NEXT:    store i32 [[VAL1]], ptr addrspace(3) @lowered, align 4
; CHECK-NEXT:    ret void
;
  %val1 = add i32 %val0, 4
  store i32 %val1, ptr addrspace(3) @lowered
  ret void
}


!0 = !{i32 0, i32 1}
