; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s                               -mtriple=x86_64-apple-darwin10 -mattr=+x87,-sse,-sse2 -verify-machineinstrs | FileCheck %s --check-prefixes=X64,SDAG-X64
; RUN: llc < %s -fast-isel -fast-isel-abort=1 -mtriple=x86_64-apple-darwin10 -mattr=+x87,-sse,-sse2 -verify-machineinstrs | FileCheck %s --check-prefixes=X64,FAST-X64
; RUN: llc < %s -global-isel -global-isel-abort=1 -mtriple=x86_64-apple-darwin10 -mattr=+x87,-sse,-sse2 -verify-machineinstrs | FileCheck %s --check-prefixes=GISEL-X64
; RUN: llc < %s                               -mtriple=i686-apple-darwin10 -mattr=+x87,-sse,-sse2 -verify-machineinstrs | FileCheck %s --check-prefixes=X86,SDAG-X86
; Allow fast-isel to fallback to selection dag on x86
; RUN: llc < %s -fast-isel -mtriple=i686-apple-darwin10 -mattr=+x87,-sse,-sse2 -verify-machineinstrs | FileCheck %s --check-prefixes=X86,FAST-X86
; RUN: llc < %s -global-isel -global-isel-abort=1 -mtriple=i686-apple-darwin10 -mattr=+x87,-sse,-sse2 -verify-machineinstrs | FileCheck %s --check-prefixes=GISEL-X86

  define i1 @fcmp_x86_fp80_oeq(x86_fp80 %x, x86_fp80 %y) nounwind {
; X64-LABEL: fcmp_x86_fp80_oeq:
; X64:       ## %bb.0:
; X64-NEXT:    fldt {{[0-9]+}}(%rsp)
; X64-NEXT:    fldt {{[0-9]+}}(%rsp)
; X64-NEXT:    fucompi %st(1), %st
; X64-NEXT:    fstp %st(0)
; X64-NEXT:    setnp %cl
; X64-NEXT:    sete %al
; X64-NEXT:    andb %cl, %al
; X64-NEXT:    retq
;
; GISEL-X64-LABEL: fcmp_x86_fp80_oeq:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    fldt {{[0-9]+}}(%rsp)
; GISEL-X64-NEXT:    fldt {{[0-9]+}}(%rsp)
; GISEL-X64-NEXT:    fxch %st(1)
; GISEL-X64-NEXT:    fucompi %st(1), %st
; GISEL-X64-NEXT:    fstp %st(0)
; GISEL-X64-NEXT:    sete %cl
; GISEL-X64-NEXT:    setnp %al
; GISEL-X64-NEXT:    andb %cl, %al
; GISEL-X64-NEXT:    retq
;
; X86-LABEL: fcmp_x86_fp80_oeq:
; X86:       ## %bb.0:
; X86-NEXT:    fldt {{[0-9]+}}(%esp)
; X86-NEXT:    fldt {{[0-9]+}}(%esp)
; X86-NEXT:    fucompp
; X86-NEXT:    fnstsw %ax
; X86-NEXT:    ## kill: def $ah killed $ah killed $ax
; X86-NEXT:    sahf
; X86-NEXT:    setnp %cl
; X86-NEXT:    sete %al
; X86-NEXT:    andb %cl, %al
; X86-NEXT:    retl
;
; GISEL-X86-LABEL: fcmp_x86_fp80_oeq:
; GISEL-X86:       ## %bb.0:
; GISEL-X86-NEXT:    fldt {{[0-9]+}}(%esp)
; GISEL-X86-NEXT:    fldt {{[0-9]+}}(%esp)
; GISEL-X86-NEXT:    fxch %st(1)
; GISEL-X86-NEXT:    fucompi %st(1), %st
; GISEL-X86-NEXT:    fstp %st(0)
; GISEL-X86-NEXT:    sete %cl
; GISEL-X86-NEXT:    setnp %al
; GISEL-X86-NEXT:    andb %cl, %al
; GISEL-X86-NEXT:    retl
    %1 = fcmp oeq x86_fp80 %x, %y
    ret i1 %1
  }

  define i1 @fcmp_x86_fp80_ogt(x86_fp80 %x, x86_fp80 %y) nounwind {
; X64-LABEL: fcmp_x86_fp80_ogt:
; X64:       ## %bb.0:
; X64-NEXT:    fldt {{[0-9]+}}(%rsp)
; X64-NEXT:    fldt {{[0-9]+}}(%rsp)
; X64-NEXT:    fucompi %st(1), %st
; X64-NEXT:    fstp %st(0)
; X64-NEXT:    seta %al
; X64-NEXT:    retq
;
; GISEL-X64-LABEL: fcmp_x86_fp80_ogt:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    fldt {{[0-9]+}}(%rsp)
; GISEL-X64-NEXT:    fldt {{[0-9]+}}(%rsp)
; GISEL-X64-NEXT:    fxch %st(1)
; GISEL-X64-NEXT:    fucompi %st(1), %st
; GISEL-X64-NEXT:    fstp %st(0)
; GISEL-X64-NEXT:    seta %al
; GISEL-X64-NEXT:    retq
;
; X86-LABEL: fcmp_x86_fp80_ogt:
; X86:       ## %bb.0:
; X86-NEXT:    fldt {{[0-9]+}}(%esp)
; X86-NEXT:    fldt {{[0-9]+}}(%esp)
; X86-NEXT:    fucompp
; X86-NEXT:    fnstsw %ax
; X86-NEXT:    ## kill: def $ah killed $ah killed $ax
; X86-NEXT:    sahf
; X86-NEXT:    seta %al
; X86-NEXT:    retl
;
; GISEL-X86-LABEL: fcmp_x86_fp80_ogt:
; GISEL-X86:       ## %bb.0:
; GISEL-X86-NEXT:    fldt {{[0-9]+}}(%esp)
; GISEL-X86-NEXT:    fldt {{[0-9]+}}(%esp)
; GISEL-X86-NEXT:    fxch %st(1)
; GISEL-X86-NEXT:    fucompi %st(1), %st
; GISEL-X86-NEXT:    fstp %st(0)
; GISEL-X86-NEXT:    seta %al
; GISEL-X86-NEXT:    retl
    %1 = fcmp ogt x86_fp80 %x, %y
    ret i1 %1
  }

  define i1 @fcmp_x86_fp80_oge(x86_fp80 %x, x86_fp80 %y) nounwind {
; X64-LABEL: fcmp_x86_fp80_oge:
; X64:       ## %bb.0:
; X64-NEXT:    fldt {{[0-9]+}}(%rsp)
; X64-NEXT:    fldt {{[0-9]+}}(%rsp)
; X64-NEXT:    fucompi %st(1), %st
; X64-NEXT:    fstp %st(0)
; X64-NEXT:    setae %al
; X64-NEXT:    retq
;
; GISEL-X64-LABEL: fcmp_x86_fp80_oge:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    fldt {{[0-9]+}}(%rsp)
; GISEL-X64-NEXT:    fldt {{[0-9]+}}(%rsp)
; GISEL-X64-NEXT:    fxch %st(1)
; GISEL-X64-NEXT:    fucompi %st(1), %st
; GISEL-X64-NEXT:    fstp %st(0)
; GISEL-X64-NEXT:    setae %al
; GISEL-X64-NEXT:    retq
;
; X86-LABEL: fcmp_x86_fp80_oge:
; X86:       ## %bb.0:
; X86-NEXT:    fldt {{[0-9]+}}(%esp)
; X86-NEXT:    fldt {{[0-9]+}}(%esp)
; X86-NEXT:    fucompp
; X86-NEXT:    fnstsw %ax
; X86-NEXT:    ## kill: def $ah killed $ah killed $ax
; X86-NEXT:    sahf
; X86-NEXT:    setae %al
; X86-NEXT:    retl
;
; GISEL-X86-LABEL: fcmp_x86_fp80_oge:
; GISEL-X86:       ## %bb.0:
; GISEL-X86-NEXT:    fldt {{[0-9]+}}(%esp)
; GISEL-X86-NEXT:    fldt {{[0-9]+}}(%esp)
; GISEL-X86-NEXT:    fxch %st(1)
; GISEL-X86-NEXT:    fucompi %st(1), %st
; GISEL-X86-NEXT:    fstp %st(0)
; GISEL-X86-NEXT:    setae %al
; GISEL-X86-NEXT:    retl
    %1 = fcmp oge x86_fp80 %x, %y
    ret i1 %1
  }

  define i1 @fcmp_x86_fp80_olt(x86_fp80 %x, x86_fp80 %y) nounwind {
; SDAG-X64-LABEL: fcmp_x86_fp80_olt:
; SDAG-X64:       ## %bb.0:
; SDAG-X64-NEXT:    fldt {{[0-9]+}}(%rsp)
; SDAG-X64-NEXT:    fldt {{[0-9]+}}(%rsp)
; SDAG-X64-NEXT:    fucompi %st(1), %st
; SDAG-X64-NEXT:    fstp %st(0)
; SDAG-X64-NEXT:    seta %al
; SDAG-X64-NEXT:    retq
;
; FAST-X64-LABEL: fcmp_x86_fp80_olt:
; FAST-X64:       ## %bb.0:
; FAST-X64-NEXT:    fldt {{[0-9]+}}(%rsp)
; FAST-X64-NEXT:    fldt {{[0-9]+}}(%rsp)
; FAST-X64-NEXT:    fxch %st(1)
; FAST-X64-NEXT:    fucompi %st(1), %st
; FAST-X64-NEXT:    fstp %st(0)
; FAST-X64-NEXT:    seta %al
; FAST-X64-NEXT:    retq
;
; GISEL-X64-LABEL: fcmp_x86_fp80_olt:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    fldt {{[0-9]+}}(%rsp)
; GISEL-X64-NEXT:    fldt {{[0-9]+}}(%rsp)
; GISEL-X64-NEXT:    fucompi %st(1), %st
; GISEL-X64-NEXT:    fstp %st(0)
; GISEL-X64-NEXT:    seta %al
; GISEL-X64-NEXT:    retq
;
; SDAG-X86-LABEL: fcmp_x86_fp80_olt:
; SDAG-X86:       ## %bb.0:
; SDAG-X86-NEXT:    fldt {{[0-9]+}}(%esp)
; SDAG-X86-NEXT:    fldt {{[0-9]+}}(%esp)
; SDAG-X86-NEXT:    fucompp
; SDAG-X86-NEXT:    fnstsw %ax
; SDAG-X86-NEXT:    ## kill: def $ah killed $ah killed $ax
; SDAG-X86-NEXT:    sahf
; SDAG-X86-NEXT:    seta %al
; SDAG-X86-NEXT:    retl
;
; FAST-X86-LABEL: fcmp_x86_fp80_olt:
; FAST-X86:       ## %bb.0:
; FAST-X86-NEXT:    fldt {{[0-9]+}}(%esp)
; FAST-X86-NEXT:    fldt {{[0-9]+}}(%esp)
; FAST-X86-NEXT:    fxch %st(1)
; FAST-X86-NEXT:    fucompp
; FAST-X86-NEXT:    fnstsw %ax
; FAST-X86-NEXT:    ## kill: def $ah killed $ah killed $ax
; FAST-X86-NEXT:    sahf
; FAST-X86-NEXT:    seta %al
; FAST-X86-NEXT:    retl
;
; GISEL-X86-LABEL: fcmp_x86_fp80_olt:
; GISEL-X86:       ## %bb.0:
; GISEL-X86-NEXT:    fldt {{[0-9]+}}(%esp)
; GISEL-X86-NEXT:    fldt {{[0-9]+}}(%esp)
; GISEL-X86-NEXT:    fucompi %st(1), %st
; GISEL-X86-NEXT:    fstp %st(0)
; GISEL-X86-NEXT:    seta %al
; GISEL-X86-NEXT:    retl
    %1 = fcmp olt x86_fp80 %x, %y
    ret i1 %1
  }

  define i1 @fcmp_x86_fp80_ole(x86_fp80 %x, x86_fp80 %y) nounwind {
; SDAG-X64-LABEL: fcmp_x86_fp80_ole:
; SDAG-X64:       ## %bb.0:
; SDAG-X64-NEXT:    fldt {{[0-9]+}}(%rsp)
; SDAG-X64-NEXT:    fldt {{[0-9]+}}(%rsp)
; SDAG-X64-NEXT:    fucompi %st(1), %st
; SDAG-X64-NEXT:    fstp %st(0)
; SDAG-X64-NEXT:    setae %al
; SDAG-X64-NEXT:    retq
;
; FAST-X64-LABEL: fcmp_x86_fp80_ole:
; FAST-X64:       ## %bb.0:
; FAST-X64-NEXT:    fldt {{[0-9]+}}(%rsp)
; FAST-X64-NEXT:    fldt {{[0-9]+}}(%rsp)
; FAST-X64-NEXT:    fxch %st(1)
; FAST-X64-NEXT:    fucompi %st(1), %st
; FAST-X64-NEXT:    fstp %st(0)
; FAST-X64-NEXT:    setae %al
; FAST-X64-NEXT:    retq
;
; GISEL-X64-LABEL: fcmp_x86_fp80_ole:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    fldt {{[0-9]+}}(%rsp)
; GISEL-X64-NEXT:    fldt {{[0-9]+}}(%rsp)
; GISEL-X64-NEXT:    fucompi %st(1), %st
; GISEL-X64-NEXT:    fstp %st(0)
; GISEL-X64-NEXT:    setae %al
; GISEL-X64-NEXT:    retq
;
; SDAG-X86-LABEL: fcmp_x86_fp80_ole:
; SDAG-X86:       ## %bb.0:
; SDAG-X86-NEXT:    fldt {{[0-9]+}}(%esp)
; SDAG-X86-NEXT:    fldt {{[0-9]+}}(%esp)
; SDAG-X86-NEXT:    fucompp
; SDAG-X86-NEXT:    fnstsw %ax
; SDAG-X86-NEXT:    ## kill: def $ah killed $ah killed $ax
; SDAG-X86-NEXT:    sahf
; SDAG-X86-NEXT:    setae %al
; SDAG-X86-NEXT:    retl
;
; FAST-X86-LABEL: fcmp_x86_fp80_ole:
; FAST-X86:       ## %bb.0:
; FAST-X86-NEXT:    fldt {{[0-9]+}}(%esp)
; FAST-X86-NEXT:    fldt {{[0-9]+}}(%esp)
; FAST-X86-NEXT:    fxch %st(1)
; FAST-X86-NEXT:    fucompp
; FAST-X86-NEXT:    fnstsw %ax
; FAST-X86-NEXT:    ## kill: def $ah killed $ah killed $ax
; FAST-X86-NEXT:    sahf
; FAST-X86-NEXT:    setae %al
; FAST-X86-NEXT:    retl
;
; GISEL-X86-LABEL: fcmp_x86_fp80_ole:
; GISEL-X86:       ## %bb.0:
; GISEL-X86-NEXT:    fldt {{[0-9]+}}(%esp)
; GISEL-X86-NEXT:    fldt {{[0-9]+}}(%esp)
; GISEL-X86-NEXT:    fucompi %st(1), %st
; GISEL-X86-NEXT:    fstp %st(0)
; GISEL-X86-NEXT:    setae %al
; GISEL-X86-NEXT:    retl
    %1 = fcmp ole x86_fp80 %x, %y
    ret i1 %1
  }

  define i1 @fcmp_x86_fp80_one(x86_fp80 %x, x86_fp80 %y) nounwind {
; X64-LABEL: fcmp_x86_fp80_one:
; X64:       ## %bb.0:
; X64-NEXT:    fldt {{[0-9]+}}(%rsp)
; X64-NEXT:    fldt {{[0-9]+}}(%rsp)
; X64-NEXT:    fucompi %st(1), %st
; X64-NEXT:    fstp %st(0)
; X64-NEXT:    setne %al
; X64-NEXT:    retq
;
; GISEL-X64-LABEL: fcmp_x86_fp80_one:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    fldt {{[0-9]+}}(%rsp)
; GISEL-X64-NEXT:    fldt {{[0-9]+}}(%rsp)
; GISEL-X64-NEXT:    fxch %st(1)
; GISEL-X64-NEXT:    fucompi %st(1), %st
; GISEL-X64-NEXT:    fstp %st(0)
; GISEL-X64-NEXT:    setne %al
; GISEL-X64-NEXT:    retq
;
; X86-LABEL: fcmp_x86_fp80_one:
; X86:       ## %bb.0:
; X86-NEXT:    fldt {{[0-9]+}}(%esp)
; X86-NEXT:    fldt {{[0-9]+}}(%esp)
; X86-NEXT:    fucompp
; X86-NEXT:    fnstsw %ax
; X86-NEXT:    ## kill: def $ah killed $ah killed $ax
; X86-NEXT:    sahf
; X86-NEXT:    setne %al
; X86-NEXT:    retl
;
; GISEL-X86-LABEL: fcmp_x86_fp80_one:
; GISEL-X86:       ## %bb.0:
; GISEL-X86-NEXT:    fldt {{[0-9]+}}(%esp)
; GISEL-X86-NEXT:    fldt {{[0-9]+}}(%esp)
; GISEL-X86-NEXT:    fxch %st(1)
; GISEL-X86-NEXT:    fucompi %st(1), %st
; GISEL-X86-NEXT:    fstp %st(0)
; GISEL-X86-NEXT:    setne %al
; GISEL-X86-NEXT:    retl
    %1 = fcmp one x86_fp80 %x, %y
    ret i1 %1
  }

  define i1 @fcmp_x86_fp80_ord(x86_fp80 %x, x86_fp80 %y) nounwind {
; X64-LABEL: fcmp_x86_fp80_ord:
; X64:       ## %bb.0:
; X64-NEXT:    fldt {{[0-9]+}}(%rsp)
; X64-NEXT:    fldt {{[0-9]+}}(%rsp)
; X64-NEXT:    fucompi %st(1), %st
; X64-NEXT:    fstp %st(0)
; X64-NEXT:    setnp %al
; X64-NEXT:    retq
;
; GISEL-X64-LABEL: fcmp_x86_fp80_ord:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    fldt {{[0-9]+}}(%rsp)
; GISEL-X64-NEXT:    fldt {{[0-9]+}}(%rsp)
; GISEL-X64-NEXT:    fxch %st(1)
; GISEL-X64-NEXT:    fucompi %st(1), %st
; GISEL-X64-NEXT:    fstp %st(0)
; GISEL-X64-NEXT:    setnp %al
; GISEL-X64-NEXT:    retq
;
; X86-LABEL: fcmp_x86_fp80_ord:
; X86:       ## %bb.0:
; X86-NEXT:    fldt {{[0-9]+}}(%esp)
; X86-NEXT:    fldt {{[0-9]+}}(%esp)
; X86-NEXT:    fucompp
; X86-NEXT:    fnstsw %ax
; X86-NEXT:    ## kill: def $ah killed $ah killed $ax
; X86-NEXT:    sahf
; X86-NEXT:    setnp %al
; X86-NEXT:    retl
;
; GISEL-X86-LABEL: fcmp_x86_fp80_ord:
; GISEL-X86:       ## %bb.0:
; GISEL-X86-NEXT:    fldt {{[0-9]+}}(%esp)
; GISEL-X86-NEXT:    fldt {{[0-9]+}}(%esp)
; GISEL-X86-NEXT:    fxch %st(1)
; GISEL-X86-NEXT:    fucompi %st(1), %st
; GISEL-X86-NEXT:    fstp %st(0)
; GISEL-X86-NEXT:    setnp %al
; GISEL-X86-NEXT:    retl
    %1 = fcmp ord x86_fp80 %x, %y
    ret i1 %1
  }

  define i1 @fcmp_x86_fp80_uno(x86_fp80 %x, x86_fp80 %y) nounwind {
; X64-LABEL: fcmp_x86_fp80_uno:
; X64:       ## %bb.0:
; X64-NEXT:    fldt {{[0-9]+}}(%rsp)
; X64-NEXT:    fldt {{[0-9]+}}(%rsp)
; X64-NEXT:    fucompi %st(1), %st
; X64-NEXT:    fstp %st(0)
; X64-NEXT:    setp %al
; X64-NEXT:    retq
;
; GISEL-X64-LABEL: fcmp_x86_fp80_uno:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    fldt {{[0-9]+}}(%rsp)
; GISEL-X64-NEXT:    fldt {{[0-9]+}}(%rsp)
; GISEL-X64-NEXT:    fxch %st(1)
; GISEL-X64-NEXT:    fucompi %st(1), %st
; GISEL-X64-NEXT:    fstp %st(0)
; GISEL-X64-NEXT:    setp %al
; GISEL-X64-NEXT:    retq
;
; X86-LABEL: fcmp_x86_fp80_uno:
; X86:       ## %bb.0:
; X86-NEXT:    fldt {{[0-9]+}}(%esp)
; X86-NEXT:    fldt {{[0-9]+}}(%esp)
; X86-NEXT:    fucompp
; X86-NEXT:    fnstsw %ax
; X86-NEXT:    ## kill: def $ah killed $ah killed $ax
; X86-NEXT:    sahf
; X86-NEXT:    setp %al
; X86-NEXT:    retl
;
; GISEL-X86-LABEL: fcmp_x86_fp80_uno:
; GISEL-X86:       ## %bb.0:
; GISEL-X86-NEXT:    fldt {{[0-9]+}}(%esp)
; GISEL-X86-NEXT:    fldt {{[0-9]+}}(%esp)
; GISEL-X86-NEXT:    fxch %st(1)
; GISEL-X86-NEXT:    fucompi %st(1), %st
; GISEL-X86-NEXT:    fstp %st(0)
; GISEL-X86-NEXT:    setp %al
; GISEL-X86-NEXT:    retl
    %1 = fcmp uno x86_fp80 %x, %y
    ret i1 %1
  }

  define i1 @fcmp_x86_fp80_ueq(x86_fp80 %x, x86_fp80 %y) nounwind {
; X64-LABEL: fcmp_x86_fp80_ueq:
; X64:       ## %bb.0:
; X64-NEXT:    fldt {{[0-9]+}}(%rsp)
; X64-NEXT:    fldt {{[0-9]+}}(%rsp)
; X64-NEXT:    fucompi %st(1), %st
; X64-NEXT:    fstp %st(0)
; X64-NEXT:    sete %al
; X64-NEXT:    retq
;
; GISEL-X64-LABEL: fcmp_x86_fp80_ueq:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    fldt {{[0-9]+}}(%rsp)
; GISEL-X64-NEXT:    fldt {{[0-9]+}}(%rsp)
; GISEL-X64-NEXT:    fxch %st(1)
; GISEL-X64-NEXT:    fucompi %st(1), %st
; GISEL-X64-NEXT:    fstp %st(0)
; GISEL-X64-NEXT:    sete %al
; GISEL-X64-NEXT:    retq
;
; X86-LABEL: fcmp_x86_fp80_ueq:
; X86:       ## %bb.0:
; X86-NEXT:    fldt {{[0-9]+}}(%esp)
; X86-NEXT:    fldt {{[0-9]+}}(%esp)
; X86-NEXT:    fucompp
; X86-NEXT:    fnstsw %ax
; X86-NEXT:    ## kill: def $ah killed $ah killed $ax
; X86-NEXT:    sahf
; X86-NEXT:    sete %al
; X86-NEXT:    retl
;
; GISEL-X86-LABEL: fcmp_x86_fp80_ueq:
; GISEL-X86:       ## %bb.0:
; GISEL-X86-NEXT:    fldt {{[0-9]+}}(%esp)
; GISEL-X86-NEXT:    fldt {{[0-9]+}}(%esp)
; GISEL-X86-NEXT:    fxch %st(1)
; GISEL-X86-NEXT:    fucompi %st(1), %st
; GISEL-X86-NEXT:    fstp %st(0)
; GISEL-X86-NEXT:    sete %al
; GISEL-X86-NEXT:    retl
    %1 = fcmp ueq x86_fp80 %x, %y
    ret i1 %1
  }

  define i1 @fcmp_x86_fp80_ugt(x86_fp80 %x, x86_fp80 %y) nounwind {
; SDAG-X64-LABEL: fcmp_x86_fp80_ugt:
; SDAG-X64:       ## %bb.0:
; SDAG-X64-NEXT:    fldt {{[0-9]+}}(%rsp)
; SDAG-X64-NEXT:    fldt {{[0-9]+}}(%rsp)
; SDAG-X64-NEXT:    fucompi %st(1), %st
; SDAG-X64-NEXT:    fstp %st(0)
; SDAG-X64-NEXT:    setb %al
; SDAG-X64-NEXT:    retq
;
; FAST-X64-LABEL: fcmp_x86_fp80_ugt:
; FAST-X64:       ## %bb.0:
; FAST-X64-NEXT:    fldt {{[0-9]+}}(%rsp)
; FAST-X64-NEXT:    fldt {{[0-9]+}}(%rsp)
; FAST-X64-NEXT:    fxch %st(1)
; FAST-X64-NEXT:    fucompi %st(1), %st
; FAST-X64-NEXT:    fstp %st(0)
; FAST-X64-NEXT:    setb %al
; FAST-X64-NEXT:    retq
;
; GISEL-X64-LABEL: fcmp_x86_fp80_ugt:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    fldt {{[0-9]+}}(%rsp)
; GISEL-X64-NEXT:    fldt {{[0-9]+}}(%rsp)
; GISEL-X64-NEXT:    fucompi %st(1), %st
; GISEL-X64-NEXT:    fstp %st(0)
; GISEL-X64-NEXT:    setb %al
; GISEL-X64-NEXT:    retq
;
; SDAG-X86-LABEL: fcmp_x86_fp80_ugt:
; SDAG-X86:       ## %bb.0:
; SDAG-X86-NEXT:    fldt {{[0-9]+}}(%esp)
; SDAG-X86-NEXT:    fldt {{[0-9]+}}(%esp)
; SDAG-X86-NEXT:    fucompp
; SDAG-X86-NEXT:    fnstsw %ax
; SDAG-X86-NEXT:    ## kill: def $ah killed $ah killed $ax
; SDAG-X86-NEXT:    sahf
; SDAG-X86-NEXT:    setb %al
; SDAG-X86-NEXT:    retl
;
; FAST-X86-LABEL: fcmp_x86_fp80_ugt:
; FAST-X86:       ## %bb.0:
; FAST-X86-NEXT:    fldt {{[0-9]+}}(%esp)
; FAST-X86-NEXT:    fldt {{[0-9]+}}(%esp)
; FAST-X86-NEXT:    fxch %st(1)
; FAST-X86-NEXT:    fucompp
; FAST-X86-NEXT:    fnstsw %ax
; FAST-X86-NEXT:    ## kill: def $ah killed $ah killed $ax
; FAST-X86-NEXT:    sahf
; FAST-X86-NEXT:    setb %al
; FAST-X86-NEXT:    retl
;
; GISEL-X86-LABEL: fcmp_x86_fp80_ugt:
; GISEL-X86:       ## %bb.0:
; GISEL-X86-NEXT:    fldt {{[0-9]+}}(%esp)
; GISEL-X86-NEXT:    fldt {{[0-9]+}}(%esp)
; GISEL-X86-NEXT:    fucompi %st(1), %st
; GISEL-X86-NEXT:    fstp %st(0)
; GISEL-X86-NEXT:    setb %al
; GISEL-X86-NEXT:    retl
    %1 = fcmp ugt x86_fp80 %x, %y
    ret i1 %1
  }

  define i1 @fcmp_x86_fp80_uge(x86_fp80 %x, x86_fp80 %y) nounwind {
; SDAG-X64-LABEL: fcmp_x86_fp80_uge:
; SDAG-X64:       ## %bb.0:
; SDAG-X64-NEXT:    fldt {{[0-9]+}}(%rsp)
; SDAG-X64-NEXT:    fldt {{[0-9]+}}(%rsp)
; SDAG-X64-NEXT:    fucompi %st(1), %st
; SDAG-X64-NEXT:    fstp %st(0)
; SDAG-X64-NEXT:    setbe %al
; SDAG-X64-NEXT:    retq
;
; FAST-X64-LABEL: fcmp_x86_fp80_uge:
; FAST-X64:       ## %bb.0:
; FAST-X64-NEXT:    fldt {{[0-9]+}}(%rsp)
; FAST-X64-NEXT:    fldt {{[0-9]+}}(%rsp)
; FAST-X64-NEXT:    fxch %st(1)
; FAST-X64-NEXT:    fucompi %st(1), %st
; FAST-X64-NEXT:    fstp %st(0)
; FAST-X64-NEXT:    setbe %al
; FAST-X64-NEXT:    retq
;
; GISEL-X64-LABEL: fcmp_x86_fp80_uge:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    fldt {{[0-9]+}}(%rsp)
; GISEL-X64-NEXT:    fldt {{[0-9]+}}(%rsp)
; GISEL-X64-NEXT:    fucompi %st(1), %st
; GISEL-X64-NEXT:    fstp %st(0)
; GISEL-X64-NEXT:    setbe %al
; GISEL-X64-NEXT:    retq
;
; SDAG-X86-LABEL: fcmp_x86_fp80_uge:
; SDAG-X86:       ## %bb.0:
; SDAG-X86-NEXT:    fldt {{[0-9]+}}(%esp)
; SDAG-X86-NEXT:    fldt {{[0-9]+}}(%esp)
; SDAG-X86-NEXT:    fucompp
; SDAG-X86-NEXT:    fnstsw %ax
; SDAG-X86-NEXT:    ## kill: def $ah killed $ah killed $ax
; SDAG-X86-NEXT:    sahf
; SDAG-X86-NEXT:    setbe %al
; SDAG-X86-NEXT:    retl
;
; FAST-X86-LABEL: fcmp_x86_fp80_uge:
; FAST-X86:       ## %bb.0:
; FAST-X86-NEXT:    fldt {{[0-9]+}}(%esp)
; FAST-X86-NEXT:    fldt {{[0-9]+}}(%esp)
; FAST-X86-NEXT:    fxch %st(1)
; FAST-X86-NEXT:    fucompp
; FAST-X86-NEXT:    fnstsw %ax
; FAST-X86-NEXT:    ## kill: def $ah killed $ah killed $ax
; FAST-X86-NEXT:    sahf
; FAST-X86-NEXT:    setbe %al
; FAST-X86-NEXT:    retl
;
; GISEL-X86-LABEL: fcmp_x86_fp80_uge:
; GISEL-X86:       ## %bb.0:
; GISEL-X86-NEXT:    fldt {{[0-9]+}}(%esp)
; GISEL-X86-NEXT:    fldt {{[0-9]+}}(%esp)
; GISEL-X86-NEXT:    fucompi %st(1), %st
; GISEL-X86-NEXT:    fstp %st(0)
; GISEL-X86-NEXT:    setbe %al
; GISEL-X86-NEXT:    retl
    %1 = fcmp uge x86_fp80 %x, %y
    ret i1 %1
  }

  define i1 @fcmp_x86_fp80_ult(x86_fp80 %x, x86_fp80 %y) nounwind {
; X64-LABEL: fcmp_x86_fp80_ult:
; X64:       ## %bb.0:
; X64-NEXT:    fldt {{[0-9]+}}(%rsp)
; X64-NEXT:    fldt {{[0-9]+}}(%rsp)
; X64-NEXT:    fucompi %st(1), %st
; X64-NEXT:    fstp %st(0)
; X64-NEXT:    setb %al
; X64-NEXT:    retq
;
; GISEL-X64-LABEL: fcmp_x86_fp80_ult:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    fldt {{[0-9]+}}(%rsp)
; GISEL-X64-NEXT:    fldt {{[0-9]+}}(%rsp)
; GISEL-X64-NEXT:    fxch %st(1)
; GISEL-X64-NEXT:    fucompi %st(1), %st
; GISEL-X64-NEXT:    fstp %st(0)
; GISEL-X64-NEXT:    setb %al
; GISEL-X64-NEXT:    retq
;
; X86-LABEL: fcmp_x86_fp80_ult:
; X86:       ## %bb.0:
; X86-NEXT:    fldt {{[0-9]+}}(%esp)
; X86-NEXT:    fldt {{[0-9]+}}(%esp)
; X86-NEXT:    fucompp
; X86-NEXT:    fnstsw %ax
; X86-NEXT:    ## kill: def $ah killed $ah killed $ax
; X86-NEXT:    sahf
; X86-NEXT:    setb %al
; X86-NEXT:    retl
;
; GISEL-X86-LABEL: fcmp_x86_fp80_ult:
; GISEL-X86:       ## %bb.0:
; GISEL-X86-NEXT:    fldt {{[0-9]+}}(%esp)
; GISEL-X86-NEXT:    fldt {{[0-9]+}}(%esp)
; GISEL-X86-NEXT:    fxch %st(1)
; GISEL-X86-NEXT:    fucompi %st(1), %st
; GISEL-X86-NEXT:    fstp %st(0)
; GISEL-X86-NEXT:    setb %al
; GISEL-X86-NEXT:    retl
    %1 = fcmp ult x86_fp80 %x, %y
    ret i1 %1
  }

  define i1 @fcmp_x86_fp80_ule(x86_fp80 %x, x86_fp80 %y) nounwind {
; X64-LABEL: fcmp_x86_fp80_ule:
; X64:       ## %bb.0:
; X64-NEXT:    fldt {{[0-9]+}}(%rsp)
; X64-NEXT:    fldt {{[0-9]+}}(%rsp)
; X64-NEXT:    fucompi %st(1), %st
; X64-NEXT:    fstp %st(0)
; X64-NEXT:    setbe %al
; X64-NEXT:    retq
;
; GISEL-X64-LABEL: fcmp_x86_fp80_ule:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    fldt {{[0-9]+}}(%rsp)
; GISEL-X64-NEXT:    fldt {{[0-9]+}}(%rsp)
; GISEL-X64-NEXT:    fxch %st(1)
; GISEL-X64-NEXT:    fucompi %st(1), %st
; GISEL-X64-NEXT:    fstp %st(0)
; GISEL-X64-NEXT:    setbe %al
; GISEL-X64-NEXT:    retq
;
; X86-LABEL: fcmp_x86_fp80_ule:
; X86:       ## %bb.0:
; X86-NEXT:    fldt {{[0-9]+}}(%esp)
; X86-NEXT:    fldt {{[0-9]+}}(%esp)
; X86-NEXT:    fucompp
; X86-NEXT:    fnstsw %ax
; X86-NEXT:    ## kill: def $ah killed $ah killed $ax
; X86-NEXT:    sahf
; X86-NEXT:    setbe %al
; X86-NEXT:    retl
;
; GISEL-X86-LABEL: fcmp_x86_fp80_ule:
; GISEL-X86:       ## %bb.0:
; GISEL-X86-NEXT:    fldt {{[0-9]+}}(%esp)
; GISEL-X86-NEXT:    fldt {{[0-9]+}}(%esp)
; GISEL-X86-NEXT:    fxch %st(1)
; GISEL-X86-NEXT:    fucompi %st(1), %st
; GISEL-X86-NEXT:    fstp %st(0)
; GISEL-X86-NEXT:    setbe %al
; GISEL-X86-NEXT:    retl
    %1 = fcmp ule x86_fp80 %x, %y
    ret i1 %1
  }

  define i1 @fcmp_x86_fp80_une(x86_fp80 %x, x86_fp80 %y) nounwind {
; X64-LABEL: fcmp_x86_fp80_une:
; X64:       ## %bb.0:
; X64-NEXT:    fldt {{[0-9]+}}(%rsp)
; X64-NEXT:    fldt {{[0-9]+}}(%rsp)
; X64-NEXT:    fucompi %st(1), %st
; X64-NEXT:    fstp %st(0)
; X64-NEXT:    setp %cl
; X64-NEXT:    setne %al
; X64-NEXT:    orb %cl, %al
; X64-NEXT:    retq
;
; GISEL-X64-LABEL: fcmp_x86_fp80_une:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    fldt {{[0-9]+}}(%rsp)
; GISEL-X64-NEXT:    fldt {{[0-9]+}}(%rsp)
; GISEL-X64-NEXT:    fxch %st(1)
; GISEL-X64-NEXT:    fucompi %st(1), %st
; GISEL-X64-NEXT:    fstp %st(0)
; GISEL-X64-NEXT:    setne %cl
; GISEL-X64-NEXT:    setp %al
; GISEL-X64-NEXT:    orb %cl, %al
; GISEL-X64-NEXT:    retq
;
; X86-LABEL: fcmp_x86_fp80_une:
; X86:       ## %bb.0:
; X86-NEXT:    fldt {{[0-9]+}}(%esp)
; X86-NEXT:    fldt {{[0-9]+}}(%esp)
; X86-NEXT:    fucompp
; X86-NEXT:    fnstsw %ax
; X86-NEXT:    ## kill: def $ah killed $ah killed $ax
; X86-NEXT:    sahf
; X86-NEXT:    setp %cl
; X86-NEXT:    setne %al
; X86-NEXT:    orb %cl, %al
; X86-NEXT:    retl
;
; GISEL-X86-LABEL: fcmp_x86_fp80_une:
; GISEL-X86:       ## %bb.0:
; GISEL-X86-NEXT:    fldt {{[0-9]+}}(%esp)
; GISEL-X86-NEXT:    fldt {{[0-9]+}}(%esp)
; GISEL-X86-NEXT:    fxch %st(1)
; GISEL-X86-NEXT:    fucompi %st(1), %st
; GISEL-X86-NEXT:    fstp %st(0)
; GISEL-X86-NEXT:    setne %cl
; GISEL-X86-NEXT:    setp %al
; GISEL-X86-NEXT:    orb %cl, %al
; GISEL-X86-NEXT:    retl
    %1 = fcmp une x86_fp80 %x, %y
    ret i1 %1
  }

  define i1 @fcmp_float_oeq(float %x, float %y) {
; X64-LABEL: fcmp_float_oeq:
; X64:       ## %bb.0:
; X64-NEXT:    flds {{[0-9]+}}(%rsp)
; X64-NEXT:    flds {{[0-9]+}}(%rsp)
; X64-NEXT:    fucompi %st(1), %st
; X64-NEXT:    fstp %st(0)
; X64-NEXT:    setnp %cl
; X64-NEXT:    sete %al
; X64-NEXT:    andb %cl, %al
; X64-NEXT:    retq
;
; GISEL-X64-LABEL: fcmp_float_oeq:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    flds {{[0-9]+}}(%rsp)
; GISEL-X64-NEXT:    flds {{[0-9]+}}(%rsp)
; GISEL-X64-NEXT:    fxch %st(1)
; GISEL-X64-NEXT:    fucompi %st(1), %st
; GISEL-X64-NEXT:    fstp %st(0)
; GISEL-X64-NEXT:    sete %cl
; GISEL-X64-NEXT:    setnp %al
; GISEL-X64-NEXT:    andb %cl, %al
; GISEL-X64-NEXT:    retq
;
; X86-LABEL: fcmp_float_oeq:
; X86:       ## %bb.0:
; X86-NEXT:    flds {{[0-9]+}}(%esp)
; X86-NEXT:    flds {{[0-9]+}}(%esp)
; X86-NEXT:    fucompp
; X86-NEXT:    fnstsw %ax
; X86-NEXT:    ## kill: def $ah killed $ah killed $ax
; X86-NEXT:    sahf
; X86-NEXT:    setnp %cl
; X86-NEXT:    sete %al
; X86-NEXT:    andb %cl, %al
; X86-NEXT:    retl
;
; GISEL-X86-LABEL: fcmp_float_oeq:
; GISEL-X86:       ## %bb.0:
; GISEL-X86-NEXT:    flds {{[0-9]+}}(%esp)
; GISEL-X86-NEXT:    flds {{[0-9]+}}(%esp)
; GISEL-X86-NEXT:    fxch %st(1)
; GISEL-X86-NEXT:    fucompi %st(1), %st
; GISEL-X86-NEXT:    fstp %st(0)
; GISEL-X86-NEXT:    sete %cl
; GISEL-X86-NEXT:    setnp %al
; GISEL-X86-NEXT:    andb %cl, %al
; GISEL-X86-NEXT:    retl
    %1 = fcmp oeq float %x, %y
    ret i1 %1
  }

  define i1 @fcmp_float_ogt(float %x, float %y) {
; X64-LABEL: fcmp_float_ogt:
; X64:       ## %bb.0:
; X64-NEXT:    flds {{[0-9]+}}(%rsp)
; X64-NEXT:    flds {{[0-9]+}}(%rsp)
; X64-NEXT:    fucompi %st(1), %st
; X64-NEXT:    fstp %st(0)
; X64-NEXT:    seta %al
; X64-NEXT:    retq
;
; GISEL-X64-LABEL: fcmp_float_ogt:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    flds {{[0-9]+}}(%rsp)
; GISEL-X64-NEXT:    flds {{[0-9]+}}(%rsp)
; GISEL-X64-NEXT:    fxch %st(1)
; GISEL-X64-NEXT:    fucompi %st(1), %st
; GISEL-X64-NEXT:    fstp %st(0)
; GISEL-X64-NEXT:    seta %al
; GISEL-X64-NEXT:    retq
;
; X86-LABEL: fcmp_float_ogt:
; X86:       ## %bb.0:
; X86-NEXT:    flds {{[0-9]+}}(%esp)
; X86-NEXT:    flds {{[0-9]+}}(%esp)
; X86-NEXT:    fucompp
; X86-NEXT:    fnstsw %ax
; X86-NEXT:    ## kill: def $ah killed $ah killed $ax
; X86-NEXT:    sahf
; X86-NEXT:    seta %al
; X86-NEXT:    retl
;
; GISEL-X86-LABEL: fcmp_float_ogt:
; GISEL-X86:       ## %bb.0:
; GISEL-X86-NEXT:    flds {{[0-9]+}}(%esp)
; GISEL-X86-NEXT:    flds {{[0-9]+}}(%esp)
; GISEL-X86-NEXT:    fxch %st(1)
; GISEL-X86-NEXT:    fucompi %st(1), %st
; GISEL-X86-NEXT:    fstp %st(0)
; GISEL-X86-NEXT:    seta %al
; GISEL-X86-NEXT:    retl
    %1 = fcmp ogt float %x, %y
    ret i1 %1
  }

  define i1 @fcmp_float_oge(float %x, float %y) {
; X64-LABEL: fcmp_float_oge:
; X64:       ## %bb.0:
; X64-NEXT:    flds {{[0-9]+}}(%rsp)
; X64-NEXT:    flds {{[0-9]+}}(%rsp)
; X64-NEXT:    fucompi %st(1), %st
; X64-NEXT:    fstp %st(0)
; X64-NEXT:    setae %al
; X64-NEXT:    retq
;
; GISEL-X64-LABEL: fcmp_float_oge:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    flds {{[0-9]+}}(%rsp)
; GISEL-X64-NEXT:    flds {{[0-9]+}}(%rsp)
; GISEL-X64-NEXT:    fxch %st(1)
; GISEL-X64-NEXT:    fucompi %st(1), %st
; GISEL-X64-NEXT:    fstp %st(0)
; GISEL-X64-NEXT:    setae %al
; GISEL-X64-NEXT:    retq
;
; X86-LABEL: fcmp_float_oge:
; X86:       ## %bb.0:
; X86-NEXT:    flds {{[0-9]+}}(%esp)
; X86-NEXT:    flds {{[0-9]+}}(%esp)
; X86-NEXT:    fucompp
; X86-NEXT:    fnstsw %ax
; X86-NEXT:    ## kill: def $ah killed $ah killed $ax
; X86-NEXT:    sahf
; X86-NEXT:    setae %al
; X86-NEXT:    retl
;
; GISEL-X86-LABEL: fcmp_float_oge:
; GISEL-X86:       ## %bb.0:
; GISEL-X86-NEXT:    flds {{[0-9]+}}(%esp)
; GISEL-X86-NEXT:    flds {{[0-9]+}}(%esp)
; GISEL-X86-NEXT:    fxch %st(1)
; GISEL-X86-NEXT:    fucompi %st(1), %st
; GISEL-X86-NEXT:    fstp %st(0)
; GISEL-X86-NEXT:    setae %al
; GISEL-X86-NEXT:    retl
    %1 = fcmp oge float %x, %y
    ret i1 %1
  }

  define i1 @fcmp_float_olt(float %x, float %y) {
; SDAG-X64-LABEL: fcmp_float_olt:
; SDAG-X64:       ## %bb.0:
; SDAG-X64-NEXT:    flds {{[0-9]+}}(%rsp)
; SDAG-X64-NEXT:    flds {{[0-9]+}}(%rsp)
; SDAG-X64-NEXT:    fucompi %st(1), %st
; SDAG-X64-NEXT:    fstp %st(0)
; SDAG-X64-NEXT:    seta %al
; SDAG-X64-NEXT:    retq
;
; FAST-X64-LABEL: fcmp_float_olt:
; FAST-X64:       ## %bb.0:
; FAST-X64-NEXT:    flds {{[0-9]+}}(%rsp)
; FAST-X64-NEXT:    flds {{[0-9]+}}(%rsp)
; FAST-X64-NEXT:    fxch %st(1)
; FAST-X64-NEXT:    fucompi %st(1), %st
; FAST-X64-NEXT:    fstp %st(0)
; FAST-X64-NEXT:    seta %al
; FAST-X64-NEXT:    retq
;
; GISEL-X64-LABEL: fcmp_float_olt:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    flds {{[0-9]+}}(%rsp)
; GISEL-X64-NEXT:    flds {{[0-9]+}}(%rsp)
; GISEL-X64-NEXT:    fucompi %st(1), %st
; GISEL-X64-NEXT:    fstp %st(0)
; GISEL-X64-NEXT:    seta %al
; GISEL-X64-NEXT:    retq
;
; SDAG-X86-LABEL: fcmp_float_olt:
; SDAG-X86:       ## %bb.0:
; SDAG-X86-NEXT:    flds {{[0-9]+}}(%esp)
; SDAG-X86-NEXT:    flds {{[0-9]+}}(%esp)
; SDAG-X86-NEXT:    fucompp
; SDAG-X86-NEXT:    fnstsw %ax
; SDAG-X86-NEXT:    ## kill: def $ah killed $ah killed $ax
; SDAG-X86-NEXT:    sahf
; SDAG-X86-NEXT:    seta %al
; SDAG-X86-NEXT:    retl
;
; FAST-X86-LABEL: fcmp_float_olt:
; FAST-X86:       ## %bb.0:
; FAST-X86-NEXT:    flds {{[0-9]+}}(%esp)
; FAST-X86-NEXT:    flds {{[0-9]+}}(%esp)
; FAST-X86-NEXT:    fxch %st(1)
; FAST-X86-NEXT:    fucompp
; FAST-X86-NEXT:    fnstsw %ax
; FAST-X86-NEXT:    ## kill: def $ah killed $ah killed $ax
; FAST-X86-NEXT:    sahf
; FAST-X86-NEXT:    seta %al
; FAST-X86-NEXT:    retl
;
; GISEL-X86-LABEL: fcmp_float_olt:
; GISEL-X86:       ## %bb.0:
; GISEL-X86-NEXT:    flds {{[0-9]+}}(%esp)
; GISEL-X86-NEXT:    flds {{[0-9]+}}(%esp)
; GISEL-X86-NEXT:    fucompi %st(1), %st
; GISEL-X86-NEXT:    fstp %st(0)
; GISEL-X86-NEXT:    seta %al
; GISEL-X86-NEXT:    retl
    %1 = fcmp olt float %x, %y
    ret i1 %1
  }

  define i1 @fcmp_float_ole(float %x, float %y) {
; SDAG-X64-LABEL: fcmp_float_ole:
; SDAG-X64:       ## %bb.0:
; SDAG-X64-NEXT:    flds {{[0-9]+}}(%rsp)
; SDAG-X64-NEXT:    flds {{[0-9]+}}(%rsp)
; SDAG-X64-NEXT:    fucompi %st(1), %st
; SDAG-X64-NEXT:    fstp %st(0)
; SDAG-X64-NEXT:    setae %al
; SDAG-X64-NEXT:    retq
;
; FAST-X64-LABEL: fcmp_float_ole:
; FAST-X64:       ## %bb.0:
; FAST-X64-NEXT:    flds {{[0-9]+}}(%rsp)
; FAST-X64-NEXT:    flds {{[0-9]+}}(%rsp)
; FAST-X64-NEXT:    fxch %st(1)
; FAST-X64-NEXT:    fucompi %st(1), %st
; FAST-X64-NEXT:    fstp %st(0)
; FAST-X64-NEXT:    setae %al
; FAST-X64-NEXT:    retq
;
; GISEL-X64-LABEL: fcmp_float_ole:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    flds {{[0-9]+}}(%rsp)
; GISEL-X64-NEXT:    flds {{[0-9]+}}(%rsp)
; GISEL-X64-NEXT:    fucompi %st(1), %st
; GISEL-X64-NEXT:    fstp %st(0)
; GISEL-X64-NEXT:    setae %al
; GISEL-X64-NEXT:    retq
;
; SDAG-X86-LABEL: fcmp_float_ole:
; SDAG-X86:       ## %bb.0:
; SDAG-X86-NEXT:    flds {{[0-9]+}}(%esp)
; SDAG-X86-NEXT:    flds {{[0-9]+}}(%esp)
; SDAG-X86-NEXT:    fucompp
; SDAG-X86-NEXT:    fnstsw %ax
; SDAG-X86-NEXT:    ## kill: def $ah killed $ah killed $ax
; SDAG-X86-NEXT:    sahf
; SDAG-X86-NEXT:    setae %al
; SDAG-X86-NEXT:    retl
;
; FAST-X86-LABEL: fcmp_float_ole:
; FAST-X86:       ## %bb.0:
; FAST-X86-NEXT:    flds {{[0-9]+}}(%esp)
; FAST-X86-NEXT:    flds {{[0-9]+}}(%esp)
; FAST-X86-NEXT:    fxch %st(1)
; FAST-X86-NEXT:    fucompp
; FAST-X86-NEXT:    fnstsw %ax
; FAST-X86-NEXT:    ## kill: def $ah killed $ah killed $ax
; FAST-X86-NEXT:    sahf
; FAST-X86-NEXT:    setae %al
; FAST-X86-NEXT:    retl
;
; GISEL-X86-LABEL: fcmp_float_ole:
; GISEL-X86:       ## %bb.0:
; GISEL-X86-NEXT:    flds {{[0-9]+}}(%esp)
; GISEL-X86-NEXT:    flds {{[0-9]+}}(%esp)
; GISEL-X86-NEXT:    fucompi %st(1), %st
; GISEL-X86-NEXT:    fstp %st(0)
; GISEL-X86-NEXT:    setae %al
; GISEL-X86-NEXT:    retl
    %1 = fcmp ole float %x, %y
    ret i1 %1
  }

  define i1 @fcmp_float_one(float %x, float %y) {
; X64-LABEL: fcmp_float_one:
; X64:       ## %bb.0:
; X64-NEXT:    flds {{[0-9]+}}(%rsp)
; X64-NEXT:    flds {{[0-9]+}}(%rsp)
; X64-NEXT:    fucompi %st(1), %st
; X64-NEXT:    fstp %st(0)
; X64-NEXT:    setne %al
; X64-NEXT:    retq
;
; GISEL-X64-LABEL: fcmp_float_one:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    flds {{[0-9]+}}(%rsp)
; GISEL-X64-NEXT:    flds {{[0-9]+}}(%rsp)
; GISEL-X64-NEXT:    fxch %st(1)
; GISEL-X64-NEXT:    fucompi %st(1), %st
; GISEL-X64-NEXT:    fstp %st(0)
; GISEL-X64-NEXT:    setne %al
; GISEL-X64-NEXT:    retq
;
; X86-LABEL: fcmp_float_one:
; X86:       ## %bb.0:
; X86-NEXT:    flds {{[0-9]+}}(%esp)
; X86-NEXT:    flds {{[0-9]+}}(%esp)
; X86-NEXT:    fucompp
; X86-NEXT:    fnstsw %ax
; X86-NEXT:    ## kill: def $ah killed $ah killed $ax
; X86-NEXT:    sahf
; X86-NEXT:    setne %al
; X86-NEXT:    retl
;
; GISEL-X86-LABEL: fcmp_float_one:
; GISEL-X86:       ## %bb.0:
; GISEL-X86-NEXT:    flds {{[0-9]+}}(%esp)
; GISEL-X86-NEXT:    flds {{[0-9]+}}(%esp)
; GISEL-X86-NEXT:    fxch %st(1)
; GISEL-X86-NEXT:    fucompi %st(1), %st
; GISEL-X86-NEXT:    fstp %st(0)
; GISEL-X86-NEXT:    setne %al
; GISEL-X86-NEXT:    retl
    %1 = fcmp one float %x, %y
    ret i1 %1
  }

  define i1 @fcmp_float_ord(float %x, float %y) {
; X64-LABEL: fcmp_float_ord:
; X64:       ## %bb.0:
; X64-NEXT:    flds {{[0-9]+}}(%rsp)
; X64-NEXT:    flds {{[0-9]+}}(%rsp)
; X64-NEXT:    fucompi %st(1), %st
; X64-NEXT:    fstp %st(0)
; X64-NEXT:    setnp %al
; X64-NEXT:    retq
;
; GISEL-X64-LABEL: fcmp_float_ord:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    flds {{[0-9]+}}(%rsp)
; GISEL-X64-NEXT:    flds {{[0-9]+}}(%rsp)
; GISEL-X64-NEXT:    fxch %st(1)
; GISEL-X64-NEXT:    fucompi %st(1), %st
; GISEL-X64-NEXT:    fstp %st(0)
; GISEL-X64-NEXT:    setnp %al
; GISEL-X64-NEXT:    retq
;
; X86-LABEL: fcmp_float_ord:
; X86:       ## %bb.0:
; X86-NEXT:    flds {{[0-9]+}}(%esp)
; X86-NEXT:    flds {{[0-9]+}}(%esp)
; X86-NEXT:    fucompp
; X86-NEXT:    fnstsw %ax
; X86-NEXT:    ## kill: def $ah killed $ah killed $ax
; X86-NEXT:    sahf
; X86-NEXT:    setnp %al
; X86-NEXT:    retl
;
; GISEL-X86-LABEL: fcmp_float_ord:
; GISEL-X86:       ## %bb.0:
; GISEL-X86-NEXT:    flds {{[0-9]+}}(%esp)
; GISEL-X86-NEXT:    flds {{[0-9]+}}(%esp)
; GISEL-X86-NEXT:    fxch %st(1)
; GISEL-X86-NEXT:    fucompi %st(1), %st
; GISEL-X86-NEXT:    fstp %st(0)
; GISEL-X86-NEXT:    setnp %al
; GISEL-X86-NEXT:    retl
    %1 = fcmp ord float %x, %y
    ret i1 %1
  }

  define i1 @fcmp_float_uno(float %x, float %y) {
; X64-LABEL: fcmp_float_uno:
; X64:       ## %bb.0:
; X64-NEXT:    flds {{[0-9]+}}(%rsp)
; X64-NEXT:    flds {{[0-9]+}}(%rsp)
; X64-NEXT:    fucompi %st(1), %st
; X64-NEXT:    fstp %st(0)
; X64-NEXT:    setp %al
; X64-NEXT:    retq
;
; GISEL-X64-LABEL: fcmp_float_uno:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    flds {{[0-9]+}}(%rsp)
; GISEL-X64-NEXT:    flds {{[0-9]+}}(%rsp)
; GISEL-X64-NEXT:    fxch %st(1)
; GISEL-X64-NEXT:    fucompi %st(1), %st
; GISEL-X64-NEXT:    fstp %st(0)
; GISEL-X64-NEXT:    setp %al
; GISEL-X64-NEXT:    retq
;
; X86-LABEL: fcmp_float_uno:
; X86:       ## %bb.0:
; X86-NEXT:    flds {{[0-9]+}}(%esp)
; X86-NEXT:    flds {{[0-9]+}}(%esp)
; X86-NEXT:    fucompp
; X86-NEXT:    fnstsw %ax
; X86-NEXT:    ## kill: def $ah killed $ah killed $ax
; X86-NEXT:    sahf
; X86-NEXT:    setp %al
; X86-NEXT:    retl
;
; GISEL-X86-LABEL: fcmp_float_uno:
; GISEL-X86:       ## %bb.0:
; GISEL-X86-NEXT:    flds {{[0-9]+}}(%esp)
; GISEL-X86-NEXT:    flds {{[0-9]+}}(%esp)
; GISEL-X86-NEXT:    fxch %st(1)
; GISEL-X86-NEXT:    fucompi %st(1), %st
; GISEL-X86-NEXT:    fstp %st(0)
; GISEL-X86-NEXT:    setp %al
; GISEL-X86-NEXT:    retl
    %1 = fcmp uno float %x, %y
    ret i1 %1
  }

  define i1 @fcmp_float_ueq(float %x, float %y) {
; X64-LABEL: fcmp_float_ueq:
; X64:       ## %bb.0:
; X64-NEXT:    flds {{[0-9]+}}(%rsp)
; X64-NEXT:    flds {{[0-9]+}}(%rsp)
; X64-NEXT:    fucompi %st(1), %st
; X64-NEXT:    fstp %st(0)
; X64-NEXT:    sete %al
; X64-NEXT:    retq
;
; GISEL-X64-LABEL: fcmp_float_ueq:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    flds {{[0-9]+}}(%rsp)
; GISEL-X64-NEXT:    flds {{[0-9]+}}(%rsp)
; GISEL-X64-NEXT:    fxch %st(1)
; GISEL-X64-NEXT:    fucompi %st(1), %st
; GISEL-X64-NEXT:    fstp %st(0)
; GISEL-X64-NEXT:    sete %al
; GISEL-X64-NEXT:    retq
;
; X86-LABEL: fcmp_float_ueq:
; X86:       ## %bb.0:
; X86-NEXT:    flds {{[0-9]+}}(%esp)
; X86-NEXT:    flds {{[0-9]+}}(%esp)
; X86-NEXT:    fucompp
; X86-NEXT:    fnstsw %ax
; X86-NEXT:    ## kill: def $ah killed $ah killed $ax
; X86-NEXT:    sahf
; X86-NEXT:    sete %al
; X86-NEXT:    retl
;
; GISEL-X86-LABEL: fcmp_float_ueq:
; GISEL-X86:       ## %bb.0:
; GISEL-X86-NEXT:    flds {{[0-9]+}}(%esp)
; GISEL-X86-NEXT:    flds {{[0-9]+}}(%esp)
; GISEL-X86-NEXT:    fxch %st(1)
; GISEL-X86-NEXT:    fucompi %st(1), %st
; GISEL-X86-NEXT:    fstp %st(0)
; GISEL-X86-NEXT:    sete %al
; GISEL-X86-NEXT:    retl
    %1 = fcmp ueq float %x, %y
    ret i1 %1
  }

  define i1 @fcmp_float_ugt(float %x, float %y) {
; SDAG-X64-LABEL: fcmp_float_ugt:
; SDAG-X64:       ## %bb.0:
; SDAG-X64-NEXT:    flds {{[0-9]+}}(%rsp)
; SDAG-X64-NEXT:    flds {{[0-9]+}}(%rsp)
; SDAG-X64-NEXT:    fucompi %st(1), %st
; SDAG-X64-NEXT:    fstp %st(0)
; SDAG-X64-NEXT:    setb %al
; SDAG-X64-NEXT:    retq
;
; FAST-X64-LABEL: fcmp_float_ugt:
; FAST-X64:       ## %bb.0:
; FAST-X64-NEXT:    flds {{[0-9]+}}(%rsp)
; FAST-X64-NEXT:    flds {{[0-9]+}}(%rsp)
; FAST-X64-NEXT:    fxch %st(1)
; FAST-X64-NEXT:    fucompi %st(1), %st
; FAST-X64-NEXT:    fstp %st(0)
; FAST-X64-NEXT:    setb %al
; FAST-X64-NEXT:    retq
;
; GISEL-X64-LABEL: fcmp_float_ugt:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    flds {{[0-9]+}}(%rsp)
; GISEL-X64-NEXT:    flds {{[0-9]+}}(%rsp)
; GISEL-X64-NEXT:    fucompi %st(1), %st
; GISEL-X64-NEXT:    fstp %st(0)
; GISEL-X64-NEXT:    setb %al
; GISEL-X64-NEXT:    retq
;
; SDAG-X86-LABEL: fcmp_float_ugt:
; SDAG-X86:       ## %bb.0:
; SDAG-X86-NEXT:    flds {{[0-9]+}}(%esp)
; SDAG-X86-NEXT:    flds {{[0-9]+}}(%esp)
; SDAG-X86-NEXT:    fucompp
; SDAG-X86-NEXT:    fnstsw %ax
; SDAG-X86-NEXT:    ## kill: def $ah killed $ah killed $ax
; SDAG-X86-NEXT:    sahf
; SDAG-X86-NEXT:    setb %al
; SDAG-X86-NEXT:    retl
;
; FAST-X86-LABEL: fcmp_float_ugt:
; FAST-X86:       ## %bb.0:
; FAST-X86-NEXT:    flds {{[0-9]+}}(%esp)
; FAST-X86-NEXT:    flds {{[0-9]+}}(%esp)
; FAST-X86-NEXT:    fxch %st(1)
; FAST-X86-NEXT:    fucompp
; FAST-X86-NEXT:    fnstsw %ax
; FAST-X86-NEXT:    ## kill: def $ah killed $ah killed $ax
; FAST-X86-NEXT:    sahf
; FAST-X86-NEXT:    setb %al
; FAST-X86-NEXT:    retl
;
; GISEL-X86-LABEL: fcmp_float_ugt:
; GISEL-X86:       ## %bb.0:
; GISEL-X86-NEXT:    flds {{[0-9]+}}(%esp)
; GISEL-X86-NEXT:    flds {{[0-9]+}}(%esp)
; GISEL-X86-NEXT:    fucompi %st(1), %st
; GISEL-X86-NEXT:    fstp %st(0)
; GISEL-X86-NEXT:    setb %al
; GISEL-X86-NEXT:    retl
    %1 = fcmp ugt float %x, %y
    ret i1 %1
  }

  define i1 @fcmp_float_uge(float %x, float %y) {
; SDAG-X64-LABEL: fcmp_float_uge:
; SDAG-X64:       ## %bb.0:
; SDAG-X64-NEXT:    flds {{[0-9]+}}(%rsp)
; SDAG-X64-NEXT:    flds {{[0-9]+}}(%rsp)
; SDAG-X64-NEXT:    fucompi %st(1), %st
; SDAG-X64-NEXT:    fstp %st(0)
; SDAG-X64-NEXT:    setbe %al
; SDAG-X64-NEXT:    retq
;
; FAST-X64-LABEL: fcmp_float_uge:
; FAST-X64:       ## %bb.0:
; FAST-X64-NEXT:    flds {{[0-9]+}}(%rsp)
; FAST-X64-NEXT:    flds {{[0-9]+}}(%rsp)
; FAST-X64-NEXT:    fxch %st(1)
; FAST-X64-NEXT:    fucompi %st(1), %st
; FAST-X64-NEXT:    fstp %st(0)
; FAST-X64-NEXT:    setbe %al
; FAST-X64-NEXT:    retq
;
; GISEL-X64-LABEL: fcmp_float_uge:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    flds {{[0-9]+}}(%rsp)
; GISEL-X64-NEXT:    flds {{[0-9]+}}(%rsp)
; GISEL-X64-NEXT:    fucompi %st(1), %st
; GISEL-X64-NEXT:    fstp %st(0)
; GISEL-X64-NEXT:    setbe %al
; GISEL-X64-NEXT:    retq
;
; SDAG-X86-LABEL: fcmp_float_uge:
; SDAG-X86:       ## %bb.0:
; SDAG-X86-NEXT:    flds {{[0-9]+}}(%esp)
; SDAG-X86-NEXT:    flds {{[0-9]+}}(%esp)
; SDAG-X86-NEXT:    fucompp
; SDAG-X86-NEXT:    fnstsw %ax
; SDAG-X86-NEXT:    ## kill: def $ah killed $ah killed $ax
; SDAG-X86-NEXT:    sahf
; SDAG-X86-NEXT:    setbe %al
; SDAG-X86-NEXT:    retl
;
; FAST-X86-LABEL: fcmp_float_uge:
; FAST-X86:       ## %bb.0:
; FAST-X86-NEXT:    flds {{[0-9]+}}(%esp)
; FAST-X86-NEXT:    flds {{[0-9]+}}(%esp)
; FAST-X86-NEXT:    fxch %st(1)
; FAST-X86-NEXT:    fucompp
; FAST-X86-NEXT:    fnstsw %ax
; FAST-X86-NEXT:    ## kill: def $ah killed $ah killed $ax
; FAST-X86-NEXT:    sahf
; FAST-X86-NEXT:    setbe %al
; FAST-X86-NEXT:    retl
;
; GISEL-X86-LABEL: fcmp_float_uge:
; GISEL-X86:       ## %bb.0:
; GISEL-X86-NEXT:    flds {{[0-9]+}}(%esp)
; GISEL-X86-NEXT:    flds {{[0-9]+}}(%esp)
; GISEL-X86-NEXT:    fucompi %st(1), %st
; GISEL-X86-NEXT:    fstp %st(0)
; GISEL-X86-NEXT:    setbe %al
; GISEL-X86-NEXT:    retl
    %1 = fcmp uge float %x, %y
    ret i1 %1
  }

  define i1 @fcmp_float_ult(float %x, float %y) {
; X64-LABEL: fcmp_float_ult:
; X64:       ## %bb.0:
; X64-NEXT:    flds {{[0-9]+}}(%rsp)
; X64-NEXT:    flds {{[0-9]+}}(%rsp)
; X64-NEXT:    fucompi %st(1), %st
; X64-NEXT:    fstp %st(0)
; X64-NEXT:    setb %al
; X64-NEXT:    retq
;
; GISEL-X64-LABEL: fcmp_float_ult:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    flds {{[0-9]+}}(%rsp)
; GISEL-X64-NEXT:    flds {{[0-9]+}}(%rsp)
; GISEL-X64-NEXT:    fxch %st(1)
; GISEL-X64-NEXT:    fucompi %st(1), %st
; GISEL-X64-NEXT:    fstp %st(0)
; GISEL-X64-NEXT:    setb %al
; GISEL-X64-NEXT:    retq
;
; X86-LABEL: fcmp_float_ult:
; X86:       ## %bb.0:
; X86-NEXT:    flds {{[0-9]+}}(%esp)
; X86-NEXT:    flds {{[0-9]+}}(%esp)
; X86-NEXT:    fucompp
; X86-NEXT:    fnstsw %ax
; X86-NEXT:    ## kill: def $ah killed $ah killed $ax
; X86-NEXT:    sahf
; X86-NEXT:    setb %al
; X86-NEXT:    retl
;
; GISEL-X86-LABEL: fcmp_float_ult:
; GISEL-X86:       ## %bb.0:
; GISEL-X86-NEXT:    flds {{[0-9]+}}(%esp)
; GISEL-X86-NEXT:    flds {{[0-9]+}}(%esp)
; GISEL-X86-NEXT:    fxch %st(1)
; GISEL-X86-NEXT:    fucompi %st(1), %st
; GISEL-X86-NEXT:    fstp %st(0)
; GISEL-X86-NEXT:    setb %al
; GISEL-X86-NEXT:    retl
    %1 = fcmp ult float %x, %y
    ret i1 %1
  }

  define i1 @fcmp_float_ule(float %x, float %y) {
; X64-LABEL: fcmp_float_ule:
; X64:       ## %bb.0:
; X64-NEXT:    flds {{[0-9]+}}(%rsp)
; X64-NEXT:    flds {{[0-9]+}}(%rsp)
; X64-NEXT:    fucompi %st(1), %st
; X64-NEXT:    fstp %st(0)
; X64-NEXT:    setbe %al
; X64-NEXT:    retq
;
; GISEL-X64-LABEL: fcmp_float_ule:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    flds {{[0-9]+}}(%rsp)
; GISEL-X64-NEXT:    flds {{[0-9]+}}(%rsp)
; GISEL-X64-NEXT:    fxch %st(1)
; GISEL-X64-NEXT:    fucompi %st(1), %st
; GISEL-X64-NEXT:    fstp %st(0)
; GISEL-X64-NEXT:    setbe %al
; GISEL-X64-NEXT:    retq
;
; X86-LABEL: fcmp_float_ule:
; X86:       ## %bb.0:
; X86-NEXT:    flds {{[0-9]+}}(%esp)
; X86-NEXT:    flds {{[0-9]+}}(%esp)
; X86-NEXT:    fucompp
; X86-NEXT:    fnstsw %ax
; X86-NEXT:    ## kill: def $ah killed $ah killed $ax
; X86-NEXT:    sahf
; X86-NEXT:    setbe %al
; X86-NEXT:    retl
;
; GISEL-X86-LABEL: fcmp_float_ule:
; GISEL-X86:       ## %bb.0:
; GISEL-X86-NEXT:    flds {{[0-9]+}}(%esp)
; GISEL-X86-NEXT:    flds {{[0-9]+}}(%esp)
; GISEL-X86-NEXT:    fxch %st(1)
; GISEL-X86-NEXT:    fucompi %st(1), %st
; GISEL-X86-NEXT:    fstp %st(0)
; GISEL-X86-NEXT:    setbe %al
; GISEL-X86-NEXT:    retl
    %1 = fcmp ule float %x, %y
    ret i1 %1
  }

  define i1 @fcmp_float_une(float %x, float %y) {
; X64-LABEL: fcmp_float_une:
; X64:       ## %bb.0:
; X64-NEXT:    flds {{[0-9]+}}(%rsp)
; X64-NEXT:    flds {{[0-9]+}}(%rsp)
; X64-NEXT:    fucompi %st(1), %st
; X64-NEXT:    fstp %st(0)
; X64-NEXT:    setp %cl
; X64-NEXT:    setne %al
; X64-NEXT:    orb %cl, %al
; X64-NEXT:    retq
;
; GISEL-X64-LABEL: fcmp_float_une:
; GISEL-X64:       ## %bb.0:
; GISEL-X64-NEXT:    flds {{[0-9]+}}(%rsp)
; GISEL-X64-NEXT:    flds {{[0-9]+}}(%rsp)
; GISEL-X64-NEXT:    fxch %st(1)
; GISEL-X64-NEXT:    fucompi %st(1), %st
; GISEL-X64-NEXT:    fstp %st(0)
; GISEL-X64-NEXT:    setne %cl
; GISEL-X64-NEXT:    setp %al
; GISEL-X64-NEXT:    orb %cl, %al
; GISEL-X64-NEXT:    retq
;
; X86-LABEL: fcmp_float_une:
; X86:       ## %bb.0:
; X86-NEXT:    flds {{[0-9]+}}(%esp)
; X86-NEXT:    flds {{[0-9]+}}(%esp)
; X86-NEXT:    fucompp
; X86-NEXT:    fnstsw %ax
; X86-NEXT:    ## kill: def $ah killed $ah killed $ax
; X86-NEXT:    sahf
; X86-NEXT:    setp %cl
; X86-NEXT:    setne %al
; X86-NEXT:    orb %cl, %al
; X86-NEXT:    retl
;
; GISEL-X86-LABEL: fcmp_float_une:
; GISEL-X86:       ## %bb.0:
; GISEL-X86-NEXT:    flds {{[0-9]+}}(%esp)
; GISEL-X86-NEXT:    flds {{[0-9]+}}(%esp)
; GISEL-X86-NEXT:    fxch %st(1)
; GISEL-X86-NEXT:    fucompi %st(1), %st
; GISEL-X86-NEXT:    fstp %st(0)
; GISEL-X86-NEXT:    setne %cl
; GISEL-X86-NEXT:    setp %al
; GISEL-X86-NEXT:    orb %cl, %al
; GISEL-X86-NEXT:    retl
    %1 = fcmp une float %x, %y
    ret i1 %1
  }
