; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -S -mtriple=amdgcn-amd-amdhsa -passes=infer-address-spaces -o - %s | FileCheck %s
; https://github.com/llvm/llvm-project/issues/53665

define i32 @addrspacecast_ptrtoint_inttoptr(ptr addrspace(1) %arg) {
; CHECK-LABEL: @addrspacecast_ptrtoint_inttoptr(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    [[LOAD:%.*]] = load i32, ptr addrspace(1) [[ARG:%.*]], align 4
; CHECK-NEXT:    ret i32 [[LOAD]]
;
bb:
  %asc = addrspacecast ptr addrspace(1) %arg to ptr
  %p2i = ptrtoint ptr %asc to i64
  %i2p = inttoptr i64 %p2i to ptr
  %load = load i32, ptr %i2p
  ret i32 %load
}

define i32 @assumed_ptrtoint_inttoptr(ptr %arg) {
bb:
  %is.priv = call i1 @llvm.amdgcn.is.private(ptr %arg)
  %not.is.priv = xor i1 %is.priv, -1
  %is.shared = call i1 @llvm.amdgcn.is.shared(ptr %arg)
  %not.is.shared = xor i1 %is.shared, -1
  %and = and i1 %not.is.priv, %not.is.shared
  tail call void @llvm.assume(i1 %and)
  %p2i = ptrtoint ptr %arg to i64
  %i2p = inttoptr i64 %p2i to ptr
  %load = load i32, ptr %i2p
  ret i32 %load
}

define i32 @addrspacecast_ptrtoint_inttptr_nontrivial(ptr addrspace(3) %arg) {
; CHECK-LABEL: @addrspacecast_ptrtoint_inttptr_nontrivial(
; CHECK-NEXT:  bb:
; CHECK-NEXT:    [[LOAD:%.*]] = load i32, ptr addrspace(3) [[ARG:%.*]], align 4
; CHECK-NEXT:    ret i32 [[LOAD]]
;
bb:
  %asc = addrspacecast ptr addrspace(3) %arg to ptr
  %p2i = ptrtoint ptr %asc to i64
  %i2p = inttoptr i64 %p2i to ptr
  %load = load i32, ptr %i2p
  ret i32 %load
}

declare void @llvm.assume(i1 noundef) #0
declare i1 @llvm.amdgcn.is.shared(ptr nocapture) #1
declare i1 @llvm.amdgcn.is.private(ptr nocapture) #1

attributes #0 = { inaccessiblememonly nofree nosync nounwind willreturn }
attributes #1 = { nounwind readnone speculatable willreturn }
