; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=instsimplify -S | FileCheck %s

;; x * 0 ==> 0 when no-nans and no-signed-zero
define float @mul_zero_1(float %a) #0 {
; CHECK-LABEL: @mul_zero_1(
; CHECK-NEXT:    ret float 0.000000e+00
;
  %b = call nsz nnan float @llvm.experimental.constrained.fmul.f32(float %a, float 0.0, metadata !"round.tonearest", metadata !"fpexcept.ignore")
  ret float %b
}

define float @mul_zero_2(float %a) #0 {
; CHECK-LABEL: @mul_zero_2(
; CHECK-NEXT:    ret float 0.000000e+00
;
  %b = call fast float @llvm.experimental.constrained.fmul.f32(float 0.0, float %a, metadata !"round.tonearest", metadata !"fpexcept.ignore")
  ret float %b
}

define <2 x float> @mul_zero_nsz_nnan_vec_poison(<2 x float> %a) #0 {
; CHECK-LABEL: @mul_zero_nsz_nnan_vec_poison(
; CHECK-NEXT:    ret <2 x float> zeroinitializer
;
  %b = call nsz nnan <2 x float> @llvm.experimental.constrained.fmul.v2f32(<2 x float> %a, <2 x float><float 0.0, float poison>, metadata !"round.tonearest", metadata !"fpexcept.ignore")
  ret <2 x float> %b
}

;; x * 0 =/=> 0 when there could be nans or -0
define float @no_mul_zero_1(float %a) #0 {
; CHECK-LABEL: @no_mul_zero_1(
; CHECK-NEXT:    [[B:%.*]] = call nsz float @llvm.experimental.constrained.fmul.f32(float [[A:%.*]], float 0.000000e+00, metadata !"round.tonearest", metadata !"fpexcept.ignore")
; CHECK-NEXT:    ret float [[B]]
;
  %b = call nsz float @llvm.experimental.constrained.fmul.f32(float %a, float 0.0, metadata !"round.tonearest", metadata !"fpexcept.ignore")
  ret float %b
}

define float @no_mul_zero_2(float %a) #0 {
; CHECK-LABEL: @no_mul_zero_2(
; CHECK-NEXT:    [[B:%.*]] = call nnan float @llvm.experimental.constrained.fmul.f32(float [[A:%.*]], float 0.000000e+00, metadata !"round.tonearest", metadata !"fpexcept.ignore")
; CHECK-NEXT:    ret float [[B]]
;
  %b = call nnan float @llvm.experimental.constrained.fmul.f32(float %a, float 0.0, metadata !"round.tonearest", metadata !"fpexcept.ignore")
  ret float %b
}

define float @no_mul_zero_3(float %a) #0 {
; CHECK-LABEL: @no_mul_zero_3(
; CHECK-NEXT:    [[B:%.*]] = call float @llvm.experimental.constrained.fmul.f32(float [[A:%.*]], float 0.000000e+00, metadata !"round.tonearest", metadata !"fpexcept.ignore")
; CHECK-NEXT:    ret float [[B]]
;
  %b = call float @llvm.experimental.constrained.fmul.f32(float %a, float 0.0, metadata !"round.tonearest", metadata !"fpexcept.ignore")
  ret float %b
}

; -X + X --> 0.0 (with nnan on the fadd)

define float @fadd_binary_fnegx(float %x) #0 {
; CHECK-LABEL: @fadd_binary_fnegx(
; CHECK-NEXT:    [[NEGX:%.*]] = call float @llvm.experimental.constrained.fsub.f32(float -0.000000e+00, float [[X:%.*]], metadata !"round.tonearest", metadata !"fpexcept.ignore")
; CHECK-NEXT:    [[R:%.*]] = call nnan float @llvm.experimental.constrained.fadd.f32(float [[NEGX]], float [[X]], metadata !"round.tonearest", metadata !"fpexcept.ignore")
; CHECK-NEXT:    ret float [[R]]
;
  %negx = call float @llvm.experimental.constrained.fsub.f32(float -0.0, float %x, metadata !"round.tonearest", metadata !"fpexcept.ignore")
  %r = call nnan float @llvm.experimental.constrained.fadd.f32(float %negx, float %x, metadata !"round.tonearest", metadata !"fpexcept.ignore")
  ret float %r
}

define float @fadd_unary_fnegx(float %x) #0 {
; CHECK-LABEL: @fadd_unary_fnegx(
; CHECK-NEXT:    ret float 0.000000e+00
;
  %negx = fneg float %x
  %r = call nnan float @llvm.experimental.constrained.fadd.f32(float %negx, float %x, metadata !"round.tonearest", metadata !"fpexcept.ignore")
  ret float %r
}

; X + -X --> 0.0 (with nnan on the fadd)

define <2 x float> @fadd_binary_fnegx_commute_vec(<2 x float> %x) #0 {
; CHECK-LABEL: @fadd_binary_fnegx_commute_vec(
; CHECK-NEXT:    [[NEGX:%.*]] = call <2 x float> @llvm.experimental.constrained.fsub.v2f32(<2 x float> splat (float -0.000000e+00), <2 x float> [[X:%.*]], metadata !"round.tonearest", metadata !"fpexcept.ignore")
; CHECK-NEXT:    [[R:%.*]] = call nnan <2 x float> @llvm.experimental.constrained.fadd.v2f32(<2 x float> [[X]], <2 x float> [[NEGX]], metadata !"round.tonearest", metadata !"fpexcept.ignore")
; CHECK-NEXT:    ret <2 x float> [[R]]
;
  %negx = call <2 x float> @llvm.experimental.constrained.fsub.v2f32(<2 x float> <float -0.0, float -0.0>, <2 x float> %x, metadata !"round.tonearest", metadata !"fpexcept.ignore")
  %r = call nnan <2 x float> @llvm.experimental.constrained.fadd.v2f32(<2 x float> %x, <2 x float> %negx, metadata !"round.tonearest", metadata !"fpexcept.ignore")
  ret <2 x float> %r
}

define <2 x float> @fadd_unary_fnegx_commute_vec(<2 x float> %x) #0 {
; CHECK-LABEL: @fadd_unary_fnegx_commute_vec(
; CHECK-NEXT:    ret <2 x float> zeroinitializer
;
  %negx = fneg <2 x float> %x
  %r = call nnan <2 x float> @llvm.experimental.constrained.fadd.v2f32(<2 x float> %x, <2 x float> %negx, metadata !"round.tonearest", metadata !"fpexcept.ignore")
  ret <2 x float> %r
}

define <2 x float> @fadd_fnegx_commute_vec_poison(<2 x float> %x) #0 {
; CHECK-LABEL: @fadd_fnegx_commute_vec_poison(
; CHECK-NEXT:    [[NEGX:%.*]] = call <2 x float> @llvm.experimental.constrained.fsub.v2f32(<2 x float> <float poison, float -0.000000e+00>, <2 x float> [[X:%.*]], metadata !"round.tonearest", metadata !"fpexcept.ignore")
; CHECK-NEXT:    [[R:%.*]] = call nnan <2 x float> @llvm.experimental.constrained.fadd.v2f32(<2 x float> [[X]], <2 x float> [[NEGX]], metadata !"round.tonearest", metadata !"fpexcept.ignore")
; CHECK-NEXT:    ret <2 x float> [[R]]
;
  %negx = call <2 x float> @llvm.experimental.constrained.fsub.v2f32(<2 x float> <float poison, float -0.0>, <2 x float> %x, metadata !"round.tonearest", metadata !"fpexcept.ignore")
  %r = call nnan <2 x float> @llvm.experimental.constrained.fadd.v2f32(<2 x float> %x, <2 x float> %negx, metadata !"round.tonearest", metadata !"fpexcept.ignore")
  ret <2 x float> %r
}

; https://bugs.llvm.org/show_bug.cgi?id=26958
; https://bugs.llvm.org/show_bug.cgi?id=27151

define float @fadd_binary_fneg_nan(float %x) #0 {
; CHECK-LABEL: @fadd_binary_fneg_nan(
; CHECK-NEXT:    [[T:%.*]] = call nnan float @llvm.experimental.constrained.fsub.f32(float -0.000000e+00, float [[X:%.*]], metadata !"round.tonearest", metadata !"fpexcept.ignore")
; CHECK-NEXT:    [[COULD_BE_NAN:%.*]] = call ninf float @llvm.experimental.constrained.fadd.f32(float [[T]], float [[X]], metadata !"round.tonearest", metadata !"fpexcept.ignore")
; CHECK-NEXT:    ret float [[COULD_BE_NAN]]
;
  %t = call nnan float @llvm.experimental.constrained.fsub.f32(float -0.0, float %x, metadata !"round.tonearest", metadata !"fpexcept.ignore")
  %could_be_nan = call ninf float @llvm.experimental.constrained.fadd.f32(float %t, float %x, metadata !"round.tonearest", metadata !"fpexcept.ignore")
  ret float %could_be_nan
}

define float @fadd_unary_fneg_nan(float %x) #0 {
; CHECK-LABEL: @fadd_unary_fneg_nan(
; CHECK-NEXT:    [[T:%.*]] = fneg nnan float [[X:%.*]]
; CHECK-NEXT:    [[COULD_BE_NAN:%.*]] = call ninf float @llvm.experimental.constrained.fadd.f32(float [[T]], float [[X]], metadata !"round.tonearest", metadata !"fpexcept.ignore")
; CHECK-NEXT:    ret float [[COULD_BE_NAN]]
;
  %t = fneg nnan float %x
  %could_be_nan = call ninf float @llvm.experimental.constrained.fadd.f32(float %t, float %x, metadata !"round.tonearest", metadata !"fpexcept.ignore")
  ret float %could_be_nan
}

define float @fadd_binary_fneg_nan_commute(float %x) #0 {
; CHECK-LABEL: @fadd_binary_fneg_nan_commute(
; CHECK-NEXT:    [[T:%.*]] = call nnan ninf float @llvm.experimental.constrained.fsub.f32(float -0.000000e+00, float [[X:%.*]], metadata !"round.tonearest", metadata !"fpexcept.ignore")
; CHECK-NEXT:    [[COULD_BE_NAN:%.*]] = call float @llvm.experimental.constrained.fadd.f32(float [[X]], float [[T]], metadata !"round.tonearest", metadata !"fpexcept.ignore")
; CHECK-NEXT:    ret float [[COULD_BE_NAN]]
;
  %t = call nnan ninf float @llvm.experimental.constrained.fsub.f32(float -0.0, float %x, metadata !"round.tonearest", metadata !"fpexcept.ignore")
  %could_be_nan = call float @llvm.experimental.constrained.fadd.f32(float %x, float %t, metadata !"round.tonearest", metadata !"fpexcept.ignore")
  ret float %could_be_nan
}

define float @fadd_unary_fneg_nan_commute(float %x) #0 {
; CHECK-LABEL: @fadd_unary_fneg_nan_commute(
; CHECK-NEXT:    [[T:%.*]] = fneg nnan ninf float [[X:%.*]]
; CHECK-NEXT:    [[COULD_BE_NAN:%.*]] = call float @llvm.experimental.constrained.fadd.f32(float [[X]], float [[T]], metadata !"round.tonearest", metadata !"fpexcept.ignore")
; CHECK-NEXT:    ret float [[COULD_BE_NAN]]
;
  %t = fneg nnan ninf float %x
  %could_be_nan = call float @llvm.experimental.constrained.fadd.f32(float %x, float %t, metadata !"round.tonearest", metadata !"fpexcept.ignore")
  ret float %could_be_nan
}

; X + (0.0 - X) --> 0.0 (with nnan on the fadd)

define float @fadd_fsub_nnan_ninf(float %x) #0 {
; CHECK-LABEL: @fadd_fsub_nnan_ninf(
; CHECK-NEXT:    [[SUB:%.*]] = call nnan ninf float @llvm.experimental.constrained.fsub.f32(float 0.000000e+00, float [[X:%.*]], metadata !"round.tonearest", metadata !"fpexcept.ignore")
; CHECK-NEXT:    [[ZERO:%.*]] = call nnan ninf float @llvm.experimental.constrained.fadd.f32(float [[X]], float [[SUB]], metadata !"round.tonearest", metadata !"fpexcept.ignore")
; CHECK-NEXT:    ret float [[ZERO]]
;
  %sub = call nnan ninf float @llvm.experimental.constrained.fsub.f32(float 0.0, float %x, metadata !"round.tonearest", metadata !"fpexcept.ignore")
  %zero = call nnan ninf float @llvm.experimental.constrained.fadd.f32(float %x, float %sub, metadata !"round.tonearest", metadata !"fpexcept.ignore")
  ret float %zero
}

; (0.0 - X) + X --> 0.0 (with nnan on the fadd)

define <2 x float> @fadd_fsub_nnan_ninf_commute_vec(<2 x float> %x) #0 {
; CHECK-LABEL: @fadd_fsub_nnan_ninf_commute_vec(
; CHECK-NEXT:    [[SUB:%.*]] = call <2 x float> @llvm.experimental.constrained.fsub.v2f32(<2 x float> zeroinitializer, <2 x float> [[X:%.*]], metadata !"round.tonearest", metadata !"fpexcept.ignore")
; CHECK-NEXT:    [[ZERO:%.*]] = call nnan ninf <2 x float> @llvm.experimental.constrained.fadd.v2f32(<2 x float> [[SUB]], <2 x float> [[X]], metadata !"round.tonearest", metadata !"fpexcept.ignore")
; CHECK-NEXT:    ret <2 x float> [[ZERO]]
;
  %sub = call <2 x float> @llvm.experimental.constrained.fsub.v2f32(<2 x float> zeroinitializer, <2 x float> %x, metadata !"round.tonearest", metadata !"fpexcept.ignore")
  %zero = call nnan ninf <2 x float> @llvm.experimental.constrained.fadd.v2f32(<2 x float> %sub, <2 x float> %x, metadata !"round.tonearest", metadata !"fpexcept.ignore")
  ret <2 x float> %zero
}

; 'ninf' is not required because 'nnan' allows us to assume
; that X is not INF or -INF (adding opposite INFs would be NaN).

define float @fadd_fsub_nnan(float %x) #0 {
; CHECK-LABEL: @fadd_fsub_nnan(
; CHECK-NEXT:    [[SUB:%.*]] = call float @llvm.experimental.constrained.fsub.f32(float 0.000000e+00, float [[X:%.*]], metadata !"round.tonearest", metadata !"fpexcept.ignore")
; CHECK-NEXT:    [[ZERO:%.*]] = call nnan float @llvm.experimental.constrained.fadd.f32(float [[SUB]], float [[X]], metadata !"round.tonearest", metadata !"fpexcept.ignore")
; CHECK-NEXT:    ret float [[ZERO]]
;
  %sub = call float @llvm.experimental.constrained.fsub.f32(float 0.0, float %x, metadata !"round.tonearest", metadata !"fpexcept.ignore")
  %zero = call nnan float @llvm.experimental.constrained.fadd.f32(float %sub, float %x, metadata !"round.tonearest", metadata !"fpexcept.ignore")
  ret float %zero
}

; fsub nnan x, x ==> 0.0
define float @fsub_x_x(float %a) #0 {
; X - X ==> 0
; CHECK-LABEL: @fsub_x_x(
; CHECK-NEXT:    [[NO_ZERO1:%.*]] = call ninf float @llvm.experimental.constrained.fsub.f32(float [[A:%.*]], float [[A]], metadata !"round.tonearest", metadata !"fpexcept.ignore")
; CHECK-NEXT:    [[NO_ZERO2:%.*]] = call float @llvm.experimental.constrained.fsub.f32(float [[A]], float [[A]], metadata !"round.tonearest", metadata !"fpexcept.ignore")
; CHECK-NEXT:    [[NO_ZERO:%.*]] = call float @llvm.experimental.constrained.fadd.f32(float [[NO_ZERO1]], float [[NO_ZERO2]], metadata !"round.tonearest", metadata !"fpexcept.ignore")
; CHECK-NEXT:    ret float [[NO_ZERO]]
;
  %zero1 = call nnan float @llvm.experimental.constrained.fsub.f32(float %a, float %a, metadata !"round.tonearest", metadata !"fpexcept.ignore")

; Dont fold
  %no_zero1 = call ninf float @llvm.experimental.constrained.fsub.f32(float %a, float %a, metadata !"round.tonearest", metadata !"fpexcept.ignore")
  %no_zero2 = call float @llvm.experimental.constrained.fsub.f32(float %a, float %a, metadata !"round.tonearest", metadata !"fpexcept.ignore")
  %no_zero = call float @llvm.experimental.constrained.fadd.f32(float %no_zero1, float %no_zero2, metadata !"round.tonearest", metadata !"fpexcept.ignore")

; Should get folded
  %ret = call nsz float @llvm.experimental.constrained.fadd.f32(float %no_zero, float %zero1, metadata !"round.tonearest", metadata !"fpexcept.ignore")

  ret float %ret
}

; fsub nsz 0.0, (fsub 0.0, X) ==> X
define float @fsub_0_0_x(float %a) #0 {
; CHECK-LABEL: @fsub_0_0_x(
; CHECK-NEXT:    [[T1:%.*]] = call float @llvm.experimental.constrained.fsub.f32(float 0.000000e+00, float [[A:%.*]], metadata !"round.tonearest", metadata !"fpexcept.ignore")
; CHECK-NEXT:    [[RET:%.*]] = call nsz float @llvm.experimental.constrained.fsub.f32(float 0.000000e+00, float [[T1]], metadata !"round.tonearest", metadata !"fpexcept.ignore")
; CHECK-NEXT:    ret float [[RET]]
;
  %t1 = call float @llvm.experimental.constrained.fsub.f32(float 0.0, float %a, metadata !"round.tonearest", metadata !"fpexcept.ignore")
  %ret = call nsz float @llvm.experimental.constrained.fsub.f32(float 0.0, float %t1, metadata !"round.tonearest", metadata !"fpexcept.ignore")
  ret float %ret
}

; fsub nsz 0.0, (fneg X) ==> X
define float @fneg_x(float %a) #0 {
; CHECK-LABEL: @fneg_x(
; CHECK-NEXT:    ret float [[A:%.*]]
;
  %t1 = fneg float %a
  %ret = call nsz float @llvm.experimental.constrained.fsub.f32(float 0.0, float %t1, metadata !"round.tonearest", metadata !"fpexcept.ignore")
  ret float %ret
}

define <2 x float> @fsub_0_0_x_vec_poison1(<2 x float> %a) #0 {
; CHECK-LABEL: @fsub_0_0_x_vec_poison1(
; CHECK-NEXT:    [[T1:%.*]] = call <2 x float> @llvm.experimental.constrained.fsub.v2f32(<2 x float> <float 0.000000e+00, float poison>, <2 x float> [[A:%.*]], metadata !"round.tonearest", metadata !"fpexcept.ignore")
; CHECK-NEXT:    [[RET:%.*]] = call nsz <2 x float> @llvm.experimental.constrained.fsub.v2f32(<2 x float> zeroinitializer, <2 x float> [[T1]], metadata !"round.tonearest", metadata !"fpexcept.ignore")
; CHECK-NEXT:    ret <2 x float> [[RET]]
;
  %t1 = call <2 x float> @llvm.experimental.constrained.fsub.v2f32(<2 x float> <float 0.0, float poison>, <2 x float> %a, metadata !"round.tonearest", metadata !"fpexcept.ignore")
  %ret = call nsz <2 x float> @llvm.experimental.constrained.fsub.v2f32(<2 x float> zeroinitializer, <2 x float> %t1, metadata !"round.tonearest", metadata !"fpexcept.ignore")
  ret <2 x float> %ret
}

define <2 x float> @fneg_x_vec_poison1(<2 x float> %a) #0 {
; CHECK-LABEL: @fneg_x_vec_poison1(
; CHECK-NEXT:    ret <2 x float> [[A:%.*]]
;
  %t1 = fneg <2 x float> %a
  %ret = call nsz <2 x float> @llvm.experimental.constrained.fsub.v2f32(<2 x float> <float 0.0, float poison>, <2 x float> %t1, metadata !"round.tonearest", metadata !"fpexcept.ignore")
  ret <2 x float> %ret
}

define <2 x float> @fsub_0_0_x_vec_poison2(<2 x float> %a) #0 {
; CHECK-LABEL: @fsub_0_0_x_vec_poison2(
; CHECK-NEXT:    [[T1:%.*]] = call <2 x float> @llvm.experimental.constrained.fsub.v2f32(<2 x float> zeroinitializer, <2 x float> [[A:%.*]], metadata !"round.tonearest", metadata !"fpexcept.ignore")
; CHECK-NEXT:    [[RET:%.*]] = call nsz <2 x float> @llvm.experimental.constrained.fsub.v2f32(<2 x float> <float poison, float -0.000000e+00>, <2 x float> [[T1]], metadata !"round.tonearest", metadata !"fpexcept.ignore")
; CHECK-NEXT:    ret <2 x float> [[RET]]
;
  %t1 = call <2 x float> @llvm.experimental.constrained.fsub.v2f32(<2 x float> zeroinitializer, <2 x float> %a, metadata !"round.tonearest", metadata !"fpexcept.ignore")
  %ret = call nsz <2 x float> @llvm.experimental.constrained.fsub.v2f32(<2 x float> <float poison, float -0.0>, <2 x float> %t1, metadata !"round.tonearest", metadata !"fpexcept.ignore")
  ret <2 x float> %ret
}

; fadd nsz X, 0 ==> X

define <2 x float> @fadd_zero_nsz_vec(<2 x float> %x) #0 {
; CHECK-LABEL: @fadd_zero_nsz_vec(
; CHECK-NEXT:    ret <2 x float> [[X:%.*]]
;
  %r = call nsz <2 x float> @llvm.experimental.constrained.fadd.v2f32(<2 x float> %x, <2 x float> zeroinitializer, metadata !"round.tonearest", metadata !"fpexcept.ignore")
  ret <2 x float> %r
}

define <2 x float> @fadd_zero_nsz_vec_poison(<2 x float> %x) #0 {
; CHECK-LABEL: @fadd_zero_nsz_vec_poison(
; CHECK-NEXT:    ret <2 x float> [[X:%.*]]
;
  %r = call nsz <2 x float> @llvm.experimental.constrained.fadd.v2f32(<2 x float> %x, <2 x float> <float 0.0, float poison>, metadata !"round.tonearest", metadata !"fpexcept.ignore")
  ret <2 x float> %r
}

define float @nofold_fadd_x_0(float %a) #0 {
; Dont fold
; CHECK-LABEL: @nofold_fadd_x_0(
; CHECK-NEXT:    [[NO_ZERO1:%.*]] = call ninf float @llvm.experimental.constrained.fadd.f32(float [[A:%.*]], float 0.000000e+00, metadata !"round.tonearest", metadata !"fpexcept.ignore")
; CHECK-NEXT:    [[NO_ZERO2:%.*]] = call nnan float @llvm.experimental.constrained.fadd.f32(float [[A]], float 0.000000e+00, metadata !"round.tonearest", metadata !"fpexcept.ignore")
; CHECK-NEXT:    [[NO_ZERO:%.*]] = call float @llvm.experimental.constrained.fadd.f32(float [[NO_ZERO1]], float [[NO_ZERO2]], metadata !"round.tonearest", metadata !"fpexcept.ignore")
; CHECK-NEXT:    ret float [[NO_ZERO]]
;
  %no_zero1 = call ninf float @llvm.experimental.constrained.fadd.f32(float %a, float 0.0, metadata !"round.tonearest", metadata !"fpexcept.ignore")
  %no_zero2 = call nnan float @llvm.experimental.constrained.fadd.f32(float %a, float 0.0, metadata !"round.tonearest", metadata !"fpexcept.ignore")
  %no_zero = call float @llvm.experimental.constrained.fadd.f32(float %no_zero1, float %no_zero2, metadata !"round.tonearest", metadata !"fpexcept.ignore")
  ret float %no_zero
}

define float @fold_fadd_nsz_x_0(float %a) #0 {
; CHECK-LABEL: @fold_fadd_nsz_x_0(
; CHECK-NEXT:    ret float [[A:%.*]]
;
  %add = call nsz float @llvm.experimental.constrained.fadd.f32(float %a, float 0.0, metadata !"round.tonearest", metadata !"fpexcept.ignore")
  ret float %add
}

; 'nsz' does not guarantee that -0.0 does not occur, so this does not simplify.

define float @fold_fadd_cannot_be_neg0_nsz_src_x_0(float %a, float %b) #0 {
; CHECK-LABEL: @fold_fadd_cannot_be_neg0_nsz_src_x_0(
; CHECK-NEXT:    [[NSZ:%.*]] = call nsz float @llvm.experimental.constrained.fmul.f32(float [[A:%.*]], float [[B:%.*]], metadata !"round.tonearest", metadata !"fpexcept.ignore")
; CHECK-NEXT:    [[ADD:%.*]] = call float @llvm.experimental.constrained.fadd.f32(float [[NSZ]], float 0.000000e+00, metadata !"round.tonearest", metadata !"fpexcept.ignore")
; CHECK-NEXT:    ret float [[ADD]]
;
  %nsz = call nsz float @llvm.experimental.constrained.fmul.f32(float %a, float %b, metadata !"round.tonearest", metadata !"fpexcept.ignore")
  %add = call float @llvm.experimental.constrained.fadd.f32(float %nsz, float 0.0, metadata !"round.tonearest", metadata !"fpexcept.ignore")
  ret float %add
}

define float @fold_fadd_cannot_be_neg0_fabs_src_x_0(float %a) #0 {
; CHECK-LABEL: @fold_fadd_cannot_be_neg0_fabs_src_x_0(
; CHECK-NEXT:    [[FABS:%.*]] = call float @llvm.fabs.f32(float [[A:%.*]]) #[[ATTR0:[0-9]+]]
; CHECK-NEXT:    ret float [[FABS]]
;
  %fabs = call float @llvm.fabs.f32(float %a) #0
  %add = call float @llvm.experimental.constrained.fadd.f32(float %fabs, float 0.0, metadata !"round.tonearest", metadata !"fpexcept.ignore")
  ret float %add
}

; 'nsz' does not guarantee that -0.0 does not occur, so this does not simplify.

define float @fold_fadd_cannot_be_neg0_sqrt_nsz_src_x_0(float %a, float %b) #0 {
; CHECK-LABEL: @fold_fadd_cannot_be_neg0_sqrt_nsz_src_x_0(
; CHECK-NEXT:    [[NSZ:%.*]] = call nsz float @llvm.experimental.constrained.fmul.f32(float [[A:%.*]], float [[B:%.*]], metadata !"round.tonearest", metadata !"fpexcept.ignore")
; CHECK-NEXT:    [[SQRT:%.*]] = call float @llvm.experimental.constrained.sqrt.f32(float [[NSZ]], metadata !"round.tonearest", metadata !"fpexcept.ignore")
; CHECK-NEXT:    [[ADD:%.*]] = call float @llvm.experimental.constrained.fadd.f32(float [[SQRT]], float 0.000000e+00, metadata !"round.tonearest", metadata !"fpexcept.ignore")
; CHECK-NEXT:    ret float [[ADD]]
;
  %nsz = call nsz float @llvm.experimental.constrained.fmul.f32(float %a, float %b, metadata !"round.tonearest", metadata !"fpexcept.ignore")
  %sqrt = call float @llvm.experimental.constrained.sqrt.f32(float %nsz, metadata !"round.tonearest", metadata !"fpexcept.ignore")
  %add = call float @llvm.experimental.constrained.fadd.f32(float %sqrt, float 0.0, metadata !"round.tonearest", metadata !"fpexcept.ignore")
  ret float %add
}

; 'nsz' does not guarantee that -0.0 does not occur, so this does not simplify.

define float @fold_fadd_cannot_be_neg0_canonicalize_nsz_src_x_0(float %a, float %b) #0 {
; CHECK-LABEL: @fold_fadd_cannot_be_neg0_canonicalize_nsz_src_x_0(
; CHECK-NEXT:    [[NSZ:%.*]] = call nsz float @llvm.experimental.constrained.fmul.f32(float [[A:%.*]], float [[B:%.*]], metadata !"round.tonearest", metadata !"fpexcept.ignore")
; CHECK-NEXT:    [[CANON:%.*]] = call float @llvm.canonicalize.f32(float [[NSZ]]) #[[ATTR0]]
; CHECK-NEXT:    [[ADD:%.*]] = call float @llvm.experimental.constrained.fadd.f32(float [[CANON]], float 0.000000e+00, metadata !"round.tonearest", metadata !"fpexcept.ignore")
; CHECK-NEXT:    ret float [[ADD]]
;
  %nsz = call nsz float @llvm.experimental.constrained.fmul.f32(float %a, float %b, metadata !"round.tonearest", metadata !"fpexcept.ignore")
  %canon = call float @llvm.canonicalize.f32(float %nsz) #0
  %add = call float @llvm.experimental.constrained.fadd.f32(float %canon, float 0.0, metadata !"round.tonearest", metadata !"fpexcept.ignore")
  ret float %add
}

; fdiv nsz nnan 0, X ==> 0
; 0 / X -> 0

define double @fdiv_zero_by_x(double %x) #0 {
; CHECK-LABEL: @fdiv_zero_by_x(
; CHECK-NEXT:    ret double 0.000000e+00
;
  %r = call nnan nsz double @llvm.experimental.constrained.fdiv.f64(double 0.0, double %x, metadata !"round.tonearest", metadata !"fpexcept.ignore")
  ret double %r
}

define <2 x double> @fdiv_zero_by_x_vec_poison(<2 x double> %x) #0 {
; CHECK-LABEL: @fdiv_zero_by_x_vec_poison(
; CHECK-NEXT:    ret <2 x double> zeroinitializer
;
  %r = call nnan nsz <2 x double> @llvm.experimental.constrained.fdiv.v2f64(<2 x double> <double 0.0, double poison>, <2 x double> %x, metadata !"round.tonearest", metadata !"fpexcept.ignore")
  ret <2 x double> %r
}

; 0 % X -> 0
; nsz is not necessary - frem result always has the sign of the dividend

define double @frem_zero_by_x(double %x) #0 {
; CHECK-LABEL: @frem_zero_by_x(
; CHECK-NEXT:    ret double 0.000000e+00
;
  %r = call nnan double @llvm.experimental.constrained.frem.f64(double 0.0, double %x, metadata !"round.tonearest", metadata !"fpexcept.ignore")
  ret double %r
}

define <2 x double> @frem_poszero_by_x_vec_poison(<2 x double> %x) #0 {
; CHECK-LABEL: @frem_poszero_by_x_vec_poison(
; CHECK-NEXT:    ret <2 x double> zeroinitializer
;
  %r = call nnan <2 x double> @llvm.experimental.constrained.frem.v2f64(<2 x double> <double 0.0, double poison>, <2 x double> %x, metadata !"round.tonearest", metadata !"fpexcept.ignore")
  ret <2 x double> %r
}

; -0 % X -> -0
; nsz is not necessary - frem result always has the sign of the dividend

define double @frem_negzero_by_x(double %x) #0 {
; CHECK-LABEL: @frem_negzero_by_x(
; CHECK-NEXT:    ret double -0.000000e+00
;
  %r = call nnan double @llvm.experimental.constrained.frem.f64(double -0.0, double %x, metadata !"round.tonearest", metadata !"fpexcept.ignore")
  ret double %r
}

define <2 x double> @frem_negzero_by_x_vec_poison(<2 x double> %x) #0 {
; CHECK-LABEL: @frem_negzero_by_x_vec_poison(
; CHECK-NEXT:    ret <2 x double> splat (double -0.000000e+00)
;
  %r = call nnan <2 x double> @llvm.experimental.constrained.frem.v2f64(<2 x double> <double poison, double -0.0>, <2 x double> %x, metadata !"round.tonearest", metadata !"fpexcept.ignore")
  ret <2 x double> %r
}

define float @fdiv_self(float %f) #0 {
; CHECK-LABEL: @fdiv_self(
; CHECK-NEXT:    ret float 1.000000e+00
;
  %div = call nnan float @llvm.experimental.constrained.fdiv.f32(float %f, float %f, metadata !"round.tonearest", metadata !"fpexcept.ignore")
  ret float %div
}

define float @fdiv_self_invalid(float %f) #0 {
; CHECK-LABEL: @fdiv_self_invalid(
; CHECK-NEXT:    [[DIV:%.*]] = call float @llvm.experimental.constrained.fdiv.f32(float [[F:%.*]], float [[F]], metadata !"round.tonearest", metadata !"fpexcept.ignore")
; CHECK-NEXT:    ret float [[DIV]]
;
  %div = call float @llvm.experimental.constrained.fdiv.f32(float %f, float %f, metadata !"round.tonearest", metadata !"fpexcept.ignore")
  ret float %div
}

define float @fdiv_neg1(float %f) #0 {
; CHECK-LABEL: @fdiv_neg1(
; CHECK-NEXT:    [[NEG:%.*]] = call fast float @llvm.experimental.constrained.fsub.f32(float -0.000000e+00, float [[F:%.*]], metadata !"round.tonearest", metadata !"fpexcept.ignore")
; CHECK-NEXT:    [[DIV:%.*]] = call nnan float @llvm.experimental.constrained.fdiv.f32(float [[NEG]], float [[F]], metadata !"round.tonearest", metadata !"fpexcept.ignore")
; CHECK-NEXT:    ret float [[DIV]]
;
  %neg = call fast float @llvm.experimental.constrained.fsub.f32(float -0.000000e+00, float %f, metadata !"round.tonearest", metadata !"fpexcept.ignore")
  %div = call nnan float @llvm.experimental.constrained.fdiv.f32(float %neg, float %f, metadata !"round.tonearest", metadata !"fpexcept.ignore")
  ret float %div
}

define float @fdiv_neg2(float %f) #0 {
; CHECK-LABEL: @fdiv_neg2(
; CHECK-NEXT:    [[NEG:%.*]] = call fast float @llvm.experimental.constrained.fsub.f32(float 0.000000e+00, float [[F:%.*]], metadata !"round.tonearest", metadata !"fpexcept.ignore")
; CHECK-NEXT:    [[DIV:%.*]] = call nnan float @llvm.experimental.constrained.fdiv.f32(float [[NEG]], float [[F]], metadata !"round.tonearest", metadata !"fpexcept.ignore")
; CHECK-NEXT:    ret float [[DIV]]
;
  %neg = call fast float @llvm.experimental.constrained.fsub.f32(float 0.000000e+00, float %f, metadata !"round.tonearest", metadata !"fpexcept.ignore")
  %div = call nnan float @llvm.experimental.constrained.fdiv.f32(float %neg, float %f, metadata !"round.tonearest", metadata !"fpexcept.ignore")
  ret float %div
}

define float @fdiv_neg_invalid(float %f) #0 {
; CHECK-LABEL: @fdiv_neg_invalid(
; CHECK-NEXT:    [[NEG:%.*]] = call fast float @llvm.experimental.constrained.fsub.f32(float -0.000000e+00, float [[F:%.*]], metadata !"round.tonearest", metadata !"fpexcept.ignore")
; CHECK-NEXT:    [[DIV:%.*]] = call float @llvm.experimental.constrained.fdiv.f32(float [[NEG]], float [[F]], metadata !"round.tonearest", metadata !"fpexcept.ignore")
; CHECK-NEXT:    ret float [[DIV]]
;
  %neg = call fast float @llvm.experimental.constrained.fsub.f32(float -0.000000e+00, float %f, metadata !"round.tonearest", metadata !"fpexcept.ignore")
  %div = call float @llvm.experimental.constrained.fdiv.f32(float %neg, float %f, metadata !"round.tonearest", metadata !"fpexcept.ignore")
  ret float %div
}

define float @fdiv_neg_swapped1(float %f) #0 {
; CHECK-LABEL: @fdiv_neg_swapped1(
; CHECK-NEXT:    [[NEG:%.*]] = call fast float @llvm.experimental.constrained.fsub.f32(float -0.000000e+00, float [[F:%.*]], metadata !"round.tonearest", metadata !"fpexcept.ignore")
; CHECK-NEXT:    [[DIV:%.*]] = call nnan float @llvm.experimental.constrained.fdiv.f32(float [[F]], float [[NEG]], metadata !"round.tonearest", metadata !"fpexcept.ignore")
; CHECK-NEXT:    ret float [[DIV]]
;
  %neg = call fast float @llvm.experimental.constrained.fsub.f32(float -0.000000e+00, float %f, metadata !"round.tonearest", metadata !"fpexcept.ignore")
  %div = call nnan float @llvm.experimental.constrained.fdiv.f32(float %f, float %neg, metadata !"round.tonearest", metadata !"fpexcept.ignore")
  ret float %div
}

define float @fdiv_neg_swapped2(float %f) #0 {
; CHECK-LABEL: @fdiv_neg_swapped2(
; CHECK-NEXT:    [[NEG:%.*]] = call float @llvm.experimental.constrained.fsub.f32(float 0.000000e+00, float [[F:%.*]], metadata !"round.tonearest", metadata !"fpexcept.ignore")
; CHECK-NEXT:    [[DIV:%.*]] = call nnan float @llvm.experimental.constrained.fdiv.f32(float [[F]], float [[NEG]], metadata !"round.tonearest", metadata !"fpexcept.ignore")
; CHECK-NEXT:    ret float [[DIV]]
;
  %neg = call float @llvm.experimental.constrained.fsub.f32(float 0.000000e+00, float %f, metadata !"round.tonearest", metadata !"fpexcept.ignore")
  %div = call nnan float @llvm.experimental.constrained.fdiv.f32(float %f, float %neg, metadata !"round.tonearest", metadata !"fpexcept.ignore")
  ret float %div
}

define <2 x float> @fdiv_neg_vec_poison_elt(<2 x float> %f) #0 {
; CHECK-LABEL: @fdiv_neg_vec_poison_elt(
; CHECK-NEXT:    [[NEG:%.*]] = call <2 x float> @llvm.experimental.constrained.fsub.v2f32(<2 x float> <float 0.000000e+00, float poison>, <2 x float> [[F:%.*]], metadata !"round.tonearest", metadata !"fpexcept.ignore")
; CHECK-NEXT:    [[DIV:%.*]] = call nnan <2 x float> @llvm.experimental.constrained.fdiv.v2f32(<2 x float> [[F]], <2 x float> [[NEG]], metadata !"round.tonearest", metadata !"fpexcept.ignore")
; CHECK-NEXT:    ret <2 x float> [[DIV]]
;
  %neg = call <2 x float> @llvm.experimental.constrained.fsub.v2f32(<2 x float> <float 0.000000e+00, float poison>, <2 x float> %f, metadata !"round.tonearest", metadata !"fpexcept.ignore")
  %div = call nnan <2 x float> @llvm.experimental.constrained.fdiv.v2f32(<2 x float> %f, <2 x float> %neg, metadata !"round.tonearest", metadata !"fpexcept.ignore")
  ret <2 x float> %div
}

; PR21126: http://llvm.org/bugs/show_bug.cgi?id=21126
; With loose math, sqrt(X) * sqrt(X) is just X.

declare double @llvm.sqrt.f64(double)

define double @sqrt_squared(double %f) #0 {
; CHECK-LABEL: @sqrt_squared(
; CHECK-NEXT:    [[SQRT:%.*]] = call double @llvm.experimental.constrained.sqrt.f64(double [[F:%.*]], metadata !"round.tonearest", metadata !"fpexcept.ignore")
; CHECK-NEXT:    [[MUL:%.*]] = call reassoc nnan nsz double @llvm.experimental.constrained.fmul.f64(double [[SQRT]], double [[SQRT]], metadata !"round.tonearest", metadata !"fpexcept.ignore")
; CHECK-NEXT:    ret double [[MUL]]
;
  %sqrt = call double @llvm.experimental.constrained.sqrt.f64(double %f, metadata !"round.tonearest", metadata !"fpexcept.ignore")
  %mul = call reassoc nnan nsz double @llvm.experimental.constrained.fmul.f64(double %sqrt, double %sqrt, metadata !"round.tonearest", metadata !"fpexcept.ignore")
  ret double %mul
}

; Negative tests for the above transform: we need all 3 of those flags.

define double @sqrt_squared_not_fast_enough1(double %f) #0 {
; CHECK-LABEL: @sqrt_squared_not_fast_enough1(
; CHECK-NEXT:    [[SQRT:%.*]] = call double @llvm.experimental.constrained.sqrt.f64(double [[F:%.*]], metadata !"round.tonearest", metadata !"fpexcept.ignore")
; CHECK-NEXT:    [[MUL:%.*]] = call nnan nsz double @llvm.experimental.constrained.fmul.f64(double [[SQRT]], double [[SQRT]], metadata !"round.tonearest", metadata !"fpexcept.ignore")
; CHECK-NEXT:    ret double [[MUL]]
;
  %sqrt = call double @llvm.experimental.constrained.sqrt.f64(double %f, metadata !"round.tonearest", metadata !"fpexcept.ignore")
  %mul = call nnan nsz double @llvm.experimental.constrained.fmul.f64(double %sqrt, double %sqrt, metadata !"round.tonearest", metadata !"fpexcept.ignore")
  ret double %mul
}

define double @sqrt_squared_not_fast_enough2(double %f) #0 {
; CHECK-LABEL: @sqrt_squared_not_fast_enough2(
; CHECK-NEXT:    [[SQRT:%.*]] = call double @llvm.experimental.constrained.sqrt.f64(double [[F:%.*]], metadata !"round.tonearest", metadata !"fpexcept.ignore")
; CHECK-NEXT:    [[MUL:%.*]] = call reassoc nnan double @llvm.experimental.constrained.fmul.f64(double [[SQRT]], double [[SQRT]], metadata !"round.tonearest", metadata !"fpexcept.ignore")
; CHECK-NEXT:    ret double [[MUL]]
;
  %sqrt = call double @llvm.experimental.constrained.sqrt.f64(double %f, metadata !"round.tonearest", metadata !"fpexcept.ignore")
  %mul = call reassoc nnan double @llvm.experimental.constrained.fmul.f64(double %sqrt, double %sqrt, metadata !"round.tonearest", metadata !"fpexcept.ignore")
  ret double %mul
}

define double @sqrt_squared_not_fast_enough3(double %f) #0 {
; CHECK-LABEL: @sqrt_squared_not_fast_enough3(
; CHECK-NEXT:    [[SQRT:%.*]] = call double @llvm.experimental.constrained.sqrt.f64(double [[F:%.*]], metadata !"round.tonearest", metadata !"fpexcept.ignore")
; CHECK-NEXT:    [[MUL:%.*]] = call reassoc nsz double @llvm.experimental.constrained.fmul.f64(double [[SQRT]], double [[SQRT]], metadata !"round.tonearest", metadata !"fpexcept.ignore")
; CHECK-NEXT:    ret double [[MUL]]
;
  %sqrt = call double @llvm.experimental.constrained.sqrt.f64(double %f, metadata !"round.tonearest", metadata !"fpexcept.ignore")
  %mul = call reassoc nsz double @llvm.experimental.constrained.fmul.f64(double %sqrt, double %sqrt, metadata !"round.tonearest", metadata !"fpexcept.ignore")
  ret double %mul
}

declare float @llvm.fabs.f32(float)
declare float @llvm.experimental.constrained.sqrt.f32(float, metadata, metadata)
declare double @llvm.experimental.constrained.sqrt.f64(double, metadata, metadata)
declare float @llvm.canonicalize.f32(float)

declare float @llvm.experimental.constrained.fadd.f32(float, float, metadata, metadata)
declare <2 x float> @llvm.experimental.constrained.fadd.v2f32(<2 x float>, <2 x float>, metadata, metadata)

declare float @llvm.experimental.constrained.fsub.f32(float, float, metadata, metadata)
declare <2 x float> @llvm.experimental.constrained.fsub.v2f32(<2 x float>, <2 x float>, metadata, metadata)

declare float @llvm.experimental.constrained.fmul.f32(float, float, metadata, metadata)
declare double @llvm.experimental.constrained.fmul.f64(double, double, metadata, metadata)
declare <2 x float> @llvm.experimental.constrained.fmul.v2f32(<2 x float>, <2 x float>, metadata, metadata)

declare float @llvm.experimental.constrained.fdiv.f32(float, float, metadata, metadata)
declare double @llvm.experimental.constrained.fdiv.f64(double, double, metadata, metadata)
declare <2 x float> @llvm.experimental.constrained.fdiv.v2f32(<2 x float>, <2 x float>, metadata, metadata)
declare <2 x double> @llvm.experimental.constrained.fdiv.v2f64(<2 x double>, <2 x double>, metadata, metadata)

declare double @llvm.experimental.constrained.frem.f64(double, double, metadata, metadata)
declare <2 x double> @llvm.experimental.constrained.frem.v2f64(<2 x double>, <2 x double>, metadata, metadata)

attributes #0 = { strictfp }

