; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 4
; RUN: opt < %s -passes=msan -S | FileCheck %s
;
; Suboptimally handled by visitInstruction: llvm.aarch64.neon.
; - fcvtas, fcvtau
; - fcvtms, fcvtmu
; - fcvtns, fcvtnu
; - fcvtps, fcvtpu
; - fcvtzs, fcvtzu
;
; Forked from llvm/test/CodeGen/AArch64/arm64-cvt.ll

target datalayout = "e-m:e-i8:8:32-i16:16:32-i64:64-i128:128-n32:64-S128"
target triple = "aarch64--linux-android9001"

define i32 @fcvtas_1w1s(float %A) nounwind #0 {
; CHECK-LABEL: define i32 @fcvtas_1w1s(
; CHECK-SAME: float [[A:%.*]]) #[[ATTR0:[0-9]+]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load i32, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i32 [[TMP1]], 0
; CHECK-NEXT:    [[TMP4:%.*]] = sext i1 [[_MSCMP]] to i32
; CHECK-NEXT:    [[TMP3:%.*]] = call i32 @llvm.aarch64.neon.fcvtas.i32.f32(float [[A]])
; CHECK-NEXT:    store i32 [[TMP4]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret i32 [[TMP3]]
;
  %tmpvar3 = call i32 @llvm.aarch64.neon.fcvtas.i32.f32(float %A)
  ret i32 %tmpvar3
}

define i64 @fcvtas_1x1s(float %A) nounwind #0 {
; CHECK-LABEL: define i64 @fcvtas_1x1s(
; CHECK-SAME: float [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load i32, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i32 [[TMP1]], 0
; CHECK-NEXT:    [[TMP4:%.*]] = sext i1 [[_MSCMP]] to i64
; CHECK-NEXT:    [[TMP3:%.*]] = call i64 @llvm.aarch64.neon.fcvtas.i64.f32(float [[A]])
; CHECK-NEXT:    store i64 [[TMP4]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret i64 [[TMP3]]
;
  %tmpvar3 = call i64 @llvm.aarch64.neon.fcvtas.i64.f32(float %A)
  ret i64 %tmpvar3
}

define i32 @fcvtas_1w1d(double %A) nounwind #0 {
; CHECK-LABEL: define i32 @fcvtas_1w1d(
; CHECK-SAME: double [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load i64, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i64 [[TMP1]], 0
; CHECK-NEXT:    [[TMP4:%.*]] = sext i1 [[_MSCMP]] to i32
; CHECK-NEXT:    [[TMP3:%.*]] = call i32 @llvm.aarch64.neon.fcvtas.i32.f64(double [[A]])
; CHECK-NEXT:    store i32 [[TMP4]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret i32 [[TMP3]]
;
  %tmpvar3 = call i32 @llvm.aarch64.neon.fcvtas.i32.f64(double %A)
  ret i32 %tmpvar3
}

define i64 @fcvtas_1x1d(double %A) nounwind #0 {
; CHECK-LABEL: define i64 @fcvtas_1x1d(
; CHECK-SAME: double [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load i64, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i64 [[TMP1]], 0
; CHECK-NEXT:    [[TMP4:%.*]] = sext i1 [[_MSCMP]] to i64
; CHECK-NEXT:    [[TMP3:%.*]] = call i64 @llvm.aarch64.neon.fcvtas.i64.f64(double [[A]])
; CHECK-NEXT:    store i64 [[TMP4]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret i64 [[TMP3]]
;
  %tmpvar3 = call i64 @llvm.aarch64.neon.fcvtas.i64.f64(double %A)
  ret i64 %tmpvar3
}

declare i32 @llvm.aarch64.neon.fcvtas.i32.f32(float) nounwind readnone
declare i64 @llvm.aarch64.neon.fcvtas.i64.f32(float) nounwind readnone
declare i32 @llvm.aarch64.neon.fcvtas.i32.f64(double) nounwind readnone
declare i64 @llvm.aarch64.neon.fcvtas.i64.f64(double) nounwind readnone

define i32 @fcvtau_1w1s(float %A) nounwind #0 {
; CHECK-LABEL: define i32 @fcvtau_1w1s(
; CHECK-SAME: float [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load i32, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i32 [[TMP1]], 0
; CHECK-NEXT:    [[TMP4:%.*]] = sext i1 [[_MSCMP]] to i32
; CHECK-NEXT:    [[TMP3:%.*]] = call i32 @llvm.aarch64.neon.fcvtau.i32.f32(float [[A]])
; CHECK-NEXT:    store i32 [[TMP4]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret i32 [[TMP3]]
;
  %tmpvar3 = call i32 @llvm.aarch64.neon.fcvtau.i32.f32(float %A)
  ret i32 %tmpvar3
}

define i64 @fcvtau_1x1s(float %A) nounwind #0 {
; CHECK-LABEL: define i64 @fcvtau_1x1s(
; CHECK-SAME: float [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load i32, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i32 [[TMP1]], 0
; CHECK-NEXT:    [[TMP4:%.*]] = sext i1 [[_MSCMP]] to i64
; CHECK-NEXT:    [[TMP3:%.*]] = call i64 @llvm.aarch64.neon.fcvtau.i64.f32(float [[A]])
; CHECK-NEXT:    store i64 [[TMP4]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret i64 [[TMP3]]
;
  %tmpvar3 = call i64 @llvm.aarch64.neon.fcvtau.i64.f32(float %A)
  ret i64 %tmpvar3
}

define i32 @fcvtau_1w1d(double %A) nounwind #0 {
; CHECK-LABEL: define i32 @fcvtau_1w1d(
; CHECK-SAME: double [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load i64, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i64 [[TMP1]], 0
; CHECK-NEXT:    [[TMP4:%.*]] = sext i1 [[_MSCMP]] to i32
; CHECK-NEXT:    [[TMP3:%.*]] = call i32 @llvm.aarch64.neon.fcvtau.i32.f64(double [[A]])
; CHECK-NEXT:    store i32 [[TMP4]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret i32 [[TMP3]]
;
  %tmpvar3 = call i32 @llvm.aarch64.neon.fcvtau.i32.f64(double %A)
  ret i32 %tmpvar3
}

define i64 @fcvtau_1x1d(double %A) nounwind #0 {
; CHECK-LABEL: define i64 @fcvtau_1x1d(
; CHECK-SAME: double [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load i64, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i64 [[TMP1]], 0
; CHECK-NEXT:    [[TMP4:%.*]] = sext i1 [[_MSCMP]] to i64
; CHECK-NEXT:    [[TMP3:%.*]] = call i64 @llvm.aarch64.neon.fcvtau.i64.f64(double [[A]])
; CHECK-NEXT:    store i64 [[TMP4]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret i64 [[TMP3]]
;
  %tmpvar3 = call i64 @llvm.aarch64.neon.fcvtau.i64.f64(double %A)
  ret i64 %tmpvar3
}

declare i32 @llvm.aarch64.neon.fcvtau.i32.f32(float) nounwind readnone
declare i64 @llvm.aarch64.neon.fcvtau.i64.f32(float) nounwind readnone
declare i32 @llvm.aarch64.neon.fcvtau.i32.f64(double) nounwind readnone
declare i64 @llvm.aarch64.neon.fcvtau.i64.f64(double) nounwind readnone

define i32 @fcvtms_1w1s(float %A) nounwind #0 {
; CHECK-LABEL: define i32 @fcvtms_1w1s(
; CHECK-SAME: float [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load i32, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i32 [[TMP1]], 0
; CHECK-NEXT:    [[TMP4:%.*]] = sext i1 [[_MSCMP]] to i32
; CHECK-NEXT:    [[TMP3:%.*]] = call i32 @llvm.aarch64.neon.fcvtms.i32.f32(float [[A]])
; CHECK-NEXT:    store i32 [[TMP4]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret i32 [[TMP3]]
;
  %tmpvar3 = call i32 @llvm.aarch64.neon.fcvtms.i32.f32(float %A)
  ret i32 %tmpvar3
}

define i64 @fcvtms_1x1s(float %A) nounwind #0 {
; CHECK-LABEL: define i64 @fcvtms_1x1s(
; CHECK-SAME: float [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load i32, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i32 [[TMP1]], 0
; CHECK-NEXT:    [[TMP4:%.*]] = sext i1 [[_MSCMP]] to i64
; CHECK-NEXT:    [[TMP3:%.*]] = call i64 @llvm.aarch64.neon.fcvtms.i64.f32(float [[A]])
; CHECK-NEXT:    store i64 [[TMP4]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret i64 [[TMP3]]
;
  %tmpvar3 = call i64 @llvm.aarch64.neon.fcvtms.i64.f32(float %A)
  ret i64 %tmpvar3
}

define i32 @fcvtms_1w1d(double %A) nounwind #0 {
; CHECK-LABEL: define i32 @fcvtms_1w1d(
; CHECK-SAME: double [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load i64, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i64 [[TMP1]], 0
; CHECK-NEXT:    [[TMP4:%.*]] = sext i1 [[_MSCMP]] to i32
; CHECK-NEXT:    [[TMP3:%.*]] = call i32 @llvm.aarch64.neon.fcvtms.i32.f64(double [[A]])
; CHECK-NEXT:    store i32 [[TMP4]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret i32 [[TMP3]]
;
  %tmpvar3 = call i32 @llvm.aarch64.neon.fcvtms.i32.f64(double %A)
  ret i32 %tmpvar3
}

define i64 @fcvtms_1x1d(double %A) nounwind #0 {
; CHECK-LABEL: define i64 @fcvtms_1x1d(
; CHECK-SAME: double [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load i64, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i64 [[TMP1]], 0
; CHECK-NEXT:    [[TMP4:%.*]] = sext i1 [[_MSCMP]] to i64
; CHECK-NEXT:    [[TMP3:%.*]] = call i64 @llvm.aarch64.neon.fcvtms.i64.f64(double [[A]])
; CHECK-NEXT:    store i64 [[TMP4]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret i64 [[TMP3]]
;
  %tmpvar3 = call i64 @llvm.aarch64.neon.fcvtms.i64.f64(double %A)
  ret i64 %tmpvar3
}

declare i32 @llvm.aarch64.neon.fcvtms.i32.f32(float) nounwind readnone
declare i64 @llvm.aarch64.neon.fcvtms.i64.f32(float) nounwind readnone
declare i32 @llvm.aarch64.neon.fcvtms.i32.f64(double) nounwind readnone
declare i64 @llvm.aarch64.neon.fcvtms.i64.f64(double) nounwind readnone

define i32 @fcvtmu_1w1s(float %A) nounwind #0 {
; CHECK-LABEL: define i32 @fcvtmu_1w1s(
; CHECK-SAME: float [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load i32, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i32 [[TMP1]], 0
; CHECK-NEXT:    [[TMP4:%.*]] = sext i1 [[_MSCMP]] to i32
; CHECK-NEXT:    [[TMP3:%.*]] = call i32 @llvm.aarch64.neon.fcvtmu.i32.f32(float [[A]])
; CHECK-NEXT:    store i32 [[TMP4]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret i32 [[TMP3]]
;
  %tmpvar3 = call i32 @llvm.aarch64.neon.fcvtmu.i32.f32(float %A)
  ret i32 %tmpvar3
}

define i64 @fcvtmu_1x1s(float %A) nounwind #0 {
; CHECK-LABEL: define i64 @fcvtmu_1x1s(
; CHECK-SAME: float [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load i32, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i32 [[TMP1]], 0
; CHECK-NEXT:    [[TMP4:%.*]] = sext i1 [[_MSCMP]] to i64
; CHECK-NEXT:    [[TMP3:%.*]] = call i64 @llvm.aarch64.neon.fcvtmu.i64.f32(float [[A]])
; CHECK-NEXT:    store i64 [[TMP4]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret i64 [[TMP3]]
;
  %tmpvar3 = call i64 @llvm.aarch64.neon.fcvtmu.i64.f32(float %A)
  ret i64 %tmpvar3
}

define i32 @fcvtmu_1w1d(double %A) nounwind #0 {
; CHECK-LABEL: define i32 @fcvtmu_1w1d(
; CHECK-SAME: double [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load i64, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i64 [[TMP1]], 0
; CHECK-NEXT:    [[TMP4:%.*]] = sext i1 [[_MSCMP]] to i32
; CHECK-NEXT:    [[TMP3:%.*]] = call i32 @llvm.aarch64.neon.fcvtmu.i32.f64(double [[A]])
; CHECK-NEXT:    store i32 [[TMP4]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret i32 [[TMP3]]
;
  %tmpvar3 = call i32 @llvm.aarch64.neon.fcvtmu.i32.f64(double %A)
  ret i32 %tmpvar3
}

define i64 @fcvtmu_1x1d(double %A) nounwind #0 {
; CHECK-LABEL: define i64 @fcvtmu_1x1d(
; CHECK-SAME: double [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load i64, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i64 [[TMP1]], 0
; CHECK-NEXT:    [[TMP4:%.*]] = sext i1 [[_MSCMP]] to i64
; CHECK-NEXT:    [[TMP3:%.*]] = call i64 @llvm.aarch64.neon.fcvtmu.i64.f64(double [[A]])
; CHECK-NEXT:    store i64 [[TMP4]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret i64 [[TMP3]]
;
  %tmpvar3 = call i64 @llvm.aarch64.neon.fcvtmu.i64.f64(double %A)
  ret i64 %tmpvar3
}

declare i32 @llvm.aarch64.neon.fcvtmu.i32.f32(float) nounwind readnone
declare i64 @llvm.aarch64.neon.fcvtmu.i64.f32(float) nounwind readnone
declare i32 @llvm.aarch64.neon.fcvtmu.i32.f64(double) nounwind readnone
declare i64 @llvm.aarch64.neon.fcvtmu.i64.f64(double) nounwind readnone

define i32 @fcvtns_1w1s(float %A) nounwind #0 {
; CHECK-LABEL: define i32 @fcvtns_1w1s(
; CHECK-SAME: float [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load i32, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i32 [[TMP1]], 0
; CHECK-NEXT:    [[TMP4:%.*]] = sext i1 [[_MSCMP]] to i32
; CHECK-NEXT:    [[TMP3:%.*]] = call i32 @llvm.aarch64.neon.fcvtns.i32.f32(float [[A]])
; CHECK-NEXT:    store i32 [[TMP4]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret i32 [[TMP3]]
;
  %tmpvar3 = call i32 @llvm.aarch64.neon.fcvtns.i32.f32(float %A)
  ret i32 %tmpvar3
}

define i64 @fcvtns_1x1s(float %A) nounwind #0 {
; CHECK-LABEL: define i64 @fcvtns_1x1s(
; CHECK-SAME: float [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load i32, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i32 [[TMP1]], 0
; CHECK-NEXT:    [[TMP4:%.*]] = sext i1 [[_MSCMP]] to i64
; CHECK-NEXT:    [[TMP3:%.*]] = call i64 @llvm.aarch64.neon.fcvtns.i64.f32(float [[A]])
; CHECK-NEXT:    store i64 [[TMP4]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret i64 [[TMP3]]
;
  %tmpvar3 = call i64 @llvm.aarch64.neon.fcvtns.i64.f32(float %A)
  ret i64 %tmpvar3
}

define i32 @fcvtns_1w1d(double %A) nounwind #0 {
; CHECK-LABEL: define i32 @fcvtns_1w1d(
; CHECK-SAME: double [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load i64, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i64 [[TMP1]], 0
; CHECK-NEXT:    [[TMP4:%.*]] = sext i1 [[_MSCMP]] to i32
; CHECK-NEXT:    [[TMP3:%.*]] = call i32 @llvm.aarch64.neon.fcvtns.i32.f64(double [[A]])
; CHECK-NEXT:    store i32 [[TMP4]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret i32 [[TMP3]]
;
  %tmpvar3 = call i32 @llvm.aarch64.neon.fcvtns.i32.f64(double %A)
  ret i32 %tmpvar3
}

define i64 @fcvtns_1x1d(double %A) nounwind #0 {
; CHECK-LABEL: define i64 @fcvtns_1x1d(
; CHECK-SAME: double [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load i64, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i64 [[TMP1]], 0
; CHECK-NEXT:    [[TMP4:%.*]] = sext i1 [[_MSCMP]] to i64
; CHECK-NEXT:    [[TMP3:%.*]] = call i64 @llvm.aarch64.neon.fcvtns.i64.f64(double [[A]])
; CHECK-NEXT:    store i64 [[TMP4]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret i64 [[TMP3]]
;
  %tmpvar3 = call i64 @llvm.aarch64.neon.fcvtns.i64.f64(double %A)
  ret i64 %tmpvar3
}

declare i32 @llvm.aarch64.neon.fcvtns.i32.f32(float) nounwind readnone
declare i64 @llvm.aarch64.neon.fcvtns.i64.f32(float) nounwind readnone
declare i32 @llvm.aarch64.neon.fcvtns.i32.f64(double) nounwind readnone
declare i64 @llvm.aarch64.neon.fcvtns.i64.f64(double) nounwind readnone

define i32 @fcvtnu_1w1s(float %A) nounwind #0 {
; CHECK-LABEL: define i32 @fcvtnu_1w1s(
; CHECK-SAME: float [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load i32, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i32 [[TMP1]], 0
; CHECK-NEXT:    [[TMP4:%.*]] = sext i1 [[_MSCMP]] to i32
; CHECK-NEXT:    [[TMP3:%.*]] = call i32 @llvm.aarch64.neon.fcvtnu.i32.f32(float [[A]])
; CHECK-NEXT:    store i32 [[TMP4]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret i32 [[TMP3]]
;
  %tmpvar3 = call i32 @llvm.aarch64.neon.fcvtnu.i32.f32(float %A)
  ret i32 %tmpvar3
}

define i64 @fcvtnu_1x1s(float %A) nounwind #0 {
; CHECK-LABEL: define i64 @fcvtnu_1x1s(
; CHECK-SAME: float [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load i32, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i32 [[TMP1]], 0
; CHECK-NEXT:    [[TMP4:%.*]] = sext i1 [[_MSCMP]] to i64
; CHECK-NEXT:    [[TMP3:%.*]] = call i64 @llvm.aarch64.neon.fcvtnu.i64.f32(float [[A]])
; CHECK-NEXT:    store i64 [[TMP4]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret i64 [[TMP3]]
;
  %tmpvar3 = call i64 @llvm.aarch64.neon.fcvtnu.i64.f32(float %A)
  ret i64 %tmpvar3
}

define i32 @fcvtnu_1w1d(double %A) nounwind #0 {
; CHECK-LABEL: define i32 @fcvtnu_1w1d(
; CHECK-SAME: double [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load i64, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i64 [[TMP1]], 0
; CHECK-NEXT:    [[TMP4:%.*]] = sext i1 [[_MSCMP]] to i32
; CHECK-NEXT:    [[TMP3:%.*]] = call i32 @llvm.aarch64.neon.fcvtnu.i32.f64(double [[A]])
; CHECK-NEXT:    store i32 [[TMP4]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret i32 [[TMP3]]
;
  %tmpvar3 = call i32 @llvm.aarch64.neon.fcvtnu.i32.f64(double %A)
  ret i32 %tmpvar3
}

define i64 @fcvtnu_1x1d(double %A) nounwind #0 {
; CHECK-LABEL: define i64 @fcvtnu_1x1d(
; CHECK-SAME: double [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load i64, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i64 [[TMP1]], 0
; CHECK-NEXT:    [[TMP4:%.*]] = sext i1 [[_MSCMP]] to i64
; CHECK-NEXT:    [[TMP3:%.*]] = call i64 @llvm.aarch64.neon.fcvtnu.i64.f64(double [[A]])
; CHECK-NEXT:    store i64 [[TMP4]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret i64 [[TMP3]]
;
  %tmpvar3 = call i64 @llvm.aarch64.neon.fcvtnu.i64.f64(double %A)
  ret i64 %tmpvar3
}

declare i32 @llvm.aarch64.neon.fcvtnu.i32.f32(float) nounwind readnone
declare i64 @llvm.aarch64.neon.fcvtnu.i64.f32(float) nounwind readnone
declare i32 @llvm.aarch64.neon.fcvtnu.i32.f64(double) nounwind readnone
declare i64 @llvm.aarch64.neon.fcvtnu.i64.f64(double) nounwind readnone

define i32 @fcvtps_1w1s(float %A) nounwind #0 {
; CHECK-LABEL: define i32 @fcvtps_1w1s(
; CHECK-SAME: float [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load i32, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i32 [[TMP1]], 0
; CHECK-NEXT:    [[TMP4:%.*]] = sext i1 [[_MSCMP]] to i32
; CHECK-NEXT:    [[TMP3:%.*]] = call i32 @llvm.aarch64.neon.fcvtps.i32.f32(float [[A]])
; CHECK-NEXT:    store i32 [[TMP4]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret i32 [[TMP3]]
;
  %tmpvar3 = call i32 @llvm.aarch64.neon.fcvtps.i32.f32(float %A)
  ret i32 %tmpvar3
}

define i64 @fcvtps_1x1s(float %A) nounwind #0 {
; CHECK-LABEL: define i64 @fcvtps_1x1s(
; CHECK-SAME: float [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load i32, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i32 [[TMP1]], 0
; CHECK-NEXT:    [[TMP4:%.*]] = sext i1 [[_MSCMP]] to i64
; CHECK-NEXT:    [[TMP3:%.*]] = call i64 @llvm.aarch64.neon.fcvtps.i64.f32(float [[A]])
; CHECK-NEXT:    store i64 [[TMP4]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret i64 [[TMP3]]
;
  %tmpvar3 = call i64 @llvm.aarch64.neon.fcvtps.i64.f32(float %A)
  ret i64 %tmpvar3
}

define i32 @fcvtps_1w1d(double %A) nounwind #0 {
; CHECK-LABEL: define i32 @fcvtps_1w1d(
; CHECK-SAME: double [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load i64, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i64 [[TMP1]], 0
; CHECK-NEXT:    [[TMP4:%.*]] = sext i1 [[_MSCMP]] to i32
; CHECK-NEXT:    [[TMP3:%.*]] = call i32 @llvm.aarch64.neon.fcvtps.i32.f64(double [[A]])
; CHECK-NEXT:    store i32 [[TMP4]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret i32 [[TMP3]]
;
  %tmpvar3 = call i32 @llvm.aarch64.neon.fcvtps.i32.f64(double %A)
  ret i32 %tmpvar3
}

define i64 @fcvtps_1x1d(double %A) nounwind #0 {
; CHECK-LABEL: define i64 @fcvtps_1x1d(
; CHECK-SAME: double [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load i64, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i64 [[TMP1]], 0
; CHECK-NEXT:    [[TMP4:%.*]] = sext i1 [[_MSCMP]] to i64
; CHECK-NEXT:    [[TMP3:%.*]] = call i64 @llvm.aarch64.neon.fcvtps.i64.f64(double [[A]])
; CHECK-NEXT:    store i64 [[TMP4]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret i64 [[TMP3]]
;
  %tmpvar3 = call i64 @llvm.aarch64.neon.fcvtps.i64.f64(double %A)
  ret i64 %tmpvar3
}

declare i32 @llvm.aarch64.neon.fcvtps.i32.f32(float) nounwind readnone
declare i64 @llvm.aarch64.neon.fcvtps.i64.f32(float) nounwind readnone
declare i32 @llvm.aarch64.neon.fcvtps.i32.f64(double) nounwind readnone
declare i64 @llvm.aarch64.neon.fcvtps.i64.f64(double) nounwind readnone

define i32 @fcvtpu_1w1s(float %A) nounwind #0 {
; CHECK-LABEL: define i32 @fcvtpu_1w1s(
; CHECK-SAME: float [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load i32, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i32 [[TMP1]], 0
; CHECK-NEXT:    [[TMP4:%.*]] = sext i1 [[_MSCMP]] to i32
; CHECK-NEXT:    [[TMP3:%.*]] = call i32 @llvm.aarch64.neon.fcvtpu.i32.f32(float [[A]])
; CHECK-NEXT:    store i32 [[TMP4]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret i32 [[TMP3]]
;
  %tmpvar3 = call i32 @llvm.aarch64.neon.fcvtpu.i32.f32(float %A)
  ret i32 %tmpvar3
}

define i64 @fcvtpu_1x1s(float %A) nounwind #0 {
; CHECK-LABEL: define i64 @fcvtpu_1x1s(
; CHECK-SAME: float [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load i32, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i32 [[TMP1]], 0
; CHECK-NEXT:    [[TMP4:%.*]] = sext i1 [[_MSCMP]] to i64
; CHECK-NEXT:    [[TMP3:%.*]] = call i64 @llvm.aarch64.neon.fcvtpu.i64.f32(float [[A]])
; CHECK-NEXT:    store i64 [[TMP4]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret i64 [[TMP3]]
;
  %tmpvar3 = call i64 @llvm.aarch64.neon.fcvtpu.i64.f32(float %A)
  ret i64 %tmpvar3
}

define i32 @fcvtpu_1w1d(double %A) nounwind #0 {
; CHECK-LABEL: define i32 @fcvtpu_1w1d(
; CHECK-SAME: double [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load i64, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i64 [[TMP1]], 0
; CHECK-NEXT:    [[TMP4:%.*]] = sext i1 [[_MSCMP]] to i32
; CHECK-NEXT:    [[TMP3:%.*]] = call i32 @llvm.aarch64.neon.fcvtpu.i32.f64(double [[A]])
; CHECK-NEXT:    store i32 [[TMP4]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret i32 [[TMP3]]
;
  %tmpvar3 = call i32 @llvm.aarch64.neon.fcvtpu.i32.f64(double %A)
  ret i32 %tmpvar3
}

define i64 @fcvtpu_1x1d(double %A) nounwind #0 {
; CHECK-LABEL: define i64 @fcvtpu_1x1d(
; CHECK-SAME: double [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load i64, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i64 [[TMP1]], 0
; CHECK-NEXT:    [[TMP4:%.*]] = sext i1 [[_MSCMP]] to i64
; CHECK-NEXT:    [[TMP3:%.*]] = call i64 @llvm.aarch64.neon.fcvtpu.i64.f64(double [[A]])
; CHECK-NEXT:    store i64 [[TMP4]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret i64 [[TMP3]]
;
  %tmpvar3 = call i64 @llvm.aarch64.neon.fcvtpu.i64.f64(double %A)
  ret i64 %tmpvar3
}

declare i32 @llvm.aarch64.neon.fcvtpu.i32.f32(float) nounwind readnone
declare i64 @llvm.aarch64.neon.fcvtpu.i64.f32(float) nounwind readnone
declare i32 @llvm.aarch64.neon.fcvtpu.i32.f64(double) nounwind readnone
declare i64 @llvm.aarch64.neon.fcvtpu.i64.f64(double) nounwind readnone

define i32 @fcvtzs_1w1s(float %A) nounwind #0 {
; CHECK-LABEL: define i32 @fcvtzs_1w1s(
; CHECK-SAME: float [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load i32, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i32 [[TMP1]], 0
; CHECK-NEXT:    [[TMP4:%.*]] = sext i1 [[_MSCMP]] to i32
; CHECK-NEXT:    [[TMP3:%.*]] = call i32 @llvm.aarch64.neon.fcvtzs.i32.f32(float [[A]])
; CHECK-NEXT:    store i32 [[TMP4]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret i32 [[TMP3]]
;
  %tmpvar3 = call i32 @llvm.aarch64.neon.fcvtzs.i32.f32(float %A)
  ret i32 %tmpvar3
}

define i64 @fcvtzs_1x1s(float %A) nounwind #0 {
; CHECK-LABEL: define i64 @fcvtzs_1x1s(
; CHECK-SAME: float [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load i32, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i32 [[TMP1]], 0
; CHECK-NEXT:    [[TMP4:%.*]] = sext i1 [[_MSCMP]] to i64
; CHECK-NEXT:    [[TMP3:%.*]] = call i64 @llvm.aarch64.neon.fcvtzs.i64.f32(float [[A]])
; CHECK-NEXT:    store i64 [[TMP4]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret i64 [[TMP3]]
;
  %tmpvar3 = call i64 @llvm.aarch64.neon.fcvtzs.i64.f32(float %A)
  ret i64 %tmpvar3
}

define i32 @fcvtzs_1w1d(double %A) nounwind #0 {
; CHECK-LABEL: define i32 @fcvtzs_1w1d(
; CHECK-SAME: double [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load i64, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i64 [[TMP1]], 0
; CHECK-NEXT:    [[TMP4:%.*]] = sext i1 [[_MSCMP]] to i32
; CHECK-NEXT:    [[TMP3:%.*]] = call i32 @llvm.aarch64.neon.fcvtzs.i32.f64(double [[A]])
; CHECK-NEXT:    store i32 [[TMP4]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret i32 [[TMP3]]
;
  %tmpvar3 = call i32 @llvm.aarch64.neon.fcvtzs.i32.f64(double %A)
  ret i32 %tmpvar3
}

define i64 @fcvtzs_1x1d(double %A) nounwind #0 {
; CHECK-LABEL: define i64 @fcvtzs_1x1d(
; CHECK-SAME: double [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load i64, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i64 [[TMP1]], 0
; CHECK-NEXT:    [[TMP4:%.*]] = sext i1 [[_MSCMP]] to i64
; CHECK-NEXT:    [[TMP3:%.*]] = call i64 @llvm.aarch64.neon.fcvtzs.i64.f64(double [[A]])
; CHECK-NEXT:    store i64 [[TMP4]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret i64 [[TMP3]]
;
  %tmpvar3 = call i64 @llvm.aarch64.neon.fcvtzs.i64.f64(double %A)
  ret i64 %tmpvar3
}

declare i32 @llvm.aarch64.neon.fcvtzs.i32.f32(float) nounwind readnone
declare i64 @llvm.aarch64.neon.fcvtzs.i64.f32(float) nounwind readnone
declare i32 @llvm.aarch64.neon.fcvtzs.i32.f64(double) nounwind readnone
declare i64 @llvm.aarch64.neon.fcvtzs.i64.f64(double) nounwind readnone

define i32 @fcvtzu_1w1s(float %A) nounwind #0 {
; CHECK-LABEL: define i32 @fcvtzu_1w1s(
; CHECK-SAME: float [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load i32, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i32 [[TMP1]], 0
; CHECK-NEXT:    [[TMP4:%.*]] = sext i1 [[_MSCMP]] to i32
; CHECK-NEXT:    [[TMP3:%.*]] = call i32 @llvm.aarch64.neon.fcvtzu.i32.f32(float [[A]])
; CHECK-NEXT:    store i32 [[TMP4]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret i32 [[TMP3]]
;
  %tmpvar3 = call i32 @llvm.aarch64.neon.fcvtzu.i32.f32(float %A)
  ret i32 %tmpvar3
}

define i64 @fcvtzu_1x1s(float %A) nounwind #0 {
; CHECK-LABEL: define i64 @fcvtzu_1x1s(
; CHECK-SAME: float [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load i32, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i32 [[TMP1]], 0
; CHECK-NEXT:    [[TMP4:%.*]] = sext i1 [[_MSCMP]] to i64
; CHECK-NEXT:    [[TMP3:%.*]] = call i64 @llvm.aarch64.neon.fcvtzu.i64.f32(float [[A]])
; CHECK-NEXT:    store i64 [[TMP4]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret i64 [[TMP3]]
;
  %tmpvar3 = call i64 @llvm.aarch64.neon.fcvtzu.i64.f32(float %A)
  ret i64 %tmpvar3
}

define i32 @fcvtzu_1w1d(double %A) nounwind #0 {
; CHECK-LABEL: define i32 @fcvtzu_1w1d(
; CHECK-SAME: double [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load i64, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i64 [[TMP1]], 0
; CHECK-NEXT:    [[TMP4:%.*]] = sext i1 [[_MSCMP]] to i32
; CHECK-NEXT:    [[TMP3:%.*]] = call i32 @llvm.aarch64.neon.fcvtzu.i32.f64(double [[A]])
; CHECK-NEXT:    store i32 [[TMP4]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret i32 [[TMP3]]
;
  %tmpvar3 = call i32 @llvm.aarch64.neon.fcvtzu.i32.f64(double %A)
  ret i32 %tmpvar3
}

define i64 @fcvtzu_1x1d(double %A) nounwind #0 {
; CHECK-LABEL: define i64 @fcvtzu_1x1d(
; CHECK-SAME: double [[A:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load i64, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i64 [[TMP1]], 0
; CHECK-NEXT:    [[TMP4:%.*]] = sext i1 [[_MSCMP]] to i64
; CHECK-NEXT:    [[TMP3:%.*]] = call i64 @llvm.aarch64.neon.fcvtzu.i64.f64(double [[A]])
; CHECK-NEXT:    store i64 [[TMP4]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret i64 [[TMP3]]
;
  %tmpvar3 = call i64 @llvm.aarch64.neon.fcvtzu.i64.f64(double %A)
  ret i64 %tmpvar3
}

declare i32 @llvm.aarch64.neon.fcvtzu.i32.f32(float) nounwind readnone
declare i64 @llvm.aarch64.neon.fcvtzu.i64.f32(float) nounwind readnone
declare i32 @llvm.aarch64.neon.fcvtzu.i32.f64(double) nounwind readnone
declare i64 @llvm.aarch64.neon.fcvtzu.i64.f64(double) nounwind readnone

attributes #0 = { sanitize_memory }
