; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=i686-- | FileCheck %s --check-prefixes=X86,SDAG-X86
; RUN: llc < %s -mtriple=i686-- -fast-isel -fast-isel-abort=1 | FileCheck %s --check-prefixes=X86,FASTISEL-X86
; RUN: llc < %s -mtriple=i686-- -global-isel -global-isel-abort=1 | FileCheck %s --check-prefixes=X86,GISEL-X86
; RUN: llc < %s -mtriple=x86_64-- | FileCheck %s --check-prefixes=X64,SDAG-X64
; RUN: llc < %s -mtriple=x86_64-- -fast-isel -fast-isel-abort=1 | FileCheck %s --check-prefixes=X64,FASTISEL-X64
; RUN: llc < %s -mtriple=x86_64-- -global-isel -global-isel-abort=1 | FileCheck %s --check-prefixes=X64,GISEL-X64

define i1 @xor_i1(i1 %a, i1 %b) {
; SDAG-X86-LABEL: xor_i1:
; SDAG-X86:       # %bb.0:
; SDAG-X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; SDAG-X86-NEXT:    xorb {{[0-9]+}}(%esp), %al
; SDAG-X86-NEXT:    retl
;
; FASTISEL-X86-LABEL: xor_i1:
; FASTISEL-X86:       # %bb.0:
; FASTISEL-X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; FASTISEL-X86-NEXT:    xorb {{[0-9]+}}(%esp), %al
; FASTISEL-X86-NEXT:    retl
;
; GISEL-X86-LABEL: xor_i1:
; GISEL-X86:       # %bb.0:
; GISEL-X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; GISEL-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; GISEL-X86-NEXT:    xorb %cl, %al
; GISEL-X86-NEXT:    # kill: def $al killed $al killed $eax
; GISEL-X86-NEXT:    retl
;
; SDAG-X64-LABEL: xor_i1:
; SDAG-X64:       # %bb.0:
; SDAG-X64-NEXT:    movl %edi, %eax
; SDAG-X64-NEXT:    xorl %esi, %eax
; SDAG-X64-NEXT:    # kill: def $al killed $al killed $eax
; SDAG-X64-NEXT:    retq
;
; FASTISEL-X64-LABEL: xor_i1:
; FASTISEL-X64:       # %bb.0:
; FASTISEL-X64-NEXT:    movl %edi, %eax
; FASTISEL-X64-NEXT:    xorb %sil, %al
; FASTISEL-X64-NEXT:    # kill: def $al killed $al killed $eax
; FASTISEL-X64-NEXT:    retq
;
; GISEL-X64-LABEL: xor_i1:
; GISEL-X64:       # %bb.0:
; GISEL-X64-NEXT:    movl %esi, %eax
; GISEL-X64-NEXT:    xorb %dil, %al
; GISEL-X64-NEXT:    # kill: def $al killed $al killed $eax
; GISEL-X64-NEXT:    retq
  %c = xor i1 %a, %b
  ret i1 %c
}

define i8 @xor_i8(i8 %a, i8 %b) {
; SDAG-X86-LABEL: xor_i8:
; SDAG-X86:       # %bb.0:
; SDAG-X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; SDAG-X86-NEXT:    xorb {{[0-9]+}}(%esp), %al
; SDAG-X86-NEXT:    retl
;
; FASTISEL-X86-LABEL: xor_i8:
; FASTISEL-X86:       # %bb.0:
; FASTISEL-X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; FASTISEL-X86-NEXT:    xorb {{[0-9]+}}(%esp), %al
; FASTISEL-X86-NEXT:    retl
;
; GISEL-X86-LABEL: xor_i8:
; GISEL-X86:       # %bb.0:
; GISEL-X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; GISEL-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; GISEL-X86-NEXT:    xorb %cl, %al
; GISEL-X86-NEXT:    # kill: def $al killed $al killed $eax
; GISEL-X86-NEXT:    retl
;
; SDAG-X64-LABEL: xor_i8:
; SDAG-X64:       # %bb.0:
; SDAG-X64-NEXT:    movl %edi, %eax
; SDAG-X64-NEXT:    xorl %esi, %eax
; SDAG-X64-NEXT:    # kill: def $al killed $al killed $eax
; SDAG-X64-NEXT:    retq
;
; FASTISEL-X64-LABEL: xor_i8:
; FASTISEL-X64:       # %bb.0:
; FASTISEL-X64-NEXT:    movl %edi, %eax
; FASTISEL-X64-NEXT:    xorb %sil, %al
; FASTISEL-X64-NEXT:    # kill: def $al killed $al killed $eax
; FASTISEL-X64-NEXT:    retq
;
; GISEL-X64-LABEL: xor_i8:
; GISEL-X64:       # %bb.0:
; GISEL-X64-NEXT:    movl %esi, %eax
; GISEL-X64-NEXT:    xorb %dil, %al
; GISEL-X64-NEXT:    # kill: def $al killed $al killed $eax
; GISEL-X64-NEXT:    retq
  %c = xor i8 %a, %b
  ret i8 %c
}

define i16 @xor_i16(i16 %a, i16 %b) {
; SDAG-X86-LABEL: xor_i16:
; SDAG-X86:       # %bb.0:
; SDAG-X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; SDAG-X86-NEXT:    xorw {{[0-9]+}}(%esp), %ax
; SDAG-X86-NEXT:    retl
;
; FASTISEL-X86-LABEL: xor_i16:
; FASTISEL-X86:       # %bb.0:
; FASTISEL-X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; FASTISEL-X86-NEXT:    xorw {{[0-9]+}}(%esp), %ax
; FASTISEL-X86-NEXT:    retl
;
; GISEL-X86-LABEL: xor_i16:
; GISEL-X86:       # %bb.0:
; GISEL-X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; GISEL-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; GISEL-X86-NEXT:    xorw %cx, %ax
; GISEL-X86-NEXT:    # kill: def $ax killed $ax killed $eax
; GISEL-X86-NEXT:    retl
;
; SDAG-X64-LABEL: xor_i16:
; SDAG-X64:       # %bb.0:
; SDAG-X64-NEXT:    movl %edi, %eax
; SDAG-X64-NEXT:    xorl %esi, %eax
; SDAG-X64-NEXT:    # kill: def $ax killed $ax killed $eax
; SDAG-X64-NEXT:    retq
;
; FASTISEL-X64-LABEL: xor_i16:
; FASTISEL-X64:       # %bb.0:
; FASTISEL-X64-NEXT:    movl %edi, %eax
; FASTISEL-X64-NEXT:    xorw %si, %ax
; FASTISEL-X64-NEXT:    # kill: def $ax killed $ax killed $eax
; FASTISEL-X64-NEXT:    retq
;
; GISEL-X64-LABEL: xor_i16:
; GISEL-X64:       # %bb.0:
; GISEL-X64-NEXT:    movl %esi, %eax
; GISEL-X64-NEXT:    xorw %di, %ax
; GISEL-X64-NEXT:    # kill: def $ax killed $ax killed $eax
; GISEL-X64-NEXT:    retq
  %c = xor i16 %a, %b
  ret i16 %c
}

define i32 @xor_i32(i32 %a, i32 %b) {
; X86-LABEL: xor_i32:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    xorl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    retl
;
; SDAG-X64-LABEL: xor_i32:
; SDAG-X64:       # %bb.0:
; SDAG-X64-NEXT:    movl %edi, %eax
; SDAG-X64-NEXT:    xorl %esi, %eax
; SDAG-X64-NEXT:    retq
;
; FASTISEL-X64-LABEL: xor_i32:
; FASTISEL-X64:       # %bb.0:
; FASTISEL-X64-NEXT:    movl %edi, %eax
; FASTISEL-X64-NEXT:    xorl %esi, %eax
; FASTISEL-X64-NEXT:    retq
;
; GISEL-X64-LABEL: xor_i32:
; GISEL-X64:       # %bb.0:
; GISEL-X64-NEXT:    movl %esi, %eax
; GISEL-X64-NEXT:    xorl %edi, %eax
; GISEL-X64-NEXT:    retq
  %c = xor i32 %a, %b
  ret i32 %c
}

define i64 @xor_i64(i64 %a, i64 %b) nounwind {
; SDAG-X86-LABEL: xor_i64:
; SDAG-X86:       # %bb.0:
; SDAG-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; SDAG-X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; SDAG-X86-NEXT:    xorl {{[0-9]+}}(%esp), %eax
; SDAG-X86-NEXT:    xorl {{[0-9]+}}(%esp), %edx
; SDAG-X86-NEXT:    retl
;
; FASTISEL-X86-LABEL: xor_i64:
; FASTISEL-X86:       # %bb.0:
; FASTISEL-X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; FASTISEL-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; FASTISEL-X86-NEXT:    xorl {{[0-9]+}}(%esp), %eax
; FASTISEL-X86-NEXT:    xorl {{[0-9]+}}(%esp), %edx
; FASTISEL-X86-NEXT:    retl
;
; GISEL-X86-LABEL: xor_i64:
; GISEL-X86:       # %bb.0:
; GISEL-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; GISEL-X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; GISEL-X86-NEXT:    xorl {{[0-9]+}}(%esp), %eax
; GISEL-X86-NEXT:    xorl {{[0-9]+}}(%esp), %edx
; GISEL-X86-NEXT:    retl
;
; SDAG-X64-LABEL: xor_i64:
; SDAG-X64:       # %bb.0:
; SDAG-X64-NEXT:    movq %rdi, %rax
; SDAG-X64-NEXT:    xorq %rsi, %rax
; SDAG-X64-NEXT:    retq
;
; FASTISEL-X64-LABEL: xor_i64:
; FASTISEL-X64:       # %bb.0:
; FASTISEL-X64-NEXT:    movq %rdi, %rax
; FASTISEL-X64-NEXT:    xorq %rsi, %rax
; FASTISEL-X64-NEXT:    retq
;
; GISEL-X64-LABEL: xor_i64:
; GISEL-X64:       # %bb.0:
; GISEL-X64-NEXT:    movq %rsi, %rax
; GISEL-X64-NEXT:    xorq %rdi, %rax
; GISEL-X64-NEXT:    retq
  %c = xor i64 %a, %b
  ret i64 %c
}

define i8 @xor_imm8_i8(i8 %a) {
; SDAG-X86-LABEL: xor_imm8_i8:
; SDAG-X86:       # %bb.0:
; SDAG-X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; SDAG-X86-NEXT:    xorb $1, %al
; SDAG-X86-NEXT:    retl
;
; FASTISEL-X86-LABEL: xor_imm8_i8:
; FASTISEL-X86:       # %bb.0:
; FASTISEL-X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; FASTISEL-X86-NEXT:    xorb $1, %al
; FASTISEL-X86-NEXT:    retl
;
; GISEL-X86-LABEL: xor_imm8_i8:
; GISEL-X86:       # %bb.0:
; GISEL-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; GISEL-X86-NEXT:    xorb $1, %al
; GISEL-X86-NEXT:    # kill: def $al killed $al killed $eax
; GISEL-X86-NEXT:    retl
;
; X64-LABEL: xor_imm8_i8:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    xorb $1, %al
; X64-NEXT:    # kill: def $al killed $al killed $eax
; X64-NEXT:    retq
  %c = xor i8 %a, 1
  ret i8 %c
}

define i16 @xor_imm8_i16(i16 %a) {
; SDAG-X86-LABEL: xor_imm8_i16:
; SDAG-X86:       # %bb.0:
; SDAG-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; SDAG-X86-NEXT:    xorl $6, %eax
; SDAG-X86-NEXT:    # kill: def $ax killed $ax killed $eax
; SDAG-X86-NEXT:    retl
;
; FASTISEL-X86-LABEL: xor_imm8_i16:
; FASTISEL-X86:       # %bb.0:
; FASTISEL-X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; FASTISEL-X86-NEXT:    xorw $6, %ax
; FASTISEL-X86-NEXT:    retl
;
; GISEL-X86-LABEL: xor_imm8_i16:
; GISEL-X86:       # %bb.0:
; GISEL-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; GISEL-X86-NEXT:    xorw $6, %ax
; GISEL-X86-NEXT:    # kill: def $ax killed $ax killed $eax
; GISEL-X86-NEXT:    retl
;
; SDAG-X64-LABEL: xor_imm8_i16:
; SDAG-X64:       # %bb.0:
; SDAG-X64-NEXT:    movl %edi, %eax
; SDAG-X64-NEXT:    xorl $6, %eax
; SDAG-X64-NEXT:    # kill: def $ax killed $ax killed $eax
; SDAG-X64-NEXT:    retq
;
; FASTISEL-X64-LABEL: xor_imm8_i16:
; FASTISEL-X64:       # %bb.0:
; FASTISEL-X64-NEXT:    movl %edi, %eax
; FASTISEL-X64-NEXT:    xorw $6, %ax
; FASTISEL-X64-NEXT:    # kill: def $ax killed $ax killed $eax
; FASTISEL-X64-NEXT:    retq
;
; GISEL-X64-LABEL: xor_imm8_i16:
; GISEL-X64:       # %bb.0:
; GISEL-X64-NEXT:    movl %edi, %eax
; GISEL-X64-NEXT:    xorw $6, %ax
; GISEL-X64-NEXT:    # kill: def $ax killed $ax killed $eax
; GISEL-X64-NEXT:    retq
  %c = xor i16 %a, 6
  ret i16 %c
}

define i32 @xor_imm8_i32(i32 %a) {
; X86-LABEL: xor_imm8_i32:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    xorl $-5, %eax
; X86-NEXT:    retl
;
; X64-LABEL: xor_imm8_i32:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    xorl $-5, %eax
; X64-NEXT:    retq
  %c = xor i32 %a, -5
  ret i32 %c
}

define i64 @xor_imm8_i64(i64 %a) {
; SDAG-X86-LABEL: xor_imm8_i64:
; SDAG-X86:       # %bb.0:
; SDAG-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; SDAG-X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; SDAG-X86-NEXT:    xorl $1, %eax
; SDAG-X86-NEXT:    retl
;
; FASTISEL-X86-LABEL: xor_imm8_i64:
; FASTISEL-X86:       # %bb.0:
; FASTISEL-X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; FASTISEL-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; FASTISEL-X86-NEXT:    xorl $1, %eax
; FASTISEL-X86-NEXT:    retl
;
; GISEL-X86-LABEL: xor_imm8_i64:
; GISEL-X86:       # %bb.0:
; GISEL-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; GISEL-X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; GISEL-X86-NEXT:    xorl $1, %eax
; GISEL-X86-NEXT:    xorl $0, %edx
; GISEL-X86-NEXT:    retl
;
; X64-LABEL: xor_imm8_i64:
; X64:       # %bb.0:
; X64-NEXT:    movq %rdi, %rax
; X64-NEXT:    xorq $1, %rax
; X64-NEXT:    retq
  %c = xor i64 %a, 1
  ret i64 %c
}

define i16 @xor_imm16_i16(i16 %a) {
; SDAG-X86-LABEL: xor_imm16_i16:
; SDAG-X86:       # %bb.0:
; SDAG-X86-NEXT:    movl $1023, %eax # imm = 0x3FF
; SDAG-X86-NEXT:    xorl {{[0-9]+}}(%esp), %eax
; SDAG-X86-NEXT:    # kill: def $ax killed $ax killed $eax
; SDAG-X86-NEXT:    retl
;
; FASTISEL-X86-LABEL: xor_imm16_i16:
; FASTISEL-X86:       # %bb.0:
; FASTISEL-X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; FASTISEL-X86-NEXT:    xorw $1023, %ax # imm = 0x3FF
; FASTISEL-X86-NEXT:    retl
;
; GISEL-X86-LABEL: xor_imm16_i16:
; GISEL-X86:       # %bb.0:
; GISEL-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; GISEL-X86-NEXT:    xorw $1023, %ax # imm = 0x3FF
; GISEL-X86-NEXT:    # kill: def $ax killed $ax killed $eax
; GISEL-X86-NEXT:    retl
;
; SDAG-X64-LABEL: xor_imm16_i16:
; SDAG-X64:       # %bb.0:
; SDAG-X64-NEXT:    movl %edi, %eax
; SDAG-X64-NEXT:    xorl $1023, %eax # imm = 0x3FF
; SDAG-X64-NEXT:    # kill: def $ax killed $ax killed $eax
; SDAG-X64-NEXT:    retq
;
; FASTISEL-X64-LABEL: xor_imm16_i16:
; FASTISEL-X64:       # %bb.0:
; FASTISEL-X64-NEXT:    movl %edi, %eax
; FASTISEL-X64-NEXT:    xorw $1023, %ax # imm = 0x3FF
; FASTISEL-X64-NEXT:    # kill: def $ax killed $ax killed $eax
; FASTISEL-X64-NEXT:    retq
;
; GISEL-X64-LABEL: xor_imm16_i16:
; GISEL-X64:       # %bb.0:
; GISEL-X64-NEXT:    movl %edi, %eax
; GISEL-X64-NEXT:    xorw $1023, %ax # imm = 0x3FF
; GISEL-X64-NEXT:    # kill: def $ax killed $ax killed $eax
; GISEL-X64-NEXT:    retq
  %c = xor i16 %a, 1023
  ret i16 %c
}

define i32 @xor_imm16_i32(i32 %a) {
; SDAG-X86-LABEL: xor_imm16_i32:
; SDAG-X86:       # %bb.0:
; SDAG-X86-NEXT:    movl $2044, %eax # imm = 0x7FC
; SDAG-X86-NEXT:    xorl {{[0-9]+}}(%esp), %eax
; SDAG-X86-NEXT:    retl
;
; FASTISEL-X86-LABEL: xor_imm16_i32:
; FASTISEL-X86:       # %bb.0:
; FASTISEL-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; FASTISEL-X86-NEXT:    xorl $2044, %eax # imm = 0x7FC
; FASTISEL-X86-NEXT:    retl
;
; GISEL-X86-LABEL: xor_imm16_i32:
; GISEL-X86:       # %bb.0:
; GISEL-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; GISEL-X86-NEXT:    xorl $2044, %eax # imm = 0x7FC
; GISEL-X86-NEXT:    retl
;
; X64-LABEL: xor_imm16_i32:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    xorl $2044, %eax # imm = 0x7FC
; X64-NEXT:    retq
  %c = xor i32 %a, 2044
  ret i32 %c
}

define i64 @xor_imm16_i64(i64 %a) {
; SDAG-X86-LABEL: xor_imm16_i64:
; SDAG-X86:       # %bb.0:
; SDAG-X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; SDAG-X86-NEXT:    movl $-5022, %eax # imm = 0xEC62
; SDAG-X86-NEXT:    xorl {{[0-9]+}}(%esp), %eax
; SDAG-X86-NEXT:    notl %edx
; SDAG-X86-NEXT:    retl
;
; FASTISEL-X86-LABEL: xor_imm16_i64:
; FASTISEL-X86:       # %bb.0:
; FASTISEL-X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; FASTISEL-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; FASTISEL-X86-NEXT:    xorl $-5022, %eax # imm = 0xEC62
; FASTISEL-X86-NEXT:    notl %edx
; FASTISEL-X86-NEXT:    retl
;
; GISEL-X86-LABEL: xor_imm16_i64:
; GISEL-X86:       # %bb.0:
; GISEL-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; GISEL-X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; GISEL-X86-NEXT:    xorl $-5022, %eax # imm = 0xEC62
; GISEL-X86-NEXT:    notl %edx
; GISEL-X86-NEXT:    retl
;
; X64-LABEL: xor_imm16_i64:
; X64:       # %bb.0:
; X64-NEXT:    movq %rdi, %rax
; X64-NEXT:    xorq $-5022, %rax # imm = 0xEC62
; X64-NEXT:    retq
  %c = xor i64 %a, -5022
  ret i64 %c
}

define i32 @xor_imm32_i32(i32 %a) {
; SDAG-X86-LABEL: xor_imm32_i32:
; SDAG-X86:       # %bb.0:
; SDAG-X86-NEXT:    movl $85538, %eax # imm = 0x14E22
; SDAG-X86-NEXT:    xorl {{[0-9]+}}(%esp), %eax
; SDAG-X86-NEXT:    retl
;
; FASTISEL-X86-LABEL: xor_imm32_i32:
; FASTISEL-X86:       # %bb.0:
; FASTISEL-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; FASTISEL-X86-NEXT:    xorl $85538, %eax # imm = 0x14E22
; FASTISEL-X86-NEXT:    retl
;
; GISEL-X86-LABEL: xor_imm32_i32:
; GISEL-X86:       # %bb.0:
; GISEL-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; GISEL-X86-NEXT:    xorl $85538, %eax # imm = 0x14E22
; GISEL-X86-NEXT:    retl
;
; X64-LABEL: xor_imm32_i32:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    xorl $85538, %eax # imm = 0x14E22
; X64-NEXT:    retq
  %c = xor i32 %a, 85538
  ret i32 %c
}

define i64 @xor_imm32_i64(i64 %a) {
; SDAG-X86-LABEL: xor_imm32_i64:
; SDAG-X86:       # %bb.0:
; SDAG-X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; SDAG-X86-NEXT:    movl $-125778, %eax # imm = 0xFFFE14AE
; SDAG-X86-NEXT:    xorl {{[0-9]+}}(%esp), %eax
; SDAG-X86-NEXT:    notl %edx
; SDAG-X86-NEXT:    retl
;
; FASTISEL-X86-LABEL: xor_imm32_i64:
; FASTISEL-X86:       # %bb.0:
; FASTISEL-X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; FASTISEL-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; FASTISEL-X86-NEXT:    xorl $-125778, %eax # imm = 0xFFFE14AE
; FASTISEL-X86-NEXT:    notl %edx
; FASTISEL-X86-NEXT:    retl
;
; GISEL-X86-LABEL: xor_imm32_i64:
; GISEL-X86:       # %bb.0:
; GISEL-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; GISEL-X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; GISEL-X86-NEXT:    xorl $-125778, %eax # imm = 0xFFFE14AE
; GISEL-X86-NEXT:    notl %edx
; GISEL-X86-NEXT:    retl
;
; X64-LABEL: xor_imm32_i64:
; X64:       # %bb.0:
; X64-NEXT:    movq %rdi, %rax
; X64-NEXT:    xorq $-125778, %rax # imm = 0xFFFE14AE
; X64-NEXT:    retq
  %c = xor i64 %a, -125778
  ret i64 %c
}

define i64 @xor_imm64_i64(i64 %a) {
; SDAG-X86-LABEL: xor_imm64_i64:
; SDAG-X86:       # %bb.0:
; SDAG-X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; SDAG-X86-NEXT:    movl $-1850691612, %eax # imm = 0x91B0AFE4
; SDAG-X86-NEXT:    xorl {{[0-9]+}}(%esp), %eax
; SDAG-X86-NEXT:    xorl $-2, %edx
; SDAG-X86-NEXT:    retl
;
; FASTISEL-X86-LABEL: xor_imm64_i64:
; FASTISEL-X86:       # %bb.0:
; FASTISEL-X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; FASTISEL-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; FASTISEL-X86-NEXT:    xorl $-1850691612, %eax # imm = 0x91B0AFE4
; FASTISEL-X86-NEXT:    xorl $-2, %edx
; FASTISEL-X86-NEXT:    retl
;
; GISEL-X86-LABEL: xor_imm64_i64:
; GISEL-X86:       # %bb.0:
; GISEL-X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; GISEL-X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; GISEL-X86-NEXT:    xorl $-1850691612, %eax # imm = 0x91B0AFE4
; GISEL-X86-NEXT:    xorl $-2, %edx
; GISEL-X86-NEXT:    retl
;
; X64-LABEL: xor_imm64_i64:
; X64:       # %bb.0:
; X64-NEXT:    movabsq $-6145658908, %rax # imm = 0xFFFFFFFE91B0AFE4
; X64-NEXT:    xorq %rdi, %rax
; X64-NEXT:    retq
  %c = xor i64 %a, -6145658908
  ret i64 %c
}
