; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --check-globals all --version 5
; RUN: opt < %s -passes='bounds-checking<trap;merge>'   -S | FileCheck %s --check-prefixes=TR
; RUN: opt < %s -passes='bounds-checking<rt;merge>'     -S | FileCheck %s --check-prefixes=RT

; RUN: opt < %s -passes=bounds-checking                 -S | FileCheck %s --check-prefixes=TR-NOMERGE
; RUN: opt < %s -passes='bounds-checking<trap>'         -S | FileCheck %s --check-prefixes=TR-NOMERGE
; RUN: opt < %s -passes='bounds-checking<rt>'           -S | FileCheck %s --check-prefixes=RT-NOMERGE
; RUN: opt < %s -passes='bounds-checking<rt-abort>'     -S | FileCheck %s --check-prefixes=RTABORT-NOMERGE
; RUN: opt < %s -passes='bounds-checking<min-rt>'       -S | FileCheck %s --check-prefixes=MINRT-NOMERGE
; RUN: opt < %s -passes='bounds-checking<min-rt-abort>' -S | FileCheck %s --check-prefixes=MINRTABORT-NOMERGE
;
; RUN: opt < %s -passes='bounds-checking<trap;guard=3>'   -S | FileCheck %s --check-prefixes=TR-GUARD-COMMON,TR-GUARD-THREE
; RUN: opt < %s -passes='bounds-checking<trap;guard=13>'   -S | FileCheck %s --check-prefixes=TR-GUARD-COMMON,TR-GUARD-THIRTEEN
; RUN: opt < %s -passes='bounds-checking<rt;guard=-5>'     -S | FileCheck %s --check-prefixes=RT-GUARD
target datalayout = "e-p:64:64:64-i1:8:8-i8:8:8-i16:16:16-i32:32:32-i64:64:64-f32:32:32-f64:64:64-v64:64:64-v128:128:128-a0:0:64-s0:64:64-f80:128:128-n8:16:32:64-S128"

define void @f1(i64 %x) nounwind {
; TR-LABEL: define void @f1(
; TR-SAME: i64 [[X:%.*]]) #[[ATTR0:[0-9]+]] {
; TR-NEXT:    [[TMP1:%.*]] = mul i64 16, [[X]]
; TR-NEXT:    [[TMP2:%.*]] = alloca i128, i64 [[X]], align 8
; TR-NEXT:    [[TMP3:%.*]] = sub i64 [[TMP1]], 0, !nosanitize [[META0:![0-9]+]]
; TR-NEXT:    [[TMP4:%.*]] = icmp ult i64 [[TMP3]], 16, !nosanitize [[META0]]
; TR-NEXT:    [[TMP5:%.*]] = or i1 false, [[TMP4]], !nosanitize [[META0]]
; TR-NEXT:    [[TMP6:%.*]] = or i1 false, [[TMP5]], !nosanitize [[META0]]
; TR-NEXT:    br i1 [[TMP6]], label %[[TRAP:.*]], label %[[BB7:.*]]
; TR:       [[BB7]]:
; TR-NEXT:    [[TMP8:%.*]] = load i128, ptr [[TMP2]], align 4
; TR-NEXT:    ret void
; TR:       [[TRAP]]:
; TR-NEXT:    call void @llvm.trap() #[[ATTR2:[0-9]+]], !nosanitize [[META0]]
; TR-NEXT:    unreachable, !nosanitize [[META0]]
;
; RT-LABEL: define void @f1(
; RT-SAME: i64 [[X:%.*]]) #[[ATTR0:[0-9]+]] {
; RT-NEXT:    [[TMP1:%.*]] = mul i64 16, [[X]]
; RT-NEXT:    [[TMP2:%.*]] = alloca i128, i64 [[X]], align 8
; RT-NEXT:    [[TMP3:%.*]] = sub i64 [[TMP1]], 0, !nosanitize [[META0:![0-9]+]]
; RT-NEXT:    [[TMP4:%.*]] = icmp ult i64 [[TMP3]], 16, !nosanitize [[META0]]
; RT-NEXT:    [[TMP5:%.*]] = or i1 false, [[TMP4]], !nosanitize [[META0]]
; RT-NEXT:    [[TMP6:%.*]] = or i1 false, [[TMP5]], !nosanitize [[META0]]
; RT-NEXT:    br i1 [[TMP6]], label %[[TRAP:.*]], label %[[BB7:.*]]
; RT:       [[BB7]]:
; RT-NEXT:    [[TMP8:%.*]] = load i128, ptr [[TMP2]], align 4
; RT-NEXT:    ret void
; RT:       [[TRAP]]:
; RT-NEXT:    call void @__ubsan_handle_local_out_of_bounds() #[[ATTR0]], !nosanitize [[META0]]
; RT-NEXT:    br label %[[BB7]], !nosanitize [[META0]]
;
; TR-NOMERGE-LABEL: define void @f1(
; TR-NOMERGE-SAME: i64 [[X:%.*]]) #[[ATTR0:[0-9]+]] {
; TR-NOMERGE-NEXT:    [[TMP1:%.*]] = mul i64 16, [[X]]
; TR-NOMERGE-NEXT:    [[TMP2:%.*]] = alloca i128, i64 [[X]], align 8
; TR-NOMERGE-NEXT:    [[TMP3:%.*]] = sub i64 [[TMP1]], 0, !nosanitize [[META0:![0-9]+]]
; TR-NOMERGE-NEXT:    [[TMP4:%.*]] = icmp ult i64 [[TMP3]], 16, !nosanitize [[META0]]
; TR-NOMERGE-NEXT:    [[TMP5:%.*]] = or i1 false, [[TMP4]], !nosanitize [[META0]]
; TR-NOMERGE-NEXT:    [[TMP6:%.*]] = or i1 false, [[TMP5]], !nosanitize [[META0]]
; TR-NOMERGE-NEXT:    br i1 [[TMP6]], label %[[TRAP:.*]], label %[[BB7:.*]]
; TR-NOMERGE:       [[BB7]]:
; TR-NOMERGE-NEXT:    [[TMP8:%.*]] = load i128, ptr [[TMP2]], align 4
; TR-NOMERGE-NEXT:    ret void
; TR-NOMERGE:       [[TRAP]]:
; TR-NOMERGE-NEXT:    call void @llvm.ubsantrap(i8 3) #[[ATTR2:[0-9]+]], !nosanitize [[META0]]
; TR-NOMERGE-NEXT:    unreachable, !nosanitize [[META0]]
;
; RT-NOMERGE-LABEL: define void @f1(
; RT-NOMERGE-SAME: i64 [[X:%.*]]) #[[ATTR0:[0-9]+]] {
; RT-NOMERGE-NEXT:    [[TMP1:%.*]] = mul i64 16, [[X]]
; RT-NOMERGE-NEXT:    [[TMP2:%.*]] = alloca i128, i64 [[X]], align 8
; RT-NOMERGE-NEXT:    [[TMP3:%.*]] = sub i64 [[TMP1]], 0, !nosanitize [[META0:![0-9]+]]
; RT-NOMERGE-NEXT:    [[TMP4:%.*]] = icmp ult i64 [[TMP3]], 16, !nosanitize [[META0]]
; RT-NOMERGE-NEXT:    [[TMP5:%.*]] = or i1 false, [[TMP4]], !nosanitize [[META0]]
; RT-NOMERGE-NEXT:    [[TMP6:%.*]] = or i1 false, [[TMP5]], !nosanitize [[META0]]
; RT-NOMERGE-NEXT:    br i1 [[TMP6]], label %[[TRAP:.*]], label %[[BB7:.*]]
; RT-NOMERGE:       [[BB7]]:
; RT-NOMERGE-NEXT:    [[TMP8:%.*]] = load i128, ptr [[TMP2]], align 4
; RT-NOMERGE-NEXT:    ret void
; RT-NOMERGE:       [[TRAP]]:
; RT-NOMERGE-NEXT:    call void @__ubsan_handle_local_out_of_bounds() #[[ATTR1:[0-9]+]], !nosanitize [[META0]]
; RT-NOMERGE-NEXT:    br label %[[BB7]], !nosanitize [[META0]]
;
; RTABORT-NOMERGE-LABEL: define void @f1(
; RTABORT-NOMERGE-SAME: i64 [[X:%.*]]) #[[ATTR0:[0-9]+]] {
; RTABORT-NOMERGE-NEXT:    [[TMP1:%.*]] = mul i64 16, [[X]]
; RTABORT-NOMERGE-NEXT:    [[TMP2:%.*]] = alloca i128, i64 [[X]], align 8
; RTABORT-NOMERGE-NEXT:    [[TMP3:%.*]] = sub i64 [[TMP1]], 0, !nosanitize [[META0:![0-9]+]]
; RTABORT-NOMERGE-NEXT:    [[TMP4:%.*]] = icmp ult i64 [[TMP3]], 16, !nosanitize [[META0]]
; RTABORT-NOMERGE-NEXT:    [[TMP5:%.*]] = or i1 false, [[TMP4]], !nosanitize [[META0]]
; RTABORT-NOMERGE-NEXT:    [[TMP6:%.*]] = or i1 false, [[TMP5]], !nosanitize [[META0]]
; RTABORT-NOMERGE-NEXT:    br i1 [[TMP6]], label %[[TRAP:.*]], label %[[BB7:.*]]
; RTABORT-NOMERGE:       [[BB7]]:
; RTABORT-NOMERGE-NEXT:    [[TMP8:%.*]] = load i128, ptr [[TMP2]], align 4
; RTABORT-NOMERGE-NEXT:    ret void
; RTABORT-NOMERGE:       [[TRAP]]:
; RTABORT-NOMERGE-NEXT:    call void @__ubsan_handle_local_out_of_bounds_abort() #[[ATTR2:[0-9]+]], !nosanitize [[META0]]
; RTABORT-NOMERGE-NEXT:    unreachable, !nosanitize [[META0]]
;
; MINRT-NOMERGE-LABEL: define void @f1(
; MINRT-NOMERGE-SAME: i64 [[X:%.*]]) #[[ATTR0:[0-9]+]] {
; MINRT-NOMERGE-NEXT:    [[TMP1:%.*]] = mul i64 16, [[X]]
; MINRT-NOMERGE-NEXT:    [[TMP2:%.*]] = alloca i128, i64 [[X]], align 8
; MINRT-NOMERGE-NEXT:    [[TMP3:%.*]] = sub i64 [[TMP1]], 0, !nosanitize [[META0:![0-9]+]]
; MINRT-NOMERGE-NEXT:    [[TMP4:%.*]] = icmp ult i64 [[TMP3]], 16, !nosanitize [[META0]]
; MINRT-NOMERGE-NEXT:    [[TMP5:%.*]] = or i1 false, [[TMP4]], !nosanitize [[META0]]
; MINRT-NOMERGE-NEXT:    [[TMP6:%.*]] = or i1 false, [[TMP5]], !nosanitize [[META0]]
; MINRT-NOMERGE-NEXT:    br i1 [[TMP6]], label %[[TRAP:.*]], label %[[BB7:.*]]
; MINRT-NOMERGE:       [[BB7]]:
; MINRT-NOMERGE-NEXT:    [[TMP8:%.*]] = load i128, ptr [[TMP2]], align 4
; MINRT-NOMERGE-NEXT:    ret void
; MINRT-NOMERGE:       [[TRAP]]:
; MINRT-NOMERGE-NEXT:    call void @__ubsan_handle_local_out_of_bounds_minimal() #[[ATTR1:[0-9]+]], !nosanitize [[META0]]
; MINRT-NOMERGE-NEXT:    br label %[[BB7]], !nosanitize [[META0]]
;
; MINRTABORT-NOMERGE-LABEL: define void @f1(
; MINRTABORT-NOMERGE-SAME: i64 [[X:%.*]]) #[[ATTR0:[0-9]+]] {
; MINRTABORT-NOMERGE-NEXT:    [[TMP1:%.*]] = mul i64 16, [[X]]
; MINRTABORT-NOMERGE-NEXT:    [[TMP2:%.*]] = alloca i128, i64 [[X]], align 8
; MINRTABORT-NOMERGE-NEXT:    [[TMP3:%.*]] = sub i64 [[TMP1]], 0, !nosanitize [[META0:![0-9]+]]
; MINRTABORT-NOMERGE-NEXT:    [[TMP4:%.*]] = icmp ult i64 [[TMP3]], 16, !nosanitize [[META0]]
; MINRTABORT-NOMERGE-NEXT:    [[TMP5:%.*]] = or i1 false, [[TMP4]], !nosanitize [[META0]]
; MINRTABORT-NOMERGE-NEXT:    [[TMP6:%.*]] = or i1 false, [[TMP5]], !nosanitize [[META0]]
; MINRTABORT-NOMERGE-NEXT:    br i1 [[TMP6]], label %[[TRAP:.*]], label %[[BB7:.*]]
; MINRTABORT-NOMERGE:       [[BB7]]:
; MINRTABORT-NOMERGE-NEXT:    [[TMP8:%.*]] = load i128, ptr [[TMP2]], align 4
; MINRTABORT-NOMERGE-NEXT:    ret void
; MINRTABORT-NOMERGE:       [[TRAP]]:
; MINRTABORT-NOMERGE-NEXT:    call void @__ubsan_handle_local_out_of_bounds_minimal_abort() #[[ATTR2:[0-9]+]], !nosanitize [[META0]]
; MINRTABORT-NOMERGE-NEXT:    unreachable, !nosanitize [[META0]]
;
; TR-GUARD-COMMON-LABEL: define void @f1(
; TR-GUARD-COMMON-SAME: i64 [[X:%.*]]) #[[ATTR0:[0-9]+]] {
; TR-GUARD-COMMON-NEXT:    [[TMP1:%.*]] = mul i64 16, [[X]]
; TR-GUARD-COMMON-NEXT:    [[TMP2:%.*]] = alloca i128, i64 [[X]], align 8
; TR-GUARD-COMMON-NEXT:    [[TMP3:%.*]] = sub i64 [[TMP1]], 0, !nosanitize [[META0:![0-9]+]]
; TR-GUARD-COMMON-NEXT:    [[TMP4:%.*]] = icmp ult i64 [[TMP3]], 16, !nosanitize [[META0]]
; TR-GUARD-COMMON-NEXT:    [[TMP5:%.*]] = or i1 false, [[TMP4]], !nosanitize [[META0]]
; TR-GUARD-COMMON-NEXT:    [[TMP6:%.*]] = or i1 false, [[TMP5]], !nosanitize [[META0]]
;
; TR-GUARD-THREE:          [[TMP7:%.*]] = call i1 @llvm.allow.ubsan.check(i8 3), !nosanitize [[META0]]
; TR-GUARD-THIRTEEN:       [[TMP7:%.*]] = call i1 @llvm.allow.ubsan.check(i8 13), !nosanitize [[META0]]
;
; TR-GUARD-COMMON:         [[TMP8:%.*]] = and i1 [[TMP6]], [[TMP7]], !nosanitize [[META0]]
; TR-GUARD-COMMON-NEXT:    br i1 [[TMP8]], label %[[TRAP:.*]], label %[[BB9:.*]]
; TR-GUARD-COMMON:       [[BB9]]:
; TR-GUARD-COMMON-NEXT:    [[TMP10:%.*]] = load i128, ptr [[TMP2]], align 4
; TR-GUARD-COMMON-NEXT:    ret void
; TR-GUARD-COMMON:       [[TRAP]]:
;
; TR-GUARD-THREE:       call void @llvm.ubsantrap(i8 3) #[[ATTR3:[0-9]+]], !nosanitize [[META0]]
; TR-GUARD-THIRTEEN:    call void @llvm.ubsantrap(i8 13) #[[ATTR3:[0-9]+]], !nosanitize [[META0]]
;
; TR-GUARD-COMMON:      unreachable, !nosanitize [[META0]]
;
; RT-GUARD-LABEL: define void @f1(
; RT-GUARD-SAME: i64 [[X:%.*]]) #[[ATTR0:[0-9]+]] {
; RT-GUARD-NEXT:    [[TMP1:%.*]] = mul i64 16, [[X]]
; RT-GUARD-NEXT:    [[TMP2:%.*]] = alloca i128, i64 [[X]], align 8
; RT-GUARD-NEXT:    [[TMP3:%.*]] = sub i64 [[TMP1]], 0, !nosanitize [[META0:![0-9]+]]
; RT-GUARD-NEXT:    [[TMP4:%.*]] = icmp ult i64 [[TMP3]], 16, !nosanitize [[META0]]
; RT-GUARD-NEXT:    [[TMP5:%.*]] = or i1 false, [[TMP4]], !nosanitize [[META0]]
; RT-GUARD-NEXT:    [[TMP6:%.*]] = or i1 false, [[TMP5]], !nosanitize [[META0]]
; RT-GUARD-NEXT:    [[TMP7:%.*]] = call i1 @llvm.allow.ubsan.check(i8 -5), !nosanitize [[META0]]
; RT-GUARD-NEXT:    [[TMP8:%.*]] = and i1 [[TMP6]], [[TMP7]], !nosanitize [[META0]]
; RT-GUARD-NEXT:    br i1 [[TMP8]], label %[[TRAP:.*]], label %[[BB9:.*]]
; RT-GUARD:       [[BB9]]:
; RT-GUARD-NEXT:    [[TMP10:%.*]] = load i128, ptr [[TMP2]], align 4
; RT-GUARD-NEXT:    ret void
; RT-GUARD:       [[TRAP]]:
; RT-GUARD-NEXT:    call void @__ubsan_handle_local_out_of_bounds() #[[ATTR2:[0-9]+]], !nosanitize [[META0]]
; RT-GUARD-NEXT:    br label %[[BB9]], !nosanitize [[META0]]
;
  %1 = alloca i128, i64 %x
  %3 = load i128, ptr %1, align 4
  ret void
}

;.
; TR: attributes #[[ATTR0]] = { nounwind }
; TR: attributes #[[ATTR1:[0-9]+]] = { cold noreturn nounwind memory(inaccessiblemem: write) }
; TR: attributes #[[ATTR2]] = { noreturn nounwind }
;.
; RT: attributes #[[ATTR0]] = { nounwind }
;.
; TR-NOMERGE: attributes #[[ATTR0]] = { nounwind }
; TR-NOMERGE: attributes #[[ATTR1:[0-9]+]] = { cold noreturn nounwind }
; TR-NOMERGE: attributes #[[ATTR2]] = { nomerge noreturn nounwind }
;.
; RT-NOMERGE: attributes #[[ATTR0]] = { nounwind }
; RT-NOMERGE: attributes #[[ATTR1]] = { nomerge nounwind }
;.
; RTABORT-NOMERGE: attributes #[[ATTR0]] = { nounwind }
; RTABORT-NOMERGE: attributes #[[ATTR1:[0-9]+]] = { noreturn nounwind }
; RTABORT-NOMERGE: attributes #[[ATTR2]] = { nomerge noreturn nounwind }
;.
; MINRT-NOMERGE: attributes #[[ATTR0]] = { nounwind }
; MINRT-NOMERGE: attributes #[[ATTR1]] = { nomerge nounwind }
;.
; MINRTABORT-NOMERGE: attributes #[[ATTR0]] = { nounwind }
; MINRTABORT-NOMERGE: attributes #[[ATTR1:[0-9]+]] = { noreturn nounwind }
; MINRTABORT-NOMERGE: attributes #[[ATTR2]] = { nomerge noreturn nounwind }
;.
; TR-GUARD: attributes #[[ATTR0]] = { nounwind }
; TR-GUARD: attributes #[[ATTR1:[0-9]+]] = { nocallback nofree nosync nounwind willreturn memory(inaccessiblemem: write) }
; TR-GUARD: attributes #[[ATTR2:[0-9]+]] = { cold noreturn nounwind }
; TR-GUARD: attributes #[[ATTR3]] = { nomerge noreturn nounwind }
;.
; RT-GUARD: attributes #[[ATTR0]] = { nounwind }
; RT-GUARD: attributes #[[ATTR1:[0-9]+]] = { nocallback nofree nosync nounwind willreturn memory(inaccessiblemem: write) }
; RT-GUARD: attributes #[[ATTR2]] = { nomerge nounwind }
;.
; TR: [[META0]] = !{}
;.
; RT: [[META0]] = !{}
;.
; TR-NOMERGE: [[META0]] = !{}
;.
; RT-NOMERGE: [[META0]] = !{}
;.
; RTABORT-NOMERGE: [[META0]] = !{}
;.
; MINRT-NOMERGE: [[META0]] = !{}
;.
; MINRTABORT-NOMERGE: [[META0]] = !{}
;.
; TR-GUARD: [[META0]] = !{}
;.
; RT-GUARD: [[META0]] = !{}
;.
