; NOTE: Assertions have been autogenerated by utils/update_analyze_test_checks.py UTC_ARGS: --version 4
; RUN: opt -S -disable-output "-passes=print<scalar-evolution>" -scalar-evolution-classify-expressions=0 < %s 2>&1 | FileCheck %s

define void @u_0(i8 %rhs) {
; E.g.: %rhs = 255, %start = 99, backedge taken 156 times
;
; CHECK-LABEL: 'u_0'
; CHECK-NEXT:  Determining loop execution counts for: @u_0
; CHECK-NEXT:  Loop %loop: backedge-taken count is (-100 + (-1 * %rhs) + ((100 + %rhs) umax %rhs))
; CHECK-NEXT:  Loop %loop: constant max backedge-taken count is i8 -100, actual taken count either this or zero.
; CHECK-NEXT:  Loop %loop: symbolic max backedge-taken count is (-100 + (-1 * %rhs) + ((100 + %rhs) umax %rhs)), actual taken count either this or zero.
; CHECK-NEXT:  Loop %loop: Trip multiple is 1
;
entry:
  %start = add i8 %rhs, 100
  br label %loop

loop:
  %iv = phi i8 [ %start, %entry ], [ %iv.inc, %loop ]
  %iv.inc = add nuw i8 %iv, 1  ;; Note: this never unsigned-wraps
  %iv.cmp = icmp ult i8 %iv, %rhs
  br i1 %iv.cmp, label %loop, label %leave


leave:
  ret void
}

define void @u_1(i8 %start) {
;
; CHECK-LABEL: 'u_1'
; CHECK-NEXT:  Determining loop execution counts for: @u_1
; CHECK-NEXT:  Loop %loop: backedge-taken count is ((-1 * %start) + ((-100 + %start) umax %start))
; CHECK-NEXT:  Loop %loop: constant max backedge-taken count is i8 -100, actual taken count either this or zero.
; CHECK-NEXT:  Loop %loop: symbolic max backedge-taken count is ((-1 * %start) + ((-100 + %start) umax %start)), actual taken count either this or zero.
; CHECK-NEXT:  Loop %loop: Trip multiple is 1
;
entry:
; E.g.: %start = 99, %rhs = 255, backedge taken 156 times
  %rhs = add i8 %start, -100
  br label %loop

loop:
  %iv = phi i8 [ %start, %entry ], [ %iv.inc, %loop ]
  %iv.inc = add nuw i8 %iv, 1  ;; Note: this never unsigned-wraps
  %iv.cmp = icmp ult i8 %iv, %rhs
  br i1 %iv.cmp, label %loop, label %leave


leave:
  ret void
}

define void @s_0(i8 %rhs) {
;
; CHECK-LABEL: 's_0'
; CHECK-NEXT:  Determining loop execution counts for: @s_0
; CHECK-NEXT:  Loop %loop: backedge-taken count is (-100 + (-1 * %rhs) + ((100 + %rhs) smax %rhs))
; CHECK-NEXT:  Loop %loop: constant max backedge-taken count is i8 -100, actual taken count either this or zero.
; CHECK-NEXT:  Loop %loop: symbolic max backedge-taken count is (-100 + (-1 * %rhs) + ((100 + %rhs) smax %rhs)), actual taken count either this or zero.
; CHECK-NEXT:  Loop %loop: Trip multiple is 1
;
entry:
; E.g.: %rhs = 127, %start = -29, backedge taken 156 times
  %start = add i8 %rhs, 100
  br label %loop

loop:
  %iv = phi i8 [ %start, %entry ], [ %iv.inc, %loop ]
  %iv.inc = add nsw i8 %iv, 1  ;; Note: this never signed-wraps
  %iv.cmp = icmp slt i8 %iv, %rhs
  br i1 %iv.cmp, label %loop, label %leave


leave:
  ret void
}

define void @s_1(i8 %start) {
;
; CHECK-LABEL: 's_1'
; CHECK-NEXT:  Determining loop execution counts for: @s_1
; CHECK-NEXT:  Loop %loop: backedge-taken count is ((-1 * %start) + ((-100 + %start) smax %start))
; CHECK-NEXT:  Loop %loop: constant max backedge-taken count is i8 -100, actual taken count either this or zero.
; CHECK-NEXT:  Loop %loop: symbolic max backedge-taken count is ((-1 * %start) + ((-100 + %start) smax %start)), actual taken count either this or zero.
; CHECK-NEXT:  Loop %loop: Trip multiple is 1
;
entry:
; E.g.: start = -29, %rhs = 127, %backedge taken 156 times
  %rhs = add i8 %start, -100
  br label %loop

loop:
  %iv = phi i8 [ %start, %entry ], [ %iv.inc, %loop ]
  %iv.inc = add nsw i8 %iv, 1
  %iv.cmp = icmp slt i8 %iv, %rhs
  br i1 %iv.cmp, label %loop, label %leave


leave:
  ret void
}

define void @s_2(i8 %start) {
;
; CHECK-LABEL: 's_2'
; CHECK-NEXT:  Determining loop execution counts for: @s_2
; CHECK-NEXT:  Loop %loop: backedge-taken count is ((-1 * ((-100 + %start) smin %start)) + %start)
; CHECK-NEXT:  Loop %loop: constant max backedge-taken count is i8 -1
; CHECK-NEXT:  Loop %loop: symbolic max backedge-taken count is ((-1 * ((-100 + %start) smin %start)) + %start)
; CHECK-NEXT:  Loop %loop: Trip multiple is 1
;
entry:
  %rhs = add i8 %start, -100
  br label %loop

loop:
  %iv = phi i8 [ %start, %entry ], [ %iv.inc, %loop ]
  %iv.inc = add nsw i8 %iv, -1
  %iv.cmp = icmp sgt i8 %iv, %rhs
  br i1 %iv.cmp, label %loop, label %leave


leave:
  ret void
}
